package com.hubspot.slack.client.models.events.app;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TokensRevokedIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code TokensRevoked.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TokensRevokedIF"})
@Immutable
public final class TokensRevoked implements TokensRevokedIF {
  private final List<String> oauth;
  private final List<String> bot;

  private TokensRevoked(List<String> oauth, List<String> bot) {
    this.oauth = oauth;
    this.bot = bot;
  }

  /**
   * @return The value of the {@code oauth} attribute
   */
  @JsonProperty
  @Override
  public List<String> getOauth() {
    return oauth;
  }

  /**
   * @return The value of the {@code bot} attribute
   */
  @JsonProperty
  @Override
  public List<String> getBot() {
    return bot;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokensRevokedIF#getOauth() oauth}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final TokensRevoked withOauth(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new TokensRevoked(newValue, this.bot);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokensRevokedIF#getOauth() oauth}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of oauth elements to set
   * @return A modified copy of {@code this} object
   */
  public final TokensRevoked withOauth(Iterable<String> elements) {
    if (this.oauth == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new TokensRevoked(newValue, this.bot);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokensRevokedIF#getBot() bot}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final TokensRevoked withBot(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new TokensRevoked(this.oauth, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TokensRevokedIF#getBot() bot}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of bot elements to set
   * @return A modified copy of {@code this} object
   */
  public final TokensRevoked withBot(Iterable<String> elements) {
    if (this.bot == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new TokensRevoked(this.oauth, newValue);
  }

  /**
   * This instance is equal to all instances of {@code TokensRevoked} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof TokensRevoked
        && equalTo((TokensRevoked) another);
  }

  private boolean equalTo(TokensRevoked another) {
    return oauth.equals(another.oauth)
        && bot.equals(another.bot);
  }

  /**
   * Computes a hash code from attributes: {@code oauth}, {@code bot}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + oauth.hashCode();
    h = h * 17 + bot.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TokensRevoked} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TokensRevoked{"
        + "oauth=" + oauth
        + ", bot=" + bot
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TokensRevokedIF {
    List<String> oauth = Collections.emptyList();
    List<String> bot = Collections.emptyList();
    @JsonProperty
    public void setOauth(List<String> oauth) {
      this.oauth = oauth;
    }
    @JsonProperty
    public void setBot(List<String> bot) {
      this.bot = bot;
    }
    @Override
    public List<String> getOauth() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getBot() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static TokensRevoked fromJson(Json json) {
    TokensRevoked.Builder builder = TokensRevoked.builder();
    if (json.oauth != null) {
      builder.addAllOauth(json.oauth);
    }
    if (json.bot != null) {
      builder.addAllBot(json.bot);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TokensRevokedIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TokensRevoked instance
   */
  public static TokensRevoked copyOf(TokensRevokedIF instance) {
    if (instance instanceof TokensRevoked) {
      return (TokensRevoked) instance;
    }
    return TokensRevoked.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link TokensRevoked TokensRevoked}.
   * @return A new TokensRevoked builder
   */
  public static TokensRevoked.Builder builder() {
    return new TokensRevoked.Builder();
  }

  /**
   * Builds instances of type {@link TokensRevoked TokensRevoked}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<String> oauth = new ArrayList<String>();
    private List<String> bot = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TokensRevokedIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TokensRevokedIF instance) {
      Objects.requireNonNull(instance, "instance");
      addAllOauth(instance.getOauth());
      addAllBot(instance.getBot());
      return this;
    }

    /**
     * Adds one element to {@link TokensRevokedIF#getOauth() oauth} list.
     * @param element A oauth element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOauth(String element) {
      this.oauth.add(Objects.requireNonNull(element, "oauth element"));
      return this;
    }

    /**
     * Adds elements to {@link TokensRevokedIF#getOauth() oauth} list.
     * @param elements An array of oauth elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOauth(String... elements) {
      for (String element : elements) {
        this.oauth.add(Objects.requireNonNull(element, "oauth element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link TokensRevokedIF#getOauth() oauth} list.
     * @param elements An iterable of oauth elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOauth(Iterable<String> elements) {
      this.oauth.clear();
      return addAllOauth(elements);
    }

    /**
     * Adds elements to {@link TokensRevokedIF#getOauth() oauth} list.
     * @param elements An iterable of oauth elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOauth(Iterable<String> elements) {
      for (String element : elements) {
        this.oauth.add(Objects.requireNonNull(element, "oauth element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link TokensRevokedIF#getBot() bot} list.
     * @param element A bot element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBot(String element) {
      this.bot.add(Objects.requireNonNull(element, "bot element"));
      return this;
    }

    /**
     * Adds elements to {@link TokensRevokedIF#getBot() bot} list.
     * @param elements An array of bot elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBot(String... elements) {
      for (String element : elements) {
        this.bot.add(Objects.requireNonNull(element, "bot element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link TokensRevokedIF#getBot() bot} list.
     * @param elements An iterable of bot elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBot(Iterable<String> elements) {
      this.bot.clear();
      return addAllBot(elements);
    }

    /**
     * Adds elements to {@link TokensRevokedIF#getBot() bot} list.
     * @param elements An iterable of bot elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBot(Iterable<String> elements) {
      for (String element : elements) {
        this.bot.add(Objects.requireNonNull(element, "bot element"));
      }
      return this;
    }

    /**
     * Builds a new {@link TokensRevoked TokensRevoked}.
     * @return An immutable instance of TokensRevoked
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public TokensRevoked build() throws InvalidImmutableStateException {
      return new TokensRevoked(createUnmodifiableList(true, oauth), createUnmodifiableList(true, bot));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
