package com.hubspot.slack.client.models.events.app;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackTokensRevokedEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackTokensRevokedEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackTokensRevokedEventIF"})
@Immutable
public final class SlackTokensRevokedEvent
    implements SlackTokensRevokedEventIF {
  private final TokensRevoked tokens;
  private final SlackEventType type;

  private SlackTokensRevokedEvent(TokensRevoked tokens, SlackEventType type) {
    this.tokens = tokens;
    this.type = type;
  }

  /**
   * @return The value of the {@code tokens} attribute
   */
  @JsonProperty
  @Override
  public TokensRevoked getTokens() {
    return tokens;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackTokensRevokedEventIF#getTokens() tokens} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param tokens A new value for tokens
   * @return A modified copy of the {@code this} object
   */
  public final SlackTokensRevokedEvent withTokens(TokensRevoked tokens) {
    if (this.tokens == tokens) return this;
    TokensRevoked newValue = Objects.requireNonNull(tokens, "tokens");
    return new SlackTokensRevokedEvent(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackTokensRevokedEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackTokensRevokedEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackTokensRevokedEvent(this.tokens, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackTokensRevokedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackTokensRevokedEvent
        && equalTo((SlackTokensRevokedEvent) another);
  }

  private boolean equalTo(SlackTokensRevokedEvent another) {
    return tokens.equals(another.tokens)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code tokens}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + tokens.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackTokensRevokedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackTokensRevokedEvent{"
        + "tokens=" + tokens
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackTokensRevokedEventIF {
    @Nullable TokensRevoked tokens;
    @Nullable SlackEventType type;
    @JsonProperty
    public void setTokens(TokensRevoked tokens) {
      this.tokens = tokens;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public TokensRevoked getTokens() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackTokensRevokedEvent fromJson(Json json) {
    SlackTokensRevokedEvent.Builder builder = SlackTokensRevokedEvent.builder();
    if (json.tokens != null) {
      builder.setTokens(json.tokens);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackTokensRevokedEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackTokensRevokedEvent instance
   */
  public static SlackTokensRevokedEvent copyOf(SlackTokensRevokedEventIF instance) {
    if (instance instanceof SlackTokensRevokedEvent) {
      return (SlackTokensRevokedEvent) instance;
    }
    return SlackTokensRevokedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackTokensRevokedEvent SlackTokensRevokedEvent}.
   * @return A new SlackTokensRevokedEvent builder
   */
  public static SlackTokensRevokedEvent.Builder builder() {
    return new SlackTokensRevokedEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackTokensRevokedEvent SlackTokensRevokedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKENS = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable TokensRevoked tokens;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.app.SlackTokensRevokedEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackTokensRevokedEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackTokensRevokedEventIF) {
        SlackTokensRevokedEventIF instance = (SlackTokensRevokedEventIF) object;
        setTokens(instance.getTokens());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackTokensRevokedEventIF#getTokens() tokens} attribute.
     * @param tokens The value for tokens 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTokens(TokensRevoked tokens) {
      this.tokens = Objects.requireNonNull(tokens, "tokens");
      initBits &= ~INIT_BIT_TOKENS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackTokensRevokedEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackTokensRevokedEvent SlackTokensRevokedEvent}.
     * @return An immutable instance of SlackTokensRevokedEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackTokensRevokedEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackTokensRevokedEvent(tokens, type);
    }

    private boolean tokensIsSet() {
      return (initBits & INIT_BIT_TOKENS) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tokensIsSet()) attributes.add("tokens");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackTokensRevokedEvent, some of required attributes are not set " + attributes;
    }
  }
}
