package com.hubspot.slack.client.models.events.app;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackAppUninstalledEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackAppUninstalledEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackAppUninstalledEventIF"})
@Immutable
public final class SlackAppUninstalledEvent
    implements SlackAppUninstalledEventIF {
  private final SlackEventType type;

  private SlackAppUninstalledEvent(SlackEventType type) {
    this.type = type;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackAppUninstalledEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackAppUninstalledEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackAppUninstalledEvent(newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackAppUninstalledEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackAppUninstalledEvent
        && equalTo((SlackAppUninstalledEvent) another);
  }

  private boolean equalTo(SlackAppUninstalledEvent another) {
    return type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackAppUninstalledEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackAppUninstalledEvent{"
        + "type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackAppUninstalledEventIF {
    @Nullable SlackEventType type;
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackAppUninstalledEvent fromJson(Json json) {
    SlackAppUninstalledEvent.Builder builder = SlackAppUninstalledEvent.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackAppUninstalledEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackAppUninstalledEvent instance
   */
  public static SlackAppUninstalledEvent copyOf(SlackAppUninstalledEventIF instance) {
    if (instance instanceof SlackAppUninstalledEvent) {
      return (SlackAppUninstalledEvent) instance;
    }
    return SlackAppUninstalledEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackAppUninstalledEvent SlackAppUninstalledEvent}.
   * @return A new SlackAppUninstalledEvent builder
   */
  public static SlackAppUninstalledEvent.Builder builder() {
    return new SlackAppUninstalledEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackAppUninstalledEvent SlackAppUninstalledEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.app.SlackAppUninstalledEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackAppUninstalledEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackAppUninstalledEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackAppUninstalledEvent SlackAppUninstalledEvent}.
     * @return An immutable instance of SlackAppUninstalledEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackAppUninstalledEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackAppUninstalledEvent(type);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackAppUninstalledEvent, some of required attributes are not set " + attributes;
    }
  }
}
