package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.LiteMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackEventMessageChanged}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackEventMessageChanged.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackEventMessageChanged"})
@Immutable
public final class SlackEventMessageChanged
    extends AbstractSlackEventMessageChanged {
  private final String channelId;
  private final boolean hidden;
  private final LiteMessage message;
  private final @Nullable LiteMessage previousMessage;
  private final String eventTs;
  private final @Nullable SlackMessageSubtype subtype;
  private final SlackEventType type;
  private final String ts;

  private SlackEventMessageChanged(
      String channelId,
      boolean hidden,
      LiteMessage message,
      @Nullable LiteMessage previousMessage,
      String eventTs,
      @Nullable SlackMessageSubtype subtype,
      SlackEventType type,
      String ts) {
    this.channelId = channelId;
    this.hidden = hidden;
    this.message = message;
    this.previousMessage = previousMessage;
    this.eventTs = eventTs;
    this.subtype = subtype;
    this.type = type;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code hidden} attribute
   */
  @JsonProperty
  @Override
  public boolean isHidden() {
    return hidden;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty
  @Override
  public LiteMessage getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code previousMessage} attribute
   */
  @JsonProperty
  @Override
  public Optional<LiteMessage> getPreviousMessage() {
    return Optional.ofNullable(previousMessage);
  }

  /**
   * @return The value of the {@code eventTs} attribute
   */
  @JsonProperty
  @Override
  public String getEventTs() {
    return eventTs;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackMessageSubtype> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageChanged#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageChanged withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackEventMessageChanged(
        newValue,
        this.hidden,
        this.message,
        this.previousMessage,
        this.eventTs,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageChanged#isHidden() hidden} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param hidden A new value for hidden
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageChanged withHidden(boolean hidden) {
    if (this.hidden == hidden) return this;
    return new SlackEventMessageChanged(
        this.channelId,
        hidden,
        this.message,
        this.previousMessage,
        this.eventTs,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageChanged#getMessage() message} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param message A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageChanged withMessage(LiteMessage message) {
    if (this.message == message) return this;
    LiteMessage newValue = Objects.requireNonNull(message, "message");
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        newValue,
        this.previousMessage,
        this.eventTs,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventMessageChanged#getPreviousMessage() previousMessage} attribute.
   * @param value The value for previousMessage, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageChanged withPreviousMessage(@Nullable LiteMessage value) {
    @Nullable LiteMessage newValue = value;
    if (this.previousMessage == newValue) return this;
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        newValue,
        this.eventTs,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventMessageChanged#getPreviousMessage() previousMessage} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for previousMessage
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageChanged withPreviousMessage(Optional<LiteMessage> optional) {
    @Nullable LiteMessage value = optional.orElse(null);
    if (this.previousMessage == value) return this;
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        value,
        this.eventTs,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageChanged#getEventTs() eventTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param eventTs A new value for eventTs
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageChanged withEventTs(String eventTs) {
    if (this.eventTs.equals(eventTs)) return this;
    String newValue = Objects.requireNonNull(eventTs, "eventTs");
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        this.previousMessage,
        newValue,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventMessageChanged#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageChanged withSubtype(@Nullable SlackMessageSubtype value) {
    @Nullable SlackMessageSubtype newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        this.previousMessage,
        this.eventTs,
        newValue,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventMessageChanged#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageChanged withSubtype(Optional<SlackMessageSubtype> optional) {
    @Nullable SlackMessageSubtype value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        this.previousMessage,
        this.eventTs,
        value,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageChanged#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageChanged withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        this.previousMessage,
        this.eventTs,
        this.subtype,
        newValue,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageChanged#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageChanged withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new SlackEventMessageChanged(
        this.channelId,
        this.hidden,
        this.message,
        this.previousMessage,
        this.eventTs,
        this.subtype,
        this.type,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackEventMessageChanged} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackEventMessageChanged
        && equalTo((SlackEventMessageChanged) another);
  }

  private boolean equalTo(SlackEventMessageChanged another) {
    return channelId.equals(another.channelId)
        && hidden == another.hidden
        && message.equals(another.message)
        && Objects.equals(previousMessage, another.previousMessage)
        && eventTs.equals(another.eventTs)
        && Objects.equals(subtype, another.subtype)
        && type.equals(another.type)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code hidden}, {@code message}, {@code previousMessage}, {@code eventTs}, {@code subtype}, {@code type}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Boolean.hashCode(hidden);
    h = h * 17 + message.hashCode();
    h = h * 17 + Objects.hashCode(previousMessage);
    h = h * 17 + eventTs.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + type.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackEventMessageChanged} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackEventMessageChanged{");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("hidden=").append(hidden);
    builder.append(", ");
    builder.append("message=").append(message);
    if (previousMessage != null) {
      builder.append(", ");
      builder.append("previousMessage=").append(previousMessage);
    }
    builder.append(", ");
    builder.append("eventTs=").append(eventTs);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("ts=").append(ts);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractSlackEventMessageChanged {
    @Nullable String channelId;
    boolean hidden;
    boolean hiddenIsSet;
    @Nullable LiteMessage message;
    Optional<LiteMessage> previousMessage = Optional.empty();
    @Nullable String eventTs;
    Optional<SlackMessageSubtype> subtype = Optional.empty();
    @Nullable SlackEventType type;
    @Nullable String ts;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setHidden(boolean hidden) {
      this.hidden = hidden;
      this.hiddenIsSet = true;
    }
    @JsonProperty
    public void setMessage(LiteMessage message) {
      this.message = message;
    }
    @JsonProperty
    public void setPreviousMessage(Optional<LiteMessage> previousMessage) {
      this.previousMessage = previousMessage;
    }
    @JsonProperty
    public void setEventTs(String eventTs) {
      this.eventTs = eventTs;
    }
    @JsonProperty
    public void setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isHidden() { throw new UnsupportedOperationException(); }
    @Override
    public LiteMessage getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<LiteMessage> getPreviousMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getEventTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackMessageSubtype> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackEventMessageChanged fromJson(Json json) {
    SlackEventMessageChanged.Builder builder = SlackEventMessageChanged.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.hiddenIsSet) {
      builder.setHidden(json.hidden);
    }
    if (json.message != null) {
      builder.setMessage(json.message);
    }
    if (json.previousMessage != null) {
      builder.setPreviousMessage(json.previousMessage);
    }
    if (json.eventTs != null) {
      builder.setEventTs(json.eventTs);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackEventMessageChanged} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackEventMessageChanged instance
   */
  public static SlackEventMessageChanged copyOf(AbstractSlackEventMessageChanged instance) {
    if (instance instanceof SlackEventMessageChanged) {
      return (SlackEventMessageChanged) instance;
    }
    return SlackEventMessageChanged.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackEventMessageChanged SlackEventMessageChanged}.
   * @return A new SlackEventMessageChanged builder
   */
  public static SlackEventMessageChanged.Builder builder() {
    return new SlackEventMessageChanged.Builder();
  }

  /**
   * Builds instances of type {@link SlackEventMessageChanged SlackEventMessageChanged}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_HIDDEN = 0x2L;
    private static final long INIT_BIT_MESSAGE = 0x4L;
    private static final long INIT_BIT_EVENT_TS = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private static final long INIT_BIT_TS = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String channelId;
    private boolean hidden;
    private @Nullable LiteMessage message;
    private @Nullable LiteMessage previousMessage;
    private @Nullable String eventTs;
    private @Nullable SlackMessageSubtype subtype;
    private @Nullable SlackEventType type;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.AbstractSlackEventMessageChanged} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackEventMessageChanged instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEventMessageBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEventMessageBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlackEventMessageChanged) {
        AbstractSlackEventMessageChanged instance = (AbstractSlackEventMessageChanged) object;
        setHidden(instance.isHidden());
        setMessage(instance.getMessage());
        Optional<LiteMessage> previousMessageOptional = instance.getPreviousMessage();
        if (previousMessageOptional.isPresent()) {
          setPreviousMessage(previousMessageOptional);
        }
        setEventTs(instance.getEventTs());
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof SlackEventMessageBase) {
        SlackEventMessageBase instance = (SlackEventMessageBase) object;
        Optional<SlackMessageSubtype> subtypeOptional = instance.getSubtype();
        if (subtypeOptional.isPresent()) {
          setSubtype(subtypeOptional);
        }
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
        setTs(instance.getTs());
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageChanged#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageChanged#isHidden() hidden} attribute.
     * @param hidden The value for hidden 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHidden(boolean hidden) {
      this.hidden = hidden;
      initBits &= ~INIT_BIT_HIDDEN;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageChanged#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessage(LiteMessage message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageChanged#getPreviousMessage() previousMessage} to previousMessage.
     * @param previousMessage The value for previousMessage, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPreviousMessage(@Nullable LiteMessage previousMessage) {
      this.previousMessage = previousMessage;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageChanged#getPreviousMessage() previousMessage} to previousMessage.
     * @param previousMessage The value for previousMessage
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPreviousMessage(Optional<LiteMessage> previousMessage) {
      this.previousMessage = previousMessage.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageChanged#getEventTs() eventTs} attribute.
     * @param eventTs The value for eventTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEventTs(String eventTs) {
      this.eventTs = Objects.requireNonNull(eventTs, "eventTs");
      initBits &= ~INIT_BIT_EVENT_TS;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageChanged#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageChanged#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageChanged#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageChanged#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link SlackEventMessageChanged SlackEventMessageChanged}.
     * @return An immutable instance of SlackEventMessageChanged
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackEventMessageChanged build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackEventMessageChanged(channelId, hidden, message, previousMessage, eventTs, subtype, type, ts);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean hiddenIsSet() {
      return (initBits & INIT_BIT_HIDDEN) == 0;
    }

    private boolean messageIsSet() {
      return (initBits & INIT_BIT_MESSAGE) == 0;
    }

    private boolean eventTsIsSet() {
      return (initBits & INIT_BIT_EVENT_TS) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!hiddenIsSet()) attributes.add("hidden");
      if (!messageIsSet()) attributes.add("message");
      if (!eventTsIsSet()) attributes.add("eventTs");
      if (!typeIsSet()) attributes.add("type");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build SlackEventMessageChanged, some of required attributes are not set " + attributes;
    }
  }
}
