package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementSubtypes;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackFormTextareaElement}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackFormTextareaElement.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackFormTextareaElement"})
@Immutable
public final class SlackFormTextareaElement
    extends AbstractSlackFormTextareaElement {
  private final SlackFormElementTypes type;
  private final @Nullable SlackFormElementSubtypes subtype;
  private final @Nullable String hint;
  private final int minLength;
  private final int maxLength;
  private final @Nullable String value;
  private final String name;
  private final String label;
  private final @Nullable String placeholder;
  private final @Nullable Boolean optional;

  private SlackFormTextareaElement(SlackFormTextareaElement.Builder builder) {
    this.subtype = builder.subtype;
    this.hint = builder.hint;
    this.value = builder.value;
    this.name = builder.name;
    this.label = builder.label;
    this.placeholder = builder.placeholder;
    this.optional = builder.optional;
    if (builder.type != null) {
      initShim.setType(builder.type);
    }
    if (builder.minLengthIsSet()) {
      initShim.setMinLength(builder.minLength);
    }
    if (builder.maxLengthIsSet()) {
      initShim.setMaxLength(builder.maxLength);
    }
    this.type = initShim.getType();
    this.minLength = initShim.getMinLength();
    this.maxLength = initShim.getMaxLength();
    this.initShim = null;
  }

  private SlackFormTextareaElement(
      SlackFormElementTypes type,
      @Nullable SlackFormElementSubtypes subtype,
      @Nullable String hint,
      int minLength,
      int maxLength,
      @Nullable String value,
      String name,
      String label,
      @Nullable String placeholder,
      @Nullable Boolean optional) {
    this.type = type;
    this.subtype = subtype;
    this.hint = hint;
    this.minLength = minLength;
    this.maxLength = maxLength;
    this.value = value;
    this.name = name;
    this.label = label;
    this.placeholder = placeholder;
    this.optional = optional;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private SlackFormElementTypes type;
    private int typeStage;

    SlackFormElementTypes getType() {
      if (typeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (typeStage == STAGE_UNINITIALIZED) {
        typeStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(SlackFormTextareaElement.super.getType(), "type");
        typeStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void setType(SlackFormElementTypes type) {
      this.type = type;
      typeStage = STAGE_INITIALIZED;
    }
    private int minLength;
    private int minLengthStage;

    int getMinLength() {
      if (minLengthStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (minLengthStage == STAGE_UNINITIALIZED) {
        minLengthStage = STAGE_INITIALIZING;
        this.minLength = SlackFormTextareaElement.super.getMinLength();
        minLengthStage = STAGE_INITIALIZED;
      }
      return this.minLength;
    }

    void setMinLength(int minLength) {
      this.minLength = minLength;
      minLengthStage = STAGE_INITIALIZED;
    }
    private int maxLength;
    private int maxLengthStage;

    int getMaxLength() {
      if (maxLengthStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (maxLengthStage == STAGE_UNINITIALIZED) {
        maxLengthStage = STAGE_INITIALIZING;
        this.maxLength = SlackFormTextareaElement.super.getMaxLength();
        maxLengthStage = STAGE_INITIALIZED;
      }
      return this.maxLength;
    }

    void setMaxLength(int maxLength) {
      this.maxLength = maxLength;
      maxLengthStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (typeStage == STAGE_INITIALIZING) attributes.add("type");
      if (minLengthStage == STAGE_INITIALIZING) attributes.add("minLength");
      if (maxLengthStage == STAGE_INITIALIZING) attributes.add("maxLength");
      return "Cannot build SlackFormTextareaElement, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackFormElementTypes getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackFormElementSubtypes> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code hint} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getHint() {
    return Optional.ofNullable(hint);
  }

  /**
   * @return The value of the {@code minLength} attribute
   */
  @JsonProperty
  @Override
  public int getMinLength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMinLength()
        : this.minLength;
  }

  /**
   * @return The value of the {@code maxLength} attribute
   */
  @JsonProperty
  @Override
  public int getMaxLength() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxLength()
        : this.maxLength;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getValue() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPlaceholder() {
    return Optional.ofNullable(placeholder);
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @JsonProperty("optional")
  @Override
  public Optional<Boolean> isOptional() {
    return Optional.ofNullable(optional);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormTextareaElement#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormTextareaElement withType(SlackFormElementTypes type) {
    if (this.type == type) return this;
    SlackFormElementTypes newValue = Objects.requireNonNull(type, "type");
    return validate(new SlackFormTextareaElement(
        newValue,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormTextareaElement#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withSubtype(@Nullable SlackFormElementSubtypes value) {
    @Nullable SlackFormElementSubtypes newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        newValue,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormTextareaElement#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withSubtype(Optional<SlackFormElementSubtypes> optional) {
    @Nullable SlackFormElementSubtypes value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        value,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormTextareaElement#getHint() hint} attribute.
   * @param value The value for hint, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withHint(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.hint, newValue)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        newValue,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormTextareaElement#getHint() hint} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hint
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withHint(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.hint, value)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        value,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormTextareaElement#getMinLength() minLength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param minLength A new value for minLength
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormTextareaElement withMinLength(int minLength) {
    if (this.minLength == minLength) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormTextareaElement#getMaxLength() maxLength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param maxLength A new value for maxLength
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormTextareaElement withMaxLength(int maxLength) {
    if (this.maxLength == maxLength) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormTextareaElement#getValue() value} attribute.
   * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.value, newValue)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        newValue,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormTextareaElement#getValue() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormTextareaElement#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormTextareaElement withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        newValue,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormTextareaElement#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param label A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormTextareaElement withLabel(String label) {
    if (this.label.equals(label)) return this;
    String newValue = Objects.requireNonNull(label, "label");
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        newValue,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormTextareaElement#getPlaceholder() placeholder} attribute.
   * @param value The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withPlaceholder(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.placeholder, newValue)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        newValue,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormTextareaElement#getPlaceholder() placeholder} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for placeholder
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withPlaceholder(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        value,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormTextareaElement#isOptional() optional} attribute.
   * @param value The value for optional, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withOptional(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.optional, newValue)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormTextareaElement#isOptional() optional} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optional
   * @return A modified copy of {@code this} object
   */
  public final SlackFormTextareaElement withOptional(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.optional, value)) return this;
    return validate(new SlackFormTextareaElement(
        this.type,
        this.subtype,
        this.hint,
        this.minLength,
        this.maxLength,
        this.value,
        this.name,
        this.label,
        this.placeholder,
        value));
  }

  /**
   * This instance is equal to all instances of {@code SlackFormTextareaElement} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackFormTextareaElement
        && equalTo((SlackFormTextareaElement) another);
  }

  private boolean equalTo(SlackFormTextareaElement another) {
    return type.equals(another.type)
        && Objects.equals(subtype, another.subtype)
        && Objects.equals(hint, another.hint)
        && minLength == another.minLength
        && maxLength == another.maxLength
        && Objects.equals(value, another.value)
        && name.equals(another.name)
        && label.equals(another.label)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(optional, another.optional);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code subtype}, {@code hint}, {@code minLength}, {@code maxLength}, {@code value}, {@code name}, {@code label}, {@code placeholder}, {@code optional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + Objects.hashCode(hint);
    h = h * 17 + minLength;
    h = h * 17 + maxLength;
    h = h * 17 + Objects.hashCode(value);
    h = h * 17 + name.hashCode();
    h = h * 17 + label.hashCode();
    h = h * 17 + Objects.hashCode(placeholder);
    h = h * 17 + Objects.hashCode(optional);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackFormTextareaElement} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackFormTextareaElement{");
    builder.append("type=").append(type);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    if (hint != null) {
      builder.append(", ");
      builder.append("hint=").append(hint);
    }
    builder.append(", ");
    builder.append("minLength=").append(minLength);
    builder.append(", ");
    builder.append("maxLength=").append(maxLength);
    if (value != null) {
      builder.append(", ");
      builder.append("value=").append(value);
    }
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("label=").append(label);
    if (placeholder != null) {
      builder.append(", ");
      builder.append("placeholder=").append(placeholder);
    }
    if (optional != null) {
      builder.append(", ");
      builder.append("optional=").append(optional);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractSlackFormTextareaElement {
    @Nullable SlackFormElementTypes type;
    Optional<SlackFormElementSubtypes> subtype = Optional.empty();
    Optional<String> hint = Optional.empty();
    int minLength;
    boolean minLengthIsSet;
    int maxLength;
    boolean maxLengthIsSet;
    Optional<String> value = Optional.empty();
    @Nullable String name;
    @Nullable String label;
    Optional<String> placeholder = Optional.empty();
    Optional<Boolean> optional = Optional.empty();
    @JsonProperty
    public void setType(SlackFormElementTypes type) {
      this.type = type;
    }
    @JsonProperty
    public void setSubtype(Optional<SlackFormElementSubtypes> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setHint(Optional<String> hint) {
      this.hint = hint;
    }
    @JsonProperty
    public void setMinLength(int minLength) {
      this.minLength = minLength;
      this.minLengthIsSet = true;
    }
    @JsonProperty
    public void setMaxLength(int maxLength) {
      this.maxLength = maxLength;
      this.maxLengthIsSet = true;
    }
    @JsonProperty
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty
    public void setPlaceholder(Optional<String> placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty("optional")
    public void setOptional(Optional<Boolean> optional) {
      this.optional = optional;
    }
    @Override
    public SlackFormElementTypes getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackFormElementSubtypes> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHint() { throw new UnsupportedOperationException(); }
    @Override
    public int getMinLength() { throw new UnsupportedOperationException(); }
    @Override
    public int getMaxLength() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isOptional() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackFormTextareaElement fromJson(Json json) {
    SlackFormTextareaElement.Builder builder = SlackFormTextareaElement.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.hint != null) {
      builder.setHint(json.hint);
    }
    if (json.minLengthIsSet) {
      builder.setMinLength(json.minLength);
    }
    if (json.maxLengthIsSet) {
      builder.setMaxLength(json.maxLength);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.label != null) {
      builder.setLabel(json.label);
    }
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.optional != null) {
      builder.setOptional(json.optional);
    }
    return builder.build();
  }

  private static SlackFormTextareaElement validate(SlackFormTextareaElement instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackFormTextareaElement} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackFormTextareaElement instance
   */
  public static SlackFormTextareaElement copyOf(AbstractSlackFormTextareaElement instance) {
    if (instance instanceof SlackFormTextareaElement) {
      return (SlackFormTextareaElement) instance;
    }
    return SlackFormTextareaElement.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackFormTextareaElement SlackFormTextareaElement}.
   * @return A new SlackFormTextareaElement builder
   */
  public static SlackFormTextareaElement.Builder builder() {
    return new SlackFormTextareaElement.Builder();
  }

  /**
   * Builds instances of type {@link SlackFormTextareaElement SlackFormTextareaElement}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private static final long OPT_BIT_MIN_LENGTH = 0x1L;
    private static final long OPT_BIT_MAX_LENGTH = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable SlackFormElementTypes type;
    private @Nullable SlackFormElementSubtypes subtype;
    private @Nullable String hint;
    private int minLength;
    private int maxLength;
    private @Nullable String value;
    private @Nullable String name;
    private @Nullable String label;
    private @Nullable String placeholder;
    private @Nullable Boolean optional;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackDialogFormElement instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormTextareaElement} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackFormTextareaElement instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackDialogFormTextElement} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackDialogFormTextElement instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SlackDialogFormElement) {
        SlackDialogFormElement instance = (SlackDialogFormElement) object;
        setName(instance.getName());
        Optional<Boolean> optionalOptional = instance.isOptional();
        if (optionalOptional.isPresent()) {
          setOptional(optionalOptional);
        }
        setLabel(instance.getLabel());
        Optional<String> placeholderOptional = instance.getPlaceholder();
        if (placeholderOptional.isPresent()) {
          setPlaceholder(placeholderOptional);
        }
        if ((bits & 0x1L) == 0) {
          setType(instance.getType());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlackFormTextareaElement) {
        AbstractSlackFormTextareaElement instance = (AbstractSlackFormTextareaElement) object;
        if ((bits & 0x1L) == 0) {
          setType(instance.getType());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlackDialogFormTextElement) {
        AbstractSlackDialogFormTextElement instance = (AbstractSlackDialogFormTextElement) object;
        Optional<SlackFormElementSubtypes> subtypeOptional = instance.getSubtype();
        if (subtypeOptional.isPresent()) {
          setSubtype(subtypeOptional);
        }
        Optional<String> valueOptional = instance.getValue();
        if (valueOptional.isPresent()) {
          setValue(valueOptional);
        }
        setMaxLength(instance.getMaxLength());
        Optional<String> hintOptional = instance.getHint();
        if (hintOptional.isPresent()) {
          setHint(hintOptional);
        }
        setMinLength(instance.getMinLength());
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormTextareaElement#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlackFormTextareaElement#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackFormElementTypes type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable SlackFormElementSubtypes subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<SlackFormElementSubtypes> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getHint() hint} to hint.
     * @param hint The value for hint, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setHint(@Nullable String hint) {
      this.hint = hint;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getHint() hint} to hint.
     * @param hint The value for hint
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHint(Optional<String> hint) {
      this.hint = hint.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormTextareaElement#getMinLength() minLength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlackFormTextareaElement#getMinLength() minLength}.</em>
     * @param minLength The value for minLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMinLength(int minLength) {
      this.minLength = minLength;
      optBits |= OPT_BIT_MIN_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormTextareaElement#getMaxLength() maxLength} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlackFormTextareaElement#getMaxLength() maxLength}.</em>
     * @param maxLength The value for maxLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMaxLength(int maxLength) {
      this.maxLength = maxLength;
      optBits |= OPT_BIT_MAX_LENGTH;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getValue() value} to value.
     * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormTextareaElement#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormTextareaElement#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLabel(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Optional<String> placeholder) {
      this.placeholder = placeholder.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#isOptional() optional} to optional.
     * @param optional The value for optional, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOptional(@Nullable Boolean optional) {
      this.optional = optional;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormTextareaElement#isOptional() optional} to optional.
     * @param optional The value for optional
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptional(Optional<Boolean> optional) {
      this.optional = optional.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackFormTextareaElement SlackFormTextareaElement}.
     * @return An immutable instance of SlackFormTextareaElement
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackFormTextareaElement build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return SlackFormTextareaElement.validate(new SlackFormTextareaElement(this));
    }

    private boolean minLengthIsSet() {
      return (optBits & OPT_BIT_MIN_LENGTH) != 0;
    }

    private boolean maxLengthIsSet() {
      return (optBits & OPT_BIT_MAX_LENGTH) != 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean labelIsSet() {
      return (initBits & INIT_BIT_LABEL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      if (!labelIsSet()) attributes.add("label");
      return "Cannot build SlackFormTextareaElement, some of required attributes are not set " + attributes;
    }
  }
}
