package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackFormOptionGroupIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackFormOptionGroup.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackFormOptionGroupIF"})
@Immutable
public final class SlackFormOptionGroup
    implements SlackFormOptionGroupIF {
  private final String label;
  private final List<SlackFormOption> options;

  private SlackFormOptionGroup(String label, List<SlackFormOption> options) {
    this.label = label;
    this.options = options;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @Override
  public List<SlackFormOption> getOptions() {
    return options;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackFormOptionGroupIF#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param label A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormOptionGroup withLabel(String label) {
    if (this.label.equals(label)) return this;
    String newValue = Objects.requireNonNull(label, "label");
    return validate(new SlackFormOptionGroup(newValue, this.options));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackFormOptionGroupIF#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormOptionGroup withOptions(SlackFormOption... elements) {
    List<SlackFormOption> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlackFormOptionGroup(this.label, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackFormOptionGroupIF#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormOptionGroup withOptions(Iterable<? extends SlackFormOption> elements) {
    if (this.options == elements) return this;
    List<SlackFormOption> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlackFormOptionGroup(this.label, newValue));
  }

  /**
   * This instance is equal to all instances of {@code SlackFormOptionGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackFormOptionGroup
        && equalTo((SlackFormOptionGroup) another);
  }

  private boolean equalTo(SlackFormOptionGroup another) {
    return label.equals(another.label)
        && options.equals(another.options);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code options}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + label.hashCode();
    h = h * 17 + options.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackFormOptionGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackFormOptionGroup{"
        + "label=" + label
        + ", options=" + options
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements SlackFormOptionGroupIF {
    @Nullable String label;
    List<SlackFormOption> options = Collections.emptyList();
    @JsonProperty
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty
    public void setOptions(List<SlackFormOption> options) {
      this.options = options;
    }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackFormOption> getOptions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackFormOptionGroup fromJson(Json json) {
    SlackFormOptionGroup.Builder builder = SlackFormOptionGroup.builder();
    if (json.label != null) {
      builder.setLabel(json.label);
    }
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    return builder.build();
  }

  private static SlackFormOptionGroup validate(SlackFormOptionGroup instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link SlackFormOptionGroupIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackFormOptionGroup instance
   */
  public static SlackFormOptionGroup copyOf(SlackFormOptionGroupIF instance) {
    if (instance instanceof SlackFormOptionGroup) {
      return (SlackFormOptionGroup) instance;
    }
    return SlackFormOptionGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackFormOptionGroup SlackFormOptionGroup}.
   * @return A new SlackFormOptionGroup builder
   */
  public static SlackFormOptionGroup.Builder builder() {
    return new SlackFormOptionGroup.Builder();
  }

  /**
   * Builds instances of type {@link SlackFormOptionGroup SlackFormOptionGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LABEL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String label;
    private List<SlackFormOption> options = new ArrayList<SlackFormOption>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackFormOptionGroupIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackFormOptionGroupIF instance) {
      Objects.requireNonNull(instance, "instance");
      setLabel(instance.getLabel());
      addAllOptions(instance.getOptions());
      return this;
    }

    /**
     * Initializes the value for the {@link SlackFormOptionGroupIF#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLabel(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Adds one element to {@link SlackFormOptionGroupIF#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(SlackFormOption element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackFormOptionGroupIF#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(SlackFormOption... elements) {
      for (SlackFormOption element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackFormOptionGroupIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends SlackFormOption> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link SlackFormOptionGroupIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends SlackFormOption> elements) {
      for (SlackFormOption element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Builds a new {@link SlackFormOptionGroup SlackFormOptionGroup}.
     * @return An immutable instance of SlackFormOptionGroup
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackFormOptionGroup build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return SlackFormOptionGroup.validate(new SlackFormOptionGroup(label, createUnmodifiableList(true, options)));
    }

    private boolean labelIsSet() {
      return (initBits & INIT_BIT_LABEL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!labelIsSet()) attributes.add("label");
      return "Cannot build SlackFormOptionGroup, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
