package com.hubspot.slack.client.models.dialog.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InputErrorsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InputErrors.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InputErrorsIF"})
@Immutable
public final class InputErrors implements InputErrorsIF {
  private final List<InputError> errors;

  private InputErrors(List<InputError> errors) {
    this.errors = errors;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty
  @Override
  public List<InputError> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InputErrorsIF#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final InputErrors withErrors(InputError... elements) {
    List<InputError> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new InputErrors(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InputErrorsIF#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final InputErrors withErrors(Iterable<? extends InputError> elements) {
    if (this.errors == elements) return this;
    List<InputError> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new InputErrors(newValue);
  }

  /**
   * This instance is equal to all instances of {@code InputErrors} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof InputErrors
        && equalTo((InputErrors) another);
  }

  private boolean equalTo(InputErrors another) {
    return errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InputErrors} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InputErrors{"
        + "errors=" + errors
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements InputErrorsIF {
    List<InputError> errors = Collections.emptyList();
    @JsonProperty
    public void setErrors(List<InputError> errors) {
      this.errors = errors;
    }
    @Override
    public List<InputError> getErrors() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static InputErrors fromJson(Json json) {
    InputErrors.Builder builder = InputErrors.builder();
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link InputErrorsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InputErrors instance
   */
  public static InputErrors copyOf(InputErrorsIF instance) {
    if (instance instanceof InputErrors) {
      return (InputErrors) instance;
    }
    return InputErrors.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link InputErrors InputErrors}.
   * @return A new InputErrors builder
   */
  public static InputErrors.Builder builder() {
    return new InputErrors.Builder();
  }

  /**
   * Builds instances of type {@link InputErrors InputErrors}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<InputError> errors = new ArrayList<InputError>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InputErrorsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InputErrorsIF instance) {
      Objects.requireNonNull(instance, "instance");
      addAllErrors(instance.getErrors());
      return this;
    }

    /**
     * Adds one element to {@link InputErrorsIF#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(InputError element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link InputErrorsIF#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(InputError... elements) {
      for (InputError element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link InputErrorsIF#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setErrors(Iterable<? extends InputError> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link InputErrorsIF#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends InputError> elements) {
      for (InputError element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Builds a new {@link InputErrors InputErrors}.
     * @return An immutable instance of InputErrors
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public InputErrors build() throws InvalidImmutableStateException {
      return new InputErrors(createUnmodifiableList(true, errors));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
