package com.hubspot.slack.client.models.dialog.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InputErrorIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InputError.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InputErrorIF"})
@Immutable
public final class InputError implements InputErrorIF {
  private final String name;
  private final String error;

  private InputError(String name, String error) {
    this.name = name;
    this.error = error;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty
  @Override
  public String getError() {
    return error;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InputErrorIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final InputError withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new InputError(newValue, this.error);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InputErrorIF#getError() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param error A new value for error
   * @return A modified copy of the {@code this} object
   */
  public final InputError withError(String error) {
    if (this.error.equals(error)) return this;
    String newValue = Objects.requireNonNull(error, "error");
    return new InputError(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code InputError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof InputError
        && equalTo((InputError) another);
  }

  private boolean equalTo(InputError another) {
    return name.equals(another.name)
        && error.equals(another.error);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code error}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + error.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InputError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InputError{"
        + "name=" + name
        + ", error=" + error
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements InputErrorIF {
    @Nullable String name;
    @Nullable String error;
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setError(String error) {
      this.error = error;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static InputError fromJson(Json json) {
    InputError.Builder builder = InputError.builder();
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.error != null) {
      builder.setError(json.error);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link InputErrorIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InputError instance
   */
  public static InputError copyOf(InputErrorIF instance) {
    if (instance instanceof InputError) {
      return (InputError) instance;
    }
    return InputError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link InputError InputError}.
   * @return A new InputError builder
   */
  public static InputError.Builder builder() {
    return new InputError.Builder();
  }

  /**
   * Builds instances of type {@link InputError InputError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ERROR = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String error;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InputErrorIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InputErrorIF instance) {
      Objects.requireNonNull(instance, "instance");
      setName(instance.getName());
      setError(instance.getError());
      return this;
    }

    /**
     * Initializes the value for the {@link InputErrorIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link InputErrorIF#getError() error} attribute.
     * @param error The value for error 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setError(String error) {
      this.error = Objects.requireNonNull(error, "error");
      initBits &= ~INIT_BIT_ERROR;
      return this;
    }

    /**
     * Builds a new {@link InputError InputError}.
     * @return An immutable instance of InputError
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public InputError build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new InputError(name, error);
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean errorIsSet() {
      return (initBits & INIT_BIT_ERROR) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      if (!errorIsSet()) attributes.add("error");
      return "Cannot build InputError, some of required attributes are not set " + attributes;
    }
  }
}
