package com.hubspot.slack.client.models.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Conversation.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationIF"})
@Immutable
public final class Conversation implements ConversationIF {
  private final String id;
  private final @Nullable String name;
  private final @Nullable Boolean channel;
  private final @Nullable Boolean group;
  private final @Nullable Boolean mpim;
  private final @Nullable Boolean im;
  private final @Nullable Boolean archived;
  private final @Nullable Boolean general;
  private final @Nullable Boolean isPrivate;
  private final @Nullable Boolean member;
  private final @Nullable Integer numMembers;

  private Conversation(
      String id,
      @Nullable String name,
      @Nullable Boolean channel,
      @Nullable Boolean group,
      @Nullable Boolean mpim,
      @Nullable Boolean im,
      @Nullable Boolean archived,
      @Nullable Boolean general,
      @Nullable Boolean isPrivate,
      @Nullable Boolean member,
      @Nullable Integer numMembers) {
    this.id = id;
    this.name = name;
    this.channel = channel;
    this.group = group;
    this.mpim = mpim;
    this.im = im;
    this.archived = archived;
    this.general = general;
    this.isPrivate = isPrivate;
    this.member = member;
    this.numMembers = numMembers;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty("is_channel")
  @Override
  public Optional<Boolean> isChannel() {
    return Optional.ofNullable(channel);
  }

  /**
   * @return The value of the {@code group} attribute
   */
  @JsonProperty("is_group")
  @Override
  public Optional<Boolean> isGroup() {
    return Optional.ofNullable(group);
  }

  /**
   * @return The value of the {@code mpim} attribute
   */
  @JsonProperty("is_mpim")
  @Override
  public Optional<Boolean> isMpim() {
    return Optional.ofNullable(mpim);
  }

  /**
   * @return The value of the {@code im} attribute
   */
  @JsonProperty("is_im")
  @Override
  public Optional<Boolean> isIm() {
    return Optional.ofNullable(im);
  }

  /**
   * @return The value of the {@code archived} attribute
   */
  @JsonProperty("is_archived")
  @Override
  public Optional<Boolean> isArchived() {
    return Optional.ofNullable(archived);
  }

  /**
   * @return The value of the {@code general} attribute
   */
  @JsonProperty("is_general")
  @Override
  public Optional<Boolean> isGeneral() {
    return Optional.ofNullable(general);
  }

  /**
   * @return The value of the {@code isPrivate} attribute
   */
  @JsonProperty("is_private")
  @Override
  public Optional<Boolean> isPrivate() {
    return Optional.ofNullable(isPrivate);
  }

  /**
   * @return The value of the {@code member} attribute
   */
  @JsonProperty("is_member")
  @Override
  public Optional<Boolean> isMember() {
    return Optional.ofNullable(member);
  }

  /**
   * @return The value of the {@code numMembers} attribute
   */
  @JsonProperty("num_members")
  @Override
  public Optional<Integer> getNumMembers() {
    return Optional.ofNullable(numMembers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final Conversation withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new Conversation(
        newValue,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#getName() name} attribute.
   * @param value The value for name, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withName(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.name, newValue)) return this;
    return new Conversation(
        this.id,
        newValue,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final Conversation withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new Conversation(
        this.id,
        value,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isChannel() channel} attribute.
   * @param value The value for channel, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withChannel(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.channel, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        newValue,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isChannel() channel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for channel
   * @return A modified copy of {@code this} object
   */
  public final Conversation withChannel(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.channel, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        value,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isGroup() group} attribute.
   * @param value The value for group, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withGroup(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.group, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        newValue,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isGroup() group} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for group
   * @return A modified copy of {@code this} object
   */
  public final Conversation withGroup(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.group, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        value,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isMpim() mpim} attribute.
   * @param value The value for mpim, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withMpim(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.mpim, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        newValue,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isMpim() mpim} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mpim
   * @return A modified copy of {@code this} object
   */
  public final Conversation withMpim(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.mpim, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        value,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isIm() im} attribute.
   * @param value The value for im, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withIm(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.im, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        newValue,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isIm() im} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for im
   * @return A modified copy of {@code this} object
   */
  public final Conversation withIm(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.im, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        value,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isArchived() archived} attribute.
   * @param value The value for archived, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withArchived(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.archived, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        newValue,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isArchived() archived} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for archived
   * @return A modified copy of {@code this} object
   */
  public final Conversation withArchived(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.archived, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        value,
        this.general,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isGeneral() general} attribute.
   * @param value The value for general, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withGeneral(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.general, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        newValue,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isGeneral() general} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for general
   * @return A modified copy of {@code this} object
   */
  public final Conversation withGeneral(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.general, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        value,
        this.isPrivate,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isPrivate() isPrivate} attribute.
   * @param value The value for isPrivate, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withIsPrivate(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isPrivate, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        newValue,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isPrivate() isPrivate} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isPrivate
   * @return A modified copy of {@code this} object
   */
  public final Conversation withIsPrivate(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isPrivate, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        value,
        this.member,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#isMember() member} attribute.
   * @param value The value for member, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withMember(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.member, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        newValue,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#isMember() member} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for member
   * @return A modified copy of {@code this} object
   */
  public final Conversation withMember(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.member, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        value,
        this.numMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationIF#getNumMembers() numMembers} attribute.
   * @param value The value for numMembers, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Conversation withNumMembers(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.numMembers, newValue)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationIF#getNumMembers() numMembers} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numMembers
   * @return A modified copy of {@code this} object
   */
  public final Conversation withNumMembers(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.numMembers, value)) return this;
    return new Conversation(
        this.id,
        this.name,
        this.channel,
        this.group,
        this.mpim,
        this.im,
        this.archived,
        this.general,
        this.isPrivate,
        this.member,
        value);
  }

  /**
   * This instance is equal to all instances of {@code Conversation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Conversation
        && equalTo((Conversation) another);
  }

  private boolean equalTo(Conversation another) {
    return id.equals(another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(channel, another.channel)
        && Objects.equals(group, another.group)
        && Objects.equals(mpim, another.mpim)
        && Objects.equals(im, another.im)
        && Objects.equals(archived, another.archived)
        && Objects.equals(general, another.general)
        && Objects.equals(isPrivate, another.isPrivate)
        && Objects.equals(member, another.member)
        && Objects.equals(numMembers, another.numMembers);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code channel}, {@code group}, {@code mpim}, {@code im}, {@code archived}, {@code general}, {@code isPrivate}, {@code member}, {@code numMembers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(channel);
    h = h * 17 + Objects.hashCode(group);
    h = h * 17 + Objects.hashCode(mpim);
    h = h * 17 + Objects.hashCode(im);
    h = h * 17 + Objects.hashCode(archived);
    h = h * 17 + Objects.hashCode(general);
    h = h * 17 + Objects.hashCode(isPrivate);
    h = h * 17 + Objects.hashCode(member);
    h = h * 17 + Objects.hashCode(numMembers);
    return h;
  }

  /**
   * Prints the immutable value {@code Conversation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Conversation{");
    builder.append("id=").append(id);
    if (name != null) {
      builder.append(", ");
      builder.append("name=").append(name);
    }
    if (channel != null) {
      builder.append(", ");
      builder.append("channel=").append(channel);
    }
    if (group != null) {
      builder.append(", ");
      builder.append("group=").append(group);
    }
    if (mpim != null) {
      builder.append(", ");
      builder.append("mpim=").append(mpim);
    }
    if (im != null) {
      builder.append(", ");
      builder.append("im=").append(im);
    }
    if (archived != null) {
      builder.append(", ");
      builder.append("archived=").append(archived);
    }
    if (general != null) {
      builder.append(", ");
      builder.append("general=").append(general);
    }
    if (isPrivate != null) {
      builder.append(", ");
      builder.append("isPrivate=").append(isPrivate);
    }
    if (member != null) {
      builder.append(", ");
      builder.append("member=").append(member);
    }
    if (numMembers != null) {
      builder.append(", ");
      builder.append("numMembers=").append(numMembers);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConversationIF {
    @Nullable String id;
    Optional<String> name = Optional.empty();
    Optional<Boolean> channel = Optional.empty();
    Optional<Boolean> group = Optional.empty();
    Optional<Boolean> mpim = Optional.empty();
    Optional<Boolean> im = Optional.empty();
    Optional<Boolean> archived = Optional.empty();
    Optional<Boolean> general = Optional.empty();
    Optional<Boolean> isPrivate = Optional.empty();
    Optional<Boolean> member = Optional.empty();
    Optional<Integer> numMembers = Optional.empty();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty("is_channel")
    public void setChannel(Optional<Boolean> channel) {
      this.channel = channel;
    }
    @JsonProperty("is_group")
    public void setGroup(Optional<Boolean> group) {
      this.group = group;
    }
    @JsonProperty("is_mpim")
    public void setMpim(Optional<Boolean> mpim) {
      this.mpim = mpim;
    }
    @JsonProperty("is_im")
    public void setIm(Optional<Boolean> im) {
      this.im = im;
    }
    @JsonProperty("is_archived")
    public void setArchived(Optional<Boolean> archived) {
      this.archived = archived;
    }
    @JsonProperty("is_general")
    public void setGeneral(Optional<Boolean> general) {
      this.general = general;
    }
    @JsonProperty("is_private")
    public void setIsPrivate(Optional<Boolean> isPrivate) {
      this.isPrivate = isPrivate;
    }
    @JsonProperty("is_member")
    public void setMember(Optional<Boolean> member) {
      this.member = member;
    }
    @JsonProperty("num_members")
    public void setNumMembers(Optional<Integer> numMembers) {
      this.numMembers = numMembers;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isChannel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isGroup() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isMpim() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isIm() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isArchived() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isGeneral() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isPrivate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isMember() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getNumMembers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Conversation fromJson(Json json) {
    Conversation.Builder builder = Conversation.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.group != null) {
      builder.setGroup(json.group);
    }
    if (json.mpim != null) {
      builder.setMpim(json.mpim);
    }
    if (json.im != null) {
      builder.setIm(json.im);
    }
    if (json.archived != null) {
      builder.setArchived(json.archived);
    }
    if (json.general != null) {
      builder.setGeneral(json.general);
    }
    if (json.isPrivate != null) {
      builder.setIsPrivate(json.isPrivate);
    }
    if (json.member != null) {
      builder.setMember(json.member);
    }
    if (json.numMembers != null) {
      builder.setNumMembers(json.numMembers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Conversation instance
   */
  public static Conversation copyOf(ConversationIF instance) {
    if (instance instanceof Conversation) {
      return (Conversation) instance;
    }
    return Conversation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Conversation Conversation}.
   * @return A new Conversation builder
   */
  public static Conversation.Builder builder() {
    return new Conversation.Builder();
  }

  /**
   * Builds instances of type {@link Conversation Conversation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable Boolean channel;
    private @Nullable Boolean group;
    private @Nullable Boolean mpim;
    private @Nullable Boolean im;
    private @Nullable Boolean archived;
    private @Nullable Boolean general;
    private @Nullable Boolean isPrivate;
    private @Nullable Boolean member;
    private @Nullable Integer numMembers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationIF instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        setName(nameOptional);
      }
      Optional<Boolean> channelOptional = instance.isChannel();
      if (channelOptional.isPresent()) {
        setChannel(channelOptional);
      }
      Optional<Boolean> groupOptional = instance.isGroup();
      if (groupOptional.isPresent()) {
        setGroup(groupOptional);
      }
      Optional<Boolean> mpimOptional = instance.isMpim();
      if (mpimOptional.isPresent()) {
        setMpim(mpimOptional);
      }
      Optional<Boolean> imOptional = instance.isIm();
      if (imOptional.isPresent()) {
        setIm(imOptional);
      }
      Optional<Boolean> archivedOptional = instance.isArchived();
      if (archivedOptional.isPresent()) {
        setArchived(archivedOptional);
      }
      Optional<Boolean> generalOptional = instance.isGeneral();
      if (generalOptional.isPresent()) {
        setGeneral(generalOptional);
      }
      Optional<Boolean> isPrivateOptional = instance.isPrivate();
      if (isPrivateOptional.isPresent()) {
        setIsPrivate(isPrivateOptional);
      }
      Optional<Boolean> memberOptional = instance.isMember();
      if (memberOptional.isPresent()) {
        setMember(memberOptional);
      }
      Optional<Integer> numMembersOptional = instance.getNumMembers();
      if (numMembersOptional.isPresent()) {
        setNumMembers(numMembersOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#getName() name} to name.
     * @param name The value for name, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setName(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isChannel() channel} to channel.
     * @param channel The value for channel, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setChannel(@Nullable Boolean channel) {
      this.channel = channel;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isChannel() channel} to channel.
     * @param channel The value for channel
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(Optional<Boolean> channel) {
      this.channel = channel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isGroup() group} to group.
     * @param group The value for group, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setGroup(@Nullable Boolean group) {
      this.group = group;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isGroup() group} to group.
     * @param group The value for group
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setGroup(Optional<Boolean> group) {
      this.group = group.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isMpim() mpim} to mpim.
     * @param mpim The value for mpim, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMpim(@Nullable Boolean mpim) {
      this.mpim = mpim;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isMpim() mpim} to mpim.
     * @param mpim The value for mpim
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMpim(Optional<Boolean> mpim) {
      this.mpim = mpim.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isIm() im} to im.
     * @param im The value for im, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIm(@Nullable Boolean im) {
      this.im = im;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isIm() im} to im.
     * @param im The value for im
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIm(Optional<Boolean> im) {
      this.im = im.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isArchived() archived} to archived.
     * @param archived The value for archived, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setArchived(@Nullable Boolean archived) {
      this.archived = archived;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isArchived() archived} to archived.
     * @param archived The value for archived
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setArchived(Optional<Boolean> archived) {
      this.archived = archived.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isGeneral() general} to general.
     * @param general The value for general, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setGeneral(@Nullable Boolean general) {
      this.general = general;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isGeneral() general} to general.
     * @param general The value for general
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setGeneral(Optional<Boolean> general) {
      this.general = general.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isPrivate() isPrivate} to isPrivate.
     * @param isPrivate The value for isPrivate, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIsPrivate(@Nullable Boolean isPrivate) {
      this.isPrivate = isPrivate;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isPrivate() isPrivate} to isPrivate.
     * @param isPrivate The value for isPrivate
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsPrivate(Optional<Boolean> isPrivate) {
      this.isPrivate = isPrivate.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isMember() member} to member.
     * @param member The value for member, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMember(@Nullable Boolean member) {
      this.member = member;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#isMember() member} to member.
     * @param member The value for member
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMember(Optional<Boolean> member) {
      this.member = member.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#getNumMembers() numMembers} to numMembers.
     * @param numMembers The value for numMembers, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNumMembers(@Nullable Integer numMembers) {
      this.numMembers = numMembers;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationIF#getNumMembers() numMembers} to numMembers.
     * @param numMembers The value for numMembers
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNumMembers(Optional<Integer> numMembers) {
      this.numMembers = numMembers.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Conversation Conversation}.
     * @return An immutable instance of Conversation
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Conversation build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Conversation(id, name, channel, group, mpim, im, archived, general, isPrivate, member, numMembers);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      return "Cannot build Conversation, some of required attributes are not set " + attributes;
    }
  }
}
