package com.hubspot.slack.client.models.commands;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlashCommandSubmissionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlashCommandSubmission.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlashCommandSubmissionIF"})
@Immutable
public final class SlashCommandSubmission
    implements SlashCommandSubmissionIF {
  private final String token;
  private final String teamId;
  private final String teamDomain;
  private final @Nullable String enterpriseId;
  private final @Nullable String enterpriseName;
  private final String channelId;
  private final String channelName;
  private final String userId;
  private final String command;
  private final String text;
  private final String responseUrl;
  private final String triggerId;
  private final String userName;

  private SlashCommandSubmission(
      String token,
      String teamId,
      String teamDomain,
      @Nullable String enterpriseId,
      @Nullable String enterpriseName,
      String channelId,
      String channelName,
      String userId,
      String command,
      String text,
      String responseUrl,
      String triggerId,
      String userName) {
    this.token = token;
    this.teamId = teamId;
    this.teamDomain = teamDomain;
    this.enterpriseId = enterpriseId;
    this.enterpriseName = enterpriseName;
    this.channelId = channelId;
    this.channelName = channelName;
    this.userId = userId;
    this.command = command;
    this.text = text;
    this.responseUrl = responseUrl;
    this.triggerId = triggerId;
    this.userName = userName;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code teamId} attribute
   */
  @JsonProperty
  @Override
  public String getTeamId() {
    return teamId;
  }

  /**
   * @return The value of the {@code teamDomain} attribute
   */
  @JsonProperty
  @Override
  public String getTeamDomain() {
    return teamDomain;
  }

  /**
   * @return The value of the {@code enterpriseId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getEnterpriseId() {
    return Optional.ofNullable(enterpriseId);
  }

  /**
   * @return The value of the {@code enterpriseName} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getEnterpriseName() {
    return Optional.ofNullable(enterpriseName);
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code channelName} attribute
   */
  @JsonProperty
  @Override
  public String getChannelName() {
    return channelName;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code command} attribute
   */
  @JsonProperty
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code responseUrl} attribute
   */
  @JsonProperty
  @Override
  public String getResponseUrl() {
    return responseUrl;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @deprecated
   * The user_name field is being phased out
   * https://api.slack.com/changelog/2017-09-the-one-about-usernames
   */
  @JsonProperty
  @Deprecated
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new SlashCommandSubmission(
        newValue,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getTeamId() teamId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param teamId A new value for teamId
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withTeamId(String teamId) {
    if (this.teamId.equals(teamId)) return this;
    String newValue = Objects.requireNonNull(teamId, "teamId");
    return new SlashCommandSubmission(
        this.token,
        newValue,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getTeamDomain() teamDomain} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param teamDomain A new value for teamDomain
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withTeamDomain(String teamDomain) {
    if (this.teamDomain.equals(teamDomain)) return this;
    String newValue = Objects.requireNonNull(teamDomain, "teamDomain");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        newValue,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlashCommandSubmissionIF#getEnterpriseId() enterpriseId} attribute.
   * @param value The value for enterpriseId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandSubmission withEnterpriseId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.enterpriseId, newValue)) return this;
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        newValue,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlashCommandSubmissionIF#getEnterpriseId() enterpriseId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enterpriseId
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandSubmission withEnterpriseId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.enterpriseId, value)) return this;
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        value,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlashCommandSubmissionIF#getEnterpriseName() enterpriseName} attribute.
   * @param value The value for enterpriseName, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandSubmission withEnterpriseName(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.enterpriseName, newValue)) return this;
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        newValue,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlashCommandSubmissionIF#getEnterpriseName() enterpriseName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enterpriseName
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandSubmission withEnterpriseName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.enterpriseName, value)) return this;
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        value,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        newValue,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getChannelName() channelName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelName A new value for channelName
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withChannelName(String channelName) {
    if (this.channelName.equals(channelName)) return this;
    String newValue = Objects.requireNonNull(channelName, "channelName");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        newValue,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        newValue,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getCommand() command} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param command A new value for command
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withCommand(String command) {
    if (this.command.equals(command)) return this;
    String newValue = Objects.requireNonNull(command, "command");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        newValue,
        this.text,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withText(String text) {
    if (this.text.equals(text)) return this;
    String newValue = Objects.requireNonNull(text, "text");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        newValue,
        this.responseUrl,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getResponseUrl() responseUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param responseUrl A new value for responseUrl
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withResponseUrl(String responseUrl) {
    if (this.responseUrl.equals(responseUrl)) return this;
    String newValue = Objects.requireNonNull(responseUrl, "responseUrl");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        newValue,
        this.triggerId,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandSubmission withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        newValue,
        this.userName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlashCommandSubmissionIF#getUserName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userName A new value for userName
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final SlashCommandSubmission withUserName(String userName) {
    if (this.userName.equals(userName)) return this;
    String newValue = Objects.requireNonNull(userName, "userName");
    return new SlashCommandSubmission(
        this.token,
        this.teamId,
        this.teamDomain,
        this.enterpriseId,
        this.enterpriseName,
        this.channelId,
        this.channelName,
        this.userId,
        this.command,
        this.text,
        this.responseUrl,
        this.triggerId,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlashCommandSubmission} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlashCommandSubmission
        && equalTo((SlashCommandSubmission) another);
  }

  private boolean equalTo(SlashCommandSubmission another) {
    return token.equals(another.token)
        && teamId.equals(another.teamId)
        && teamDomain.equals(another.teamDomain)
        && Objects.equals(enterpriseId, another.enterpriseId)
        && Objects.equals(enterpriseName, another.enterpriseName)
        && channelId.equals(another.channelId)
        && channelName.equals(another.channelName)
        && userId.equals(another.userId)
        && command.equals(another.command)
        && text.equals(another.text)
        && responseUrl.equals(another.responseUrl)
        && triggerId.equals(another.triggerId)
        && userName.equals(another.userName);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code teamId}, {@code teamDomain}, {@code enterpriseId}, {@code enterpriseName}, {@code channelId}, {@code channelName}, {@code userId}, {@code command}, {@code text}, {@code responseUrl}, {@code triggerId}, {@code userName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + token.hashCode();
    h = h * 17 + teamId.hashCode();
    h = h * 17 + teamDomain.hashCode();
    h = h * 17 + Objects.hashCode(enterpriseId);
    h = h * 17 + Objects.hashCode(enterpriseName);
    h = h * 17 + channelId.hashCode();
    h = h * 17 + channelName.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + command.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + responseUrl.hashCode();
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + userName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlashCommandSubmission} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlashCommandSubmission{");
    builder.append("token=").append(token);
    builder.append(", ");
    builder.append("teamId=").append(teamId);
    builder.append(", ");
    builder.append("teamDomain=").append(teamDomain);
    if (enterpriseId != null) {
      builder.append(", ");
      builder.append("enterpriseId=").append(enterpriseId);
    }
    if (enterpriseName != null) {
      builder.append(", ");
      builder.append("enterpriseName=").append(enterpriseName);
    }
    builder.append(", ");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("channelName=").append(channelName);
    builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("command=").append(command);
    builder.append(", ");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("responseUrl=").append(responseUrl);
    builder.append(", ");
    builder.append("triggerId=").append(triggerId);
    builder.append(", ");
    builder.append("userName=").append(userName);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlashCommandSubmissionIF {
    @Nullable String token;
    @Nullable String teamId;
    @Nullable String teamDomain;
    Optional<String> enterpriseId = Optional.empty();
    Optional<String> enterpriseName = Optional.empty();
    @Nullable String channelId;
    @Nullable String channelName;
    @Nullable String userId;
    @Nullable String command;
    @Nullable String text;
    @Nullable String responseUrl;
    @Nullable String triggerId;
    @Nullable String userName;
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeamId(String teamId) {
      this.teamId = teamId;
    }
    @JsonProperty
    public void setTeamDomain(String teamDomain) {
      this.teamDomain = teamDomain;
    }
    @JsonProperty
    public void setEnterpriseId(Optional<String> enterpriseId) {
      this.enterpriseId = enterpriseId;
    }
    @JsonProperty
    public void setEnterpriseName(Optional<String> enterpriseName) {
      this.enterpriseName = enterpriseName;
    }
    @JsonProperty
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setChannelName(String channelName) {
      this.channelName = channelName;
    }
    @JsonProperty
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setCommand(String command) {
      this.command = command;
    }
    @JsonProperty
    public void setText(String text) {
      this.text = text;
    }
    @JsonProperty
    public void setResponseUrl(String responseUrl) {
      this.responseUrl = responseUrl;
    }
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeamId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeamDomain() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEnterpriseId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEnterpriseName() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelName() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getResponseUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlashCommandSubmission fromJson(Json json) {
    SlashCommandSubmission.Builder builder = SlashCommandSubmission.builder();
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.teamId != null) {
      builder.setTeamId(json.teamId);
    }
    if (json.teamDomain != null) {
      builder.setTeamDomain(json.teamDomain);
    }
    if (json.enterpriseId != null) {
      builder.setEnterpriseId(json.enterpriseId);
    }
    if (json.enterpriseName != null) {
      builder.setEnterpriseName(json.enterpriseName);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.channelName != null) {
      builder.setChannelName(json.channelName);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.command != null) {
      builder.setCommand(json.command);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.responseUrl != null) {
      builder.setResponseUrl(json.responseUrl);
    }
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.userName != null) {
      builder.setUserName(json.userName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlashCommandSubmissionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlashCommandSubmission instance
   */
  public static SlashCommandSubmission copyOf(SlashCommandSubmissionIF instance) {
    if (instance instanceof SlashCommandSubmission) {
      return (SlashCommandSubmission) instance;
    }
    return SlashCommandSubmission.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlashCommandSubmission SlashCommandSubmission}.
   * @return A new SlashCommandSubmission builder
   */
  public static SlashCommandSubmission.Builder builder() {
    return new SlashCommandSubmission.Builder();
  }

  /**
   * Builds instances of type {@link SlashCommandSubmission SlashCommandSubmission}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_TEAM_ID = 0x2L;
    private static final long INIT_BIT_TEAM_DOMAIN = 0x4L;
    private static final long INIT_BIT_CHANNEL_ID = 0x8L;
    private static final long INIT_BIT_CHANNEL_NAME = 0x10L;
    private static final long INIT_BIT_USER_ID = 0x20L;
    private static final long INIT_BIT_COMMAND = 0x40L;
    private static final long INIT_BIT_TEXT = 0x80L;
    private static final long INIT_BIT_RESPONSE_URL = 0x100L;
    private static final long INIT_BIT_TRIGGER_ID = 0x200L;
    private static final long INIT_BIT_USER_NAME = 0x400L;
    private long initBits = 0x7ffL;

    private @Nullable String token;
    private @Nullable String teamId;
    private @Nullable String teamDomain;
    private @Nullable String enterpriseId;
    private @Nullable String enterpriseName;
    private @Nullable String channelId;
    private @Nullable String channelName;
    private @Nullable String userId;
    private @Nullable String command;
    private @Nullable String text;
    private @Nullable String responseUrl;
    private @Nullable String triggerId;
    private @Nullable String userName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlashCommandSubmissionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlashCommandSubmissionIF instance) {
      Objects.requireNonNull(instance, "instance");
      setToken(instance.getToken());
      setTeamId(instance.getTeamId());
      setTeamDomain(instance.getTeamDomain());
      Optional<String> enterpriseIdOptional = instance.getEnterpriseId();
      if (enterpriseIdOptional.isPresent()) {
        setEnterpriseId(enterpriseIdOptional);
      }
      Optional<String> enterpriseNameOptional = instance.getEnterpriseName();
      if (enterpriseNameOptional.isPresent()) {
        setEnterpriseName(enterpriseNameOptional);
      }
      setChannelId(instance.getChannelId());
      setChannelName(instance.getChannelName());
      setUserId(instance.getUserId());
      setCommand(instance.getCommand());
      setText(instance.getText());
      setResponseUrl(instance.getResponseUrl());
      setTriggerId(instance.getTriggerId());
      setUserName(instance.getUserName());
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getTeamId() teamId} attribute.
     * @param teamId The value for teamId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeamId(String teamId) {
      this.teamId = Objects.requireNonNull(teamId, "teamId");
      initBits &= ~INIT_BIT_TEAM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getTeamDomain() teamDomain} attribute.
     * @param teamDomain The value for teamDomain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeamDomain(String teamDomain) {
      this.teamDomain = Objects.requireNonNull(teamDomain, "teamDomain");
      initBits &= ~INIT_BIT_TEAM_DOMAIN;
      return this;
    }

    /**
     * Initializes the optional value {@link SlashCommandSubmissionIF#getEnterpriseId() enterpriseId} to enterpriseId.
     * @param enterpriseId The value for enterpriseId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setEnterpriseId(@Nullable String enterpriseId) {
      this.enterpriseId = enterpriseId;
      return this;
    }

    /**
     * Initializes the optional value {@link SlashCommandSubmissionIF#getEnterpriseId() enterpriseId} to enterpriseId.
     * @param enterpriseId The value for enterpriseId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEnterpriseId(Optional<String> enterpriseId) {
      this.enterpriseId = enterpriseId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlashCommandSubmissionIF#getEnterpriseName() enterpriseName} to enterpriseName.
     * @param enterpriseName The value for enterpriseName, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setEnterpriseName(@Nullable String enterpriseName) {
      this.enterpriseName = enterpriseName;
      return this;
    }

    /**
     * Initializes the optional value {@link SlashCommandSubmissionIF#getEnterpriseName() enterpriseName} to enterpriseName.
     * @param enterpriseName The value for enterpriseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEnterpriseName(Optional<String> enterpriseName) {
      this.enterpriseName = enterpriseName.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getChannelName() channelName} attribute.
     * @param channelName The value for channelName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelName(String channelName) {
      this.channelName = Objects.requireNonNull(channelName, "channelName");
      initBits &= ~INIT_BIT_CHANNEL_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCommand(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getResponseUrl() responseUrl} attribute.
     * @param responseUrl The value for responseUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseUrl(String responseUrl) {
      this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
      initBits &= ~INIT_BIT_RESPONSE_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlashCommandSubmissionIF#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder setUserName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Builds a new {@link SlashCommandSubmission SlashCommandSubmission}.
     * @return An immutable instance of SlashCommandSubmission
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlashCommandSubmission build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlashCommandSubmission(
          token,
          teamId,
          teamDomain,
          enterpriseId,
          enterpriseName,
          channelId,
          channelName,
          userId,
          command,
          text,
          responseUrl,
          triggerId,
          userName);
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIdIsSet() {
      return (initBits & INIT_BIT_TEAM_ID) == 0;
    }

    private boolean teamDomainIsSet() {
      return (initBits & INIT_BIT_TEAM_DOMAIN) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean channelNameIsSet() {
      return (initBits & INIT_BIT_CHANNEL_NAME) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean commandIsSet() {
      return (initBits & INIT_BIT_COMMAND) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean responseUrlIsSet() {
      return (initBits & INIT_BIT_RESPONSE_URL) == 0;
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean userNameIsSet() {
      return (initBits & INIT_BIT_USER_NAME) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIdIsSet()) attributes.add("teamId");
      if (!teamDomainIsSet()) attributes.add("teamDomain");
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!channelNameIsSet()) attributes.add("channelName");
      if (!userIdIsSet()) attributes.add("userId");
      if (!commandIsSet()) attributes.add("command");
      if (!textIsSet()) attributes.add("text");
      if (!responseUrlIsSet()) attributes.add("responseUrl");
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!userNameIsSet()) attributes.add("userName");
      return "Cannot build SlashCommandSubmission, some of required attributes are not set " + attributes;
    }
  }
}
