package com.hubspot.slack.client.models.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ImChannelIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImChannel.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ImChannelIF"})
@Immutable
public final class ImChannel implements ImChannelIF {
  private final String id;
  private final int created;
  private final boolean isIm;
  private final boolean isOrgShared;
  private final String user;
  private final boolean isOpen;

  private ImChannel(
      String id,
      int created,
      boolean isIm,
      boolean isOrgShared,
      String user,
      boolean isOpen) {
    this.id = id;
    this.created = created;
    this.isIm = isIm;
    this.isOrgShared = isOrgShared;
    this.user = user;
    this.isOpen = isOpen;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty
  @Override
  public int getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code isIm} attribute
   */
  @JsonProperty
  @Override
  public boolean getIsIm() {
    return isIm;
  }

  /**
   * @return The value of the {@code isOrgShared} attribute
   */
  @JsonProperty
  @Override
  public boolean getIsOrgShared() {
    return isOrgShared;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public String getUser() {
    return user;
  }

  /**
   * @return The value of the {@code isOpen} attribute
   */
  @JsonProperty
  @Override
  public boolean getIsOpen() {
    return isOpen;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImChannelIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImChannel withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new ImChannel(newValue, this.created, this.isIm, this.isOrgShared, this.user, this.isOpen);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImChannelIF#getCreated() created} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param created A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImChannel withCreated(int created) {
    if (this.created == created) return this;
    return new ImChannel(this.id, created, this.isIm, this.isOrgShared, this.user, this.isOpen);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImChannelIF#getIsIm() isIm} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isIm A new value for isIm
   * @return A modified copy of the {@code this} object
   */
  public final ImChannel withIsIm(boolean isIm) {
    if (this.isIm == isIm) return this;
    return new ImChannel(this.id, this.created, isIm, this.isOrgShared, this.user, this.isOpen);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImChannelIF#getIsOrgShared() isOrgShared} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isOrgShared A new value for isOrgShared
   * @return A modified copy of the {@code this} object
   */
  public final ImChannel withIsOrgShared(boolean isOrgShared) {
    if (this.isOrgShared == isOrgShared) return this;
    return new ImChannel(this.id, this.created, this.isIm, isOrgShared, this.user, this.isOpen);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImChannelIF#getUser() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ImChannel withUser(String user) {
    if (this.user.equals(user)) return this;
    String newValue = Objects.requireNonNull(user, "user");
    return new ImChannel(this.id, this.created, this.isIm, this.isOrgShared, newValue, this.isOpen);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImChannelIF#getIsOpen() isOpen} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isOpen A new value for isOpen
   * @return A modified copy of the {@code this} object
   */
  public final ImChannel withIsOpen(boolean isOpen) {
    if (this.isOpen == isOpen) return this;
    return new ImChannel(this.id, this.created, this.isIm, this.isOrgShared, this.user, isOpen);
  }

  /**
   * This instance is equal to all instances of {@code ImChannel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImChannel
        && equalTo((ImChannel) another);
  }

  private boolean equalTo(ImChannel another) {
    return id.equals(another.id)
        && created == another.created
        && isIm == another.isIm
        && isOrgShared == another.isOrgShared
        && user.equals(another.user)
        && isOpen == another.isOpen;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code created}, {@code isIm}, {@code isOrgShared}, {@code user}, {@code isOpen}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + created;
    h = h * 17 + Boolean.hashCode(isIm);
    h = h * 17 + Boolean.hashCode(isOrgShared);
    h = h * 17 + user.hashCode();
    h = h * 17 + Boolean.hashCode(isOpen);
    return h;
  }

  /**
   * Prints the immutable value {@code ImChannel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImChannel{"
        + "id=" + id
        + ", created=" + created
        + ", isIm=" + isIm
        + ", isOrgShared=" + isOrgShared
        + ", user=" + user
        + ", isOpen=" + isOpen
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ImChannelIF {
    @Nullable String id;
    int created;
    boolean createdIsSet;
    boolean isIm;
    boolean isImIsSet;
    boolean isOrgShared;
    boolean isOrgSharedIsSet;
    @Nullable String user;
    boolean isOpen;
    boolean isOpenIsSet;
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setCreated(int created) {
      this.created = created;
      this.createdIsSet = true;
    }
    @JsonProperty
    public void setIsIm(boolean isIm) {
      this.isIm = isIm;
      this.isImIsSet = true;
    }
    @JsonProperty
    public void setIsOrgShared(boolean isOrgShared) {
      this.isOrgShared = isOrgShared;
      this.isOrgSharedIsSet = true;
    }
    @JsonProperty
    public void setUser(String user) {
      this.user = user;
    }
    @JsonProperty
    public void setIsOpen(boolean isOpen) {
      this.isOpen = isOpen;
      this.isOpenIsSet = true;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public int getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getIsIm() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getIsOrgShared() { throw new UnsupportedOperationException(); }
    @Override
    public String getUser() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getIsOpen() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImChannel fromJson(Json json) {
    ImChannel.Builder builder = ImChannel.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.createdIsSet) {
      builder.setCreated(json.created);
    }
    if (json.isImIsSet) {
      builder.setIsIm(json.isIm);
    }
    if (json.isOrgSharedIsSet) {
      builder.setIsOrgShared(json.isOrgShared);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.isOpenIsSet) {
      builder.setIsOpen(json.isOpen);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ImChannelIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImChannel instance
   */
  public static ImChannel copyOf(ImChannelIF instance) {
    if (instance instanceof ImChannel) {
      return (ImChannel) instance;
    }
    return ImChannel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImChannel ImChannel}.
   * @return A new ImChannel builder
   */
  public static ImChannel.Builder builder() {
    return new ImChannel.Builder();
  }

  /**
   * Builds instances of type {@link ImChannel ImChannel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CREATED = 0x2L;
    private static final long INIT_BIT_IS_IM = 0x4L;
    private static final long INIT_BIT_IS_ORG_SHARED = 0x8L;
    private static final long INIT_BIT_USER = 0x10L;
    private static final long INIT_BIT_IS_OPEN = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String id;
    private int created;
    private boolean isIm;
    private boolean isOrgShared;
    private @Nullable String user;
    private boolean isOpen;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImChannelIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImChannelIF instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      setCreated(instance.getCreated());
      setIsIm(instance.getIsIm());
      setIsOrgShared(instance.getIsOrgShared());
      setUser(instance.getUser());
      setIsOpen(instance.getIsOpen());
      return this;
    }

    /**
     * Initializes the value for the {@link ImChannelIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ImChannelIF#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCreated(int created) {
      this.created = created;
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link ImChannelIF#getIsIm() isIm} attribute.
     * @param isIm The value for isIm 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsIm(boolean isIm) {
      this.isIm = isIm;
      initBits &= ~INIT_BIT_IS_IM;
      return this;
    }

    /**
     * Initializes the value for the {@link ImChannelIF#getIsOrgShared() isOrgShared} attribute.
     * @param isOrgShared The value for isOrgShared 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsOrgShared(boolean isOrgShared) {
      this.isOrgShared = isOrgShared;
      initBits &= ~INIT_BIT_IS_ORG_SHARED;
      return this;
    }

    /**
     * Initializes the value for the {@link ImChannelIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(String user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link ImChannelIF#getIsOpen() isOpen} attribute.
     * @param isOpen The value for isOpen 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsOpen(boolean isOpen) {
      this.isOpen = isOpen;
      initBits &= ~INIT_BIT_IS_OPEN;
      return this;
    }

    /**
     * Builds a new {@link ImChannel ImChannel}.
     * @return An immutable instance of ImChannel
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ImChannel build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ImChannel(id, created, isIm, isOrgShared, user, isOpen);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean createdIsSet() {
      return (initBits & INIT_BIT_CREATED) == 0;
    }

    private boolean isImIsSet() {
      return (initBits & INIT_BIT_IS_IM) == 0;
    }

    private boolean isOrgSharedIsSet() {
      return (initBits & INIT_BIT_IS_ORG_SHARED) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private boolean isOpenIsSet() {
      return (initBits & INIT_BIT_IS_OPEN) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      if (!createdIsSet()) attributes.add("created");
      if (!isImIsSet()) attributes.add("isIm");
      if (!isOrgSharedIsSet()) attributes.add("isOrgShared");
      if (!userIsSet()) attributes.add("user");
      if (!isOpenIsSet()) attributes.add("isOpen");
      return "Cannot build ImChannel, some of required attributes are not set " + attributes;
    }
  }
}
