package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfirmationDialogIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConfirmationDialog.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ConfirmationDialog.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfirmationDialogIF"})
@Immutable
public final class ConfirmationDialog
    implements ConfirmationDialogIF {
  private final Text title;
  private final Text text;
  private final Text confirmButtonText;
  private final Text denyButtonText;

  private ConfirmationDialog(Text title, Text text, Text confirmButtonText, Text denyButtonText) {
    this.title = Objects.requireNonNull(title, "title");
    this.text = Objects.requireNonNull(text, "text");
    this.confirmButtonText = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
    this.denyButtonText = Objects.requireNonNull(denyButtonText, "denyButtonText");
  }

  private ConfirmationDialog(ConfirmationDialog original, Text title, Text text, Text confirmButtonText, Text denyButtonText) {
    this.title = title;
    this.text = text;
    this.confirmButtonText = confirmButtonText;
    this.denyButtonText = denyButtonText;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Text getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Text getText() {
    return text;
  }

  /**
   * @return The value of the {@code confirmButtonText} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Text getConfirmButtonText() {
    return confirmButtonText;
  }

  /**
   * @return The value of the {@code denyButtonText} attribute
   */
  @JsonProperty("deny")
  @Override
  public Text getDenyButtonText() {
    return denyButtonText;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationDialogIF#getTitle() title} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationDialog withTitle(Text title) {
    if (this.title == title) return this;
    Text newValue = Objects.requireNonNull(title, "title");
    return new ConfirmationDialog(this, newValue, this.text, this.confirmButtonText, this.denyButtonText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationDialogIF#getText() text} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationDialog withText(Text text) {
    if (this.text == text) return this;
    Text newValue = Objects.requireNonNull(text, "text");
    return new ConfirmationDialog(this, this.title, newValue, this.confirmButtonText, this.denyButtonText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationDialogIF#getConfirmButtonText() confirmButtonText} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param confirmButtonText A new value for confirmButtonText
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationDialog withConfirmButtonText(Text confirmButtonText) {
    if (this.confirmButtonText == confirmButtonText) return this;
    Text newValue = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
    return new ConfirmationDialog(this, this.title, this.text, newValue, this.denyButtonText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmationDialogIF#getDenyButtonText() denyButtonText} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param denyButtonText A new value for denyButtonText
   * @return A modified copy of the {@code this} object
   */
  public final ConfirmationDialog withDenyButtonText(Text denyButtonText) {
    if (this.denyButtonText == denyButtonText) return this;
    Text newValue = Objects.requireNonNull(denyButtonText, "denyButtonText");
    return new ConfirmationDialog(this, this.title, this.text, this.confirmButtonText, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConfirmationDialog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConfirmationDialog
        && equalTo((ConfirmationDialog) another);
  }

  private boolean equalTo(ConfirmationDialog another) {
    return title.equals(another.title)
        && text.equals(another.text)
        && confirmButtonText.equals(another.confirmButtonText)
        && denyButtonText.equals(another.denyButtonText);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code text}, {@code confirmButtonText}, {@code denyButtonText}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + title.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + confirmButtonText.hashCode();
    h = h * 17 + denyButtonText.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConfirmationDialog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConfirmationDialog{"
        + "title=" + title
        + ", text=" + text
        + ", confirmButtonText=" + confirmButtonText
        + ", denyButtonText=" + denyButtonText
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConfirmationDialogIF {
    @Nullable Text title;
    @Nullable Text text;
    @Nullable Text confirmButtonText;
    @Nullable Text denyButtonText;
    @JsonProperty
    public void setTitle(Text title) {
      this.title = title;
    }
    @JsonProperty
    public void setText(Text text) {
      this.text = text;
    }
    @JsonProperty("confirm")
    public void setConfirmButtonText(Text confirmButtonText) {
      this.confirmButtonText = confirmButtonText;
    }
    @JsonProperty("deny")
    public void setDenyButtonText(Text denyButtonText) {
      this.denyButtonText = denyButtonText;
    }
    @Override
    public Text getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Text getText() { throw new UnsupportedOperationException(); }
    @Override
    public Text getConfirmButtonText() { throw new UnsupportedOperationException(); }
    @Override
    public Text getDenyButtonText() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConfirmationDialog fromJson(Json json) {
    ConfirmationDialog.Builder builder = ConfirmationDialog.builder();
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.confirmButtonText != null) {
      builder.setConfirmButtonText(json.confirmButtonText);
    }
    if (json.denyButtonText != null) {
      builder.setDenyButtonText(json.denyButtonText);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ConfirmationDialog} instance.
   * @param title The value for the {@code title} attribute
   * @param text The value for the {@code text} attribute
   * @param confirmButtonText The value for the {@code confirmButtonText} attribute
   * @param denyButtonText The value for the {@code denyButtonText} attribute
   * @return An immutable ConfirmationDialog instance
   */
  public static ConfirmationDialog of(Text title, Text text, Text confirmButtonText, Text denyButtonText) {
    return new ConfirmationDialog(title, text, confirmButtonText, denyButtonText);
  }

  /**
   * Creates an immutable copy of a {@link ConfirmationDialogIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConfirmationDialog instance
   */
  public static ConfirmationDialog copyOf(ConfirmationDialogIF instance) {
    if (instance instanceof ConfirmationDialog) {
      return (ConfirmationDialog) instance;
    }
    return ConfirmationDialog.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConfirmationDialog ConfirmationDialog}.
   * @return A new ConfirmationDialog builder
   */
  public static ConfirmationDialog.Builder builder() {
    return new ConfirmationDialog.Builder();
  }

  /**
   * Builds instances of type {@link ConfirmationDialog ConfirmationDialog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private static final long INIT_BIT_TEXT = 0x2L;
    private static final long INIT_BIT_CONFIRM_BUTTON_TEXT = 0x4L;
    private static final long INIT_BIT_DENY_BUTTON_TEXT = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Text title;
    private @Nullable Text text;
    private @Nullable Text confirmButtonText;
    private @Nullable Text denyButtonText;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConfirmationDialogIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConfirmationDialogIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTitle(instance.getTitle());
      setText(instance.getText());
      setConfirmButtonText(instance.getConfirmButtonText());
      setDenyButtonText(instance.getDenyButtonText());
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationDialogIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Text title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationDialogIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Text text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationDialogIF#getConfirmButtonText() confirmButtonText} attribute.
     * @param confirmButtonText The value for confirmButtonText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmButtonText(Text confirmButtonText) {
      this.confirmButtonText = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
      initBits &= ~INIT_BIT_CONFIRM_BUTTON_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmationDialogIF#getDenyButtonText() denyButtonText} attribute.
     * @param denyButtonText The value for denyButtonText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDenyButtonText(Text denyButtonText) {
      this.denyButtonText = Objects.requireNonNull(denyButtonText, "denyButtonText");
      initBits &= ~INIT_BIT_DENY_BUTTON_TEXT;
      return this;
    }

    /**
     * Builds a new {@link ConfirmationDialog ConfirmationDialog}.
     * @return An immutable instance of ConfirmationDialog
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConfirmationDialog build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConfirmationDialog(null, title, text, confirmButtonText, denyButtonText);
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean confirmButtonTextIsSet() {
      return (initBits & INIT_BIT_CONFIRM_BUTTON_TEXT) == 0;
    }

    private boolean denyButtonTextIsSet() {
      return (initBits & INIT_BIT_DENY_BUTTON_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!titleIsSet()) attributes.add("title");
      if (!textIsSet()) attributes.add("text");
      if (!confirmButtonTextIsSet()) attributes.add("confirmButtonText");
      if (!denyButtonTextIsSet()) attributes.add("denyButtonText");
      return "Cannot build ConfirmationDialog, some of required attributes are not set " + attributes;
    }
  }
}
