package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.OptionGroup;
import com.hubspot.slack.client.models.blocks.objects.OptionOrOptionGroup;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StaticMultiSelectMenuIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StaticMultiSelectMenu.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code StaticMultiSelectMenu.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StaticMultiSelectMenuIF"})
@Immutable
public final class StaticMultiSelectMenu
    implements StaticMultiSelectMenuIF {
  private final String type;
  private final Text placeholder;
  private final String actionId;
  private final List<Option> options;
  private final List<OptionGroup> optionGroups;
  private final List<OptionOrOptionGroup> initialOptions;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private StaticMultiSelectMenu(
      Text placeholder,
      String actionId,
      Iterable<? extends Option> options) {
    this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.options = createUnmodifiableList(false, createSafeList(options, true, false));
    this.optionGroups = Collections.emptyList();
    this.initialOptions = Collections.emptyList();
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(StaticMultiSelectMenuIF.super.getType(), "type");
  }

  private StaticMultiSelectMenu(
      Text placeholder,
      String actionId,
      List<Option> options,
      List<OptionGroup> optionGroups,
      List<OptionOrOptionGroup> initialOptions,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.placeholder = placeholder;
    this.actionId = actionId;
    this.options = options;
    this.optionGroups = optionGroups;
    this.initialOptions = initialOptions;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(StaticMultiSelectMenuIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Text getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @Override
  public List<Option> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code optionGroups} attribute
   */
  @JsonProperty
  @Override
  public List<OptionGroup> getOptionGroups() {
    return optionGroups;
  }

  /**
   * @return The value of the {@code initialOptions} attribute
   */
  @JsonProperty
  @JsonDeserialize(contentUsing = OptionOrOptionGroupDeserializer.class)
  @Override
  public List<OptionOrOptionGroup> getInitialOptions() {
    return initialOptions;
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticMultiSelectMenuIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param placeholder A new value for placeholder
   * @return A modified copy of the {@code this} object
   */
  public final StaticMultiSelectMenu withPlaceholder(Text placeholder) {
    if (this.placeholder == placeholder) return this;
    Text newValue = Objects.requireNonNull(placeholder, "placeholder");
    return new StaticMultiSelectMenu(
        newValue,
        this.actionId,
        this.options,
        this.optionGroups,
        this.initialOptions,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticMultiSelectMenuIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final StaticMultiSelectMenu withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new StaticMultiSelectMenu(
        this.placeholder,
        newValue,
        this.options,
        this.optionGroups,
        this.initialOptions,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticMultiSelectMenuIF#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withOptions(Option... elements) {
    List<Option> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new StaticMultiSelectMenu(
        this.placeholder,
        this.actionId,
        newValue,
        this.optionGroups,
        this.initialOptions,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticMultiSelectMenuIF#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withOptions(Iterable<? extends Option> elements) {
    if (this.options == elements) return this;
    List<Option> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new StaticMultiSelectMenu(
        this.placeholder,
        this.actionId,
        newValue,
        this.optionGroups,
        this.initialOptions,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticMultiSelectMenuIF#getOptionGroups() optionGroups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withOptionGroups(OptionGroup... elements) {
    List<OptionGroup> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new StaticMultiSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        newValue,
        this.initialOptions,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticMultiSelectMenuIF#getOptionGroups() optionGroups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of optionGroups elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withOptionGroups(Iterable<? extends OptionGroup> elements) {
    if (this.optionGroups == elements) return this;
    List<OptionGroup> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new StaticMultiSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        newValue,
        this.initialOptions,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticMultiSelectMenuIF#getInitialOptions() initialOptions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withInitialOptions(OptionOrOptionGroup... elements) {
    List<OptionOrOptionGroup> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new StaticMultiSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        this.optionGroups,
        newValue,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticMultiSelectMenuIF#getInitialOptions() initialOptions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of initialOptions elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withInitialOptions(Iterable<? extends OptionOrOptionGroup> elements) {
    if (this.initialOptions == elements) return this;
    List<OptionOrOptionGroup> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new StaticMultiSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        this.optionGroups,
        newValue,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link StaticMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new StaticMultiSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, this.initialOptions, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link StaticMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final StaticMultiSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new StaticMultiSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, this.initialOptions, value);
  }

  /**
   * This instance is equal to all instances of {@code StaticMultiSelectMenu} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof StaticMultiSelectMenu
        && equalTo((StaticMultiSelectMenu) another);
  }

  private boolean equalTo(StaticMultiSelectMenu another) {
    return type.equals(another.type)
        && placeholder.equals(another.placeholder)
        && actionId.equals(another.actionId)
        && options.equals(another.options)
        && optionGroups.equals(another.optionGroups)
        && initialOptions.equals(another.initialOptions)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code placeholder}, {@code actionId}, {@code options}, {@code optionGroups}, {@code initialOptions}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + placeholder.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + options.hashCode();
    h = h * 17 + optionGroups.hashCode();
    h = h * 17 + initialOptions.hashCode();
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code StaticMultiSelectMenu} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("StaticMultiSelectMenu{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("placeholder=").append(placeholder);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    builder.append(", ");
    builder.append("options=").append(options);
    builder.append(", ");
    builder.append("optionGroups=").append(optionGroups);
    builder.append(", ");
    builder.append("initialOptions=").append(initialOptions);
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StaticMultiSelectMenuIF {
    @Nullable Text placeholder;
    @Nullable String actionId;
    List<Option> options = Collections.emptyList();
    List<OptionGroup> optionGroups = Collections.emptyList();
    List<OptionOrOptionGroup> initialOptions = Collections.emptyList();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setPlaceholder(Text placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setOptions(List<Option> options) {
      this.options = options;
    }
    @JsonProperty
    public void setOptionGroups(List<OptionGroup> optionGroups) {
      this.optionGroups = optionGroups;
    }
    @JsonProperty
    @JsonDeserialize(contentUsing = OptionOrOptionGroupDeserializer.class)
    public void setInitialOptions(List<OptionOrOptionGroup> initialOptions) {
      this.initialOptions = initialOptions;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Option> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public List<OptionGroup> getOptionGroups() { throw new UnsupportedOperationException(); }
    @Override
    public List<OptionOrOptionGroup> getInitialOptions() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static StaticMultiSelectMenu fromJson(Json json) {
    StaticMultiSelectMenu.Builder builder = StaticMultiSelectMenu.builder();
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    if (json.optionGroups != null) {
      builder.addAllOptionGroups(json.optionGroups);
    }
    if (json.initialOptions != null) {
      builder.addAllInitialOptions(json.initialOptions);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code StaticMultiSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @param options The value for the {@code options} attribute
   * @return An immutable StaticMultiSelectMenu instance
   */
  public static StaticMultiSelectMenu of(Text placeholder, String actionId, List<Option> options) {
    return of(placeholder, actionId, (Iterable<? extends Option>) options);
  }

  /**
   * Construct a new immutable {@code StaticMultiSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @param options The value for the {@code options} attribute
   * @return An immutable StaticMultiSelectMenu instance
   */
  public static StaticMultiSelectMenu of(Text placeholder, String actionId, Iterable<? extends Option> options) {
    return new StaticMultiSelectMenu(placeholder, actionId, options);
  }

  /**
   * Creates an immutable copy of a {@link StaticMultiSelectMenuIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StaticMultiSelectMenu instance
   */
  public static StaticMultiSelectMenu copyOf(StaticMultiSelectMenuIF instance) {
    if (instance instanceof StaticMultiSelectMenu) {
      return (StaticMultiSelectMenu) instance;
    }
    return StaticMultiSelectMenu.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link StaticMultiSelectMenu StaticMultiSelectMenu}.
   * @return A new StaticMultiSelectMenu builder
   */
  public static StaticMultiSelectMenu.Builder builder() {
    return new StaticMultiSelectMenu.Builder();
  }

  /**
   * Builds instances of type {@link StaticMultiSelectMenu StaticMultiSelectMenu}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PLACEHOLDER = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text placeholder;
    private @Nullable String actionId;
    private List<Option> options = new ArrayList<Option>();
    private List<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
    private List<OptionOrOptionGroup> initialOptions = new ArrayList<OptionOrOptionGroup>();
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.HasActionId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasActionId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.StaticMultiSelectMenuIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StaticMultiSelectMenuIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasActionId) {
        HasActionId instance = (HasActionId) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
      }
      if (object instanceof StaticMultiSelectMenuIF) {
        StaticMultiSelectMenuIF instance = (StaticMultiSelectMenuIF) object;
        addAllOptions(instance.getOptions());
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
        addAllOptionGroups(instance.getOptionGroups());
        Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
        if (confirmationDialogOptional.isPresent()) {
          setConfirmationDialog(confirmationDialogOptional);
        }
        setPlaceholder(instance.getPlaceholder());
        addAllInitialOptions(instance.getInitialOptions());
      }
    }

    /**
     * Initializes the value for the {@link StaticMultiSelectMenuIF#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Text placeholder) {
      this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
      initBits &= ~INIT_BIT_PLACEHOLDER;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticMultiSelectMenuIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Adds one element to {@link StaticMultiSelectMenuIF#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link StaticMultiSelectMenuIF#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option... elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link StaticMultiSelectMenuIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends Option> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link StaticMultiSelectMenuIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends Option> elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link StaticMultiSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param element A optionGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(OptionGroup element) {
      this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link StaticMultiSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param elements An array of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(OptionGroup... elements) {
      for (OptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link StaticMultiSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptionGroups(Iterable<? extends OptionGroup> elements) {
      this.optionGroups.clear();
      return addAllOptionGroups(elements);
    }

    /**
     * Adds elements to {@link StaticMultiSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptionGroups(Iterable<? extends OptionGroup> elements) {
      for (OptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link StaticMultiSelectMenuIF#getInitialOptions() initialOptions} list.
     * @param element A initialOptions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInitialOptions(OptionOrOptionGroup element) {
      this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
      return this;
    }

    /**
     * Adds elements to {@link StaticMultiSelectMenuIF#getInitialOptions() initialOptions} list.
     * @param elements An array of initialOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInitialOptions(OptionOrOptionGroup... elements) {
      for (OptionOrOptionGroup element : elements) {
        this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link StaticMultiSelectMenuIF#getInitialOptions() initialOptions} list.
     * @param elements An iterable of initialOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialOptions(Iterable<? extends OptionOrOptionGroup> elements) {
      this.initialOptions.clear();
      return addAllInitialOptions(elements);
    }

    /**
     * Adds elements to {@link StaticMultiSelectMenuIF#getInitialOptions() initialOptions} list.
     * @param elements An iterable of initialOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInitialOptions(Iterable<? extends OptionOrOptionGroup> elements) {
      for (OptionOrOptionGroup element : elements) {
        this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link StaticMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link StaticMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link StaticMultiSelectMenu StaticMultiSelectMenu}.
     * @return An immutable instance of StaticMultiSelectMenu
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public StaticMultiSelectMenu build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new StaticMultiSelectMenu(
          placeholder,
          actionId,
          createUnmodifiableList(true, options),
          createUnmodifiableList(true, optionGroups),
          createUnmodifiableList(true, initialOptions),
          confirmationDialog);
    }

    private boolean placeholderIsSet() {
      return (initBits & INIT_BIT_PLACEHOLDER) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!placeholderIsSet()) attributes.add("placeholder");
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build StaticMultiSelectMenu, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
