package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link DatePickerIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DatePicker.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code DatePicker.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "DatePickerIF"})
@Immutable
public final class DatePicker implements DatePickerIF {
  private final String type;
  private final String actionId;
  private final @Nullable Text placeholder;
  private final @Nullable LocalDate initialDate;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private DatePicker(String actionId) {
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.placeholder = null;
    this.initialDate = null;
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(DatePickerIF.super.getType(), "type");
  }

  private DatePicker(
      String actionId,
      @Nullable Text placeholder,
      @Nullable LocalDate initialDate,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.actionId = actionId;
    this.placeholder = placeholder;
    this.initialDate = initialDate;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(DatePickerIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Optional<Text> getPlaceholder() {
    return Optional.ofNullable(placeholder);
  }

  /**
   * @return The value of the {@code initialDate} attribute
   */
  @JsonProperty
  @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
  @Override
  public Optional<LocalDate> getInitialDate() {
    return Optional.ofNullable(initialDate);
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatePickerIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final DatePicker withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new DatePicker(newValue, this.placeholder, this.initialDate, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DatePickerIF#getPlaceholder() placeholder} attribute.
   * @param value The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final DatePicker withPlaceholder(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.placeholder == newValue) return this;
    return new DatePicker(this.actionId, newValue, this.initialDate, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DatePickerIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for placeholder
   * @return A modified copy of {@code this} object
   */
  public final DatePicker withPlaceholder(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.placeholder == value) return this;
    return new DatePicker(this.actionId, value, this.initialDate, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DatePickerIF#getInitialDate() initialDate} attribute.
   * @param value The value for initialDate, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final DatePicker withInitialDate(@Nullable LocalDate value) {
    @Nullable LocalDate newValue = value;
    if (this.initialDate == newValue) return this;
    return new DatePicker(this.actionId, this.placeholder, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DatePickerIF#getInitialDate() initialDate} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialDate
   * @return A modified copy of {@code this} object
   */
  public final DatePicker withInitialDate(Optional<LocalDate> optional) {
    @Nullable LocalDate value = optional.orElse(null);
    if (this.initialDate == value) return this;
    return new DatePicker(this.actionId, this.placeholder, value, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DatePickerIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final DatePicker withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new DatePicker(this.actionId, this.placeholder, this.initialDate, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DatePickerIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final DatePicker withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new DatePicker(this.actionId, this.placeholder, this.initialDate, value);
  }

  /**
   * This instance is equal to all instances of {@code DatePicker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof DatePicker
        && equalTo((DatePicker) another);
  }

  private boolean equalTo(DatePicker another) {
    return type.equals(another.type)
        && actionId.equals(another.actionId)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(initialDate, another.initialDate)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code actionId}, {@code placeholder}, {@code initialDate}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + Objects.hashCode(placeholder);
    h = h * 17 + Objects.hashCode(initialDate);
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code DatePicker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DatePicker{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    if (placeholder != null) {
      builder.append(", ");
      builder.append("placeholder=").append(placeholder);
    }
    if (initialDate != null) {
      builder.append(", ");
      builder.append("initialDate=").append(initialDate);
    }
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DatePickerIF {
    @Nullable String actionId;
    Optional<Text> placeholder = Optional.empty();
    Optional<LocalDate> initialDate = Optional.empty();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setPlaceholder(Optional<Text> placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    public void setInitialDate(Optional<LocalDate> initialDate) {
      this.initialDate = initialDate;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<LocalDate> getInitialDate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static DatePicker fromJson(Json json) {
    DatePicker.Builder builder = DatePicker.builder();
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.initialDate != null) {
      builder.setInitialDate(json.initialDate);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code DatePicker} instance.
   * @param actionId The value for the {@code actionId} attribute
   * @return An immutable DatePicker instance
   */
  public static DatePicker of(String actionId) {
    return new DatePicker(actionId);
  }

  /**
   * Creates an immutable copy of a {@link DatePickerIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatePicker instance
   */
  public static DatePicker copyOf(DatePickerIF instance) {
    if (instance instanceof DatePicker) {
      return (DatePicker) instance;
    }
    return DatePicker.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link DatePicker DatePicker}.
   * @return A new DatePicker builder
   */
  public static DatePicker.Builder builder() {
    return new DatePicker.Builder();
  }

  /**
   * Builds instances of type {@link DatePicker DatePicker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACTION_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String actionId;
    private @Nullable Text placeholder;
    private @Nullable LocalDate initialDate;
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.DatePickerIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatePickerIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.HasActionId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasActionId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof DatePickerIF) {
        DatePickerIF instance = (DatePickerIF) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
        Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
        if (confirmationDialogOptional.isPresent()) {
          setConfirmationDialog(confirmationDialogOptional);
        }
        Optional<Text> placeholderOptional = instance.getPlaceholder();
        if (placeholderOptional.isPresent()) {
          setPlaceholder(placeholderOptional);
        }
        Optional<LocalDate> initialDateOptional = instance.getInitialDate();
        if (initialDateOptional.isPresent()) {
          setInitialDate(initialDateOptional);
        }
      }
      if (object instanceof HasActionId) {
        HasActionId instance = (HasActionId) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DatePickerIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link DatePickerIF#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPlaceholder(@Nullable Text placeholder) {
      this.placeholder = placeholder;
      return this;
    }

    /**
     * Initializes the optional value {@link DatePickerIF#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Optional<Text> placeholder) {
      this.placeholder = placeholder.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DatePickerIF#getInitialDate() initialDate} to initialDate.
     * @param initialDate The value for initialDate, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialDate(@Nullable LocalDate initialDate) {
      this.initialDate = initialDate;
      return this;
    }

    /**
     * Initializes the optional value {@link DatePickerIF#getInitialDate() initialDate} to initialDate.
     * @param initialDate The value for initialDate
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialDate(Optional<LocalDate> initialDate) {
      this.initialDate = initialDate.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DatePickerIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link DatePickerIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link DatePicker DatePicker}.
     * @return An immutable instance of DatePicker
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public DatePicker build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new DatePicker(actionId, placeholder, initialDate, confirmationDialog);
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build DatePicker, some of required attributes are not set " + attributes;
    }
  }
}
