package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationSelectMenuIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationSelectMenu.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ConversationSelectMenu.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationSelectMenuIF"})
@Immutable
public final class ConversationSelectMenu
    implements ConversationSelectMenuIF {
  private final String type;
  private final Text placeholder;
  private final String actionId;
  private final @Nullable String initialConversationId;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private ConversationSelectMenu(Text placeholder, String actionId) {
    this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.initialConversationId = null;
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(ConversationSelectMenuIF.super.getType(), "type");
  }

  private ConversationSelectMenu(
      Text placeholder,
      String actionId,
      @Nullable String initialConversationId,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.placeholder = placeholder;
    this.actionId = actionId;
    this.initialConversationId = initialConversationId;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(ConversationSelectMenuIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Text getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code initialConversationId} attribute
   */
  @JsonProperty("initial_conversation")
  @Override
  public Optional<String> getInitialConversationId() {
    return Optional.ofNullable(initialConversationId);
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationSelectMenuIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param placeholder A new value for placeholder
   * @return A modified copy of the {@code this} object
   */
  public final ConversationSelectMenu withPlaceholder(Text placeholder) {
    if (this.placeholder == placeholder) return this;
    Text newValue = Objects.requireNonNull(placeholder, "placeholder");
    return new ConversationSelectMenu(newValue, this.actionId, this.initialConversationId, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationSelectMenuIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationSelectMenu withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new ConversationSelectMenu(this.placeholder, newValue, this.initialConversationId, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationSelectMenuIF#getInitialConversationId() initialConversationId} attribute.
   * @param value The value for initialConversationId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationSelectMenu withInitialConversationId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.initialConversationId, newValue)) return this;
    return new ConversationSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationSelectMenuIF#getInitialConversationId() initialConversationId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialConversationId
   * @return A modified copy of {@code this} object
   */
  public final ConversationSelectMenu withInitialConversationId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.initialConversationId, value)) return this;
    return new ConversationSelectMenu(this.placeholder, this.actionId, value, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new ConversationSelectMenu(this.placeholder, this.actionId, this.initialConversationId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final ConversationSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new ConversationSelectMenu(this.placeholder, this.actionId, this.initialConversationId, value);
  }

  /**
   * This instance is equal to all instances of {@code ConversationSelectMenu} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationSelectMenu
        && equalTo((ConversationSelectMenu) another);
  }

  private boolean equalTo(ConversationSelectMenu another) {
    return type.equals(another.type)
        && placeholder.equals(another.placeholder)
        && actionId.equals(another.actionId)
        && Objects.equals(initialConversationId, another.initialConversationId)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code placeholder}, {@code actionId}, {@code initialConversationId}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + placeholder.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + Objects.hashCode(initialConversationId);
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationSelectMenu} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationSelectMenu{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("placeholder=").append(placeholder);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    if (initialConversationId != null) {
      builder.append(", ");
      builder.append("initialConversationId=").append(initialConversationId);
    }
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConversationSelectMenuIF {
    @Nullable Text placeholder;
    @Nullable String actionId;
    Optional<String> initialConversationId = Optional.empty();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setPlaceholder(Text placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty("initial_conversation")
    public void setInitialConversationId(Optional<String> initialConversationId) {
      this.initialConversationId = initialConversationId;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInitialConversationId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationSelectMenu fromJson(Json json) {
    ConversationSelectMenu.Builder builder = ConversationSelectMenu.builder();
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.initialConversationId != null) {
      builder.setInitialConversationId(json.initialConversationId);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ConversationSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @return An immutable ConversationSelectMenu instance
   */
  public static ConversationSelectMenu of(Text placeholder, String actionId) {
    return new ConversationSelectMenu(placeholder, actionId);
  }

  /**
   * Creates an immutable copy of a {@link ConversationSelectMenuIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationSelectMenu instance
   */
  public static ConversationSelectMenu copyOf(ConversationSelectMenuIF instance) {
    if (instance instanceof ConversationSelectMenu) {
      return (ConversationSelectMenu) instance;
    }
    return ConversationSelectMenu.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationSelectMenu ConversationSelectMenu}.
   * @return A new ConversationSelectMenu builder
   */
  public static ConversationSelectMenu.Builder builder() {
    return new ConversationSelectMenu.Builder();
  }

  /**
   * Builds instances of type {@link ConversationSelectMenu ConversationSelectMenu}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PLACEHOLDER = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text placeholder;
    private @Nullable String actionId;
    private @Nullable String initialConversationId;
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.ConversationSelectMenuIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationSelectMenuIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.HasActionId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasActionId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ConversationSelectMenuIF) {
        ConversationSelectMenuIF instance = (ConversationSelectMenuIF) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
        Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
        if (confirmationDialogOptional.isPresent()) {
          setConfirmationDialog(confirmationDialogOptional);
        }
        setPlaceholder(instance.getPlaceholder());
        Optional<String> initialConversationIdOptional = instance.getInitialConversationId();
        if (initialConversationIdOptional.isPresent()) {
          setInitialConversationId(initialConversationIdOptional);
        }
      }
      if (object instanceof HasActionId) {
        HasActionId instance = (HasActionId) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ConversationSelectMenuIF#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Text placeholder) {
      this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
      initBits &= ~INIT_BIT_PLACEHOLDER;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationSelectMenuIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationSelectMenuIF#getInitialConversationId() initialConversationId} to initialConversationId.
     * @param initialConversationId The value for initialConversationId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialConversationId(@Nullable String initialConversationId) {
      this.initialConversationId = initialConversationId;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationSelectMenuIF#getInitialConversationId() initialConversationId} to initialConversationId.
     * @param initialConversationId The value for initialConversationId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialConversationId(Optional<String> initialConversationId) {
      this.initialConversationId = initialConversationId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ConversationSelectMenu ConversationSelectMenu}.
     * @return An immutable instance of ConversationSelectMenu
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationSelectMenu build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationSelectMenu(placeholder, actionId, initialConversationId, confirmationDialog);
    }

    private boolean placeholderIsSet() {
      return (initBits & INIT_BIT_PLACEHOLDER) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!placeholderIsSet()) attributes.add("placeholder");
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build ConversationSelectMenu, some of required attributes are not set " + attributes;
    }
  }
}
