package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ButtonIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Button.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Button.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ButtonIF"})
@Immutable
public final class Button implements ButtonIF {
  private final String type;
  private final Text text;
  private final String actionId;
  private final @Nullable String url;
  private final @Nullable String value;
  private final @Nullable String style;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private Button(Text text, String actionId) {
    this.text = Objects.requireNonNull(text, "text");
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.url = null;
    this.value = null;
    this.style = null;
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(ButtonIF.super.getType(), "type");
  }

  private Button(
      Text text,
      String actionId,
      @Nullable String url,
      @Nullable String value,
      @Nullable String style,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.text = text;
    this.actionId = actionId;
    this.url = url;
    this.value = value;
    this.style = style;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(ButtonIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Text getText() {
    return text;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUrl() {
    return Optional.ofNullable(url);
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getValue() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code style} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getStyle() {
    return Optional.ofNullable(style);
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ButtonIF#getText() text} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final Button withText(Text text) {
    if (this.text == text) return this;
    Text newValue = Objects.requireNonNull(text, "text");
    return new Button(newValue, this.actionId, this.url, this.value, this.style, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ButtonIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final Button withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new Button(this.text, newValue, this.url, this.value, this.style, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ButtonIF#getUrl() url} attribute.
   * @param value The value for url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Button withUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.url, newValue)) return this;
    return new Button(this.text, this.actionId, newValue, this.value, this.style, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ButtonIF#getUrl() url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for url
   * @return A modified copy of {@code this} object
   */
  public final Button withUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.url, value)) return this;
    return new Button(this.text, this.actionId, value, this.value, this.style, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ButtonIF#getValue() value} attribute.
   * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Button withValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.value, newValue)) return this;
    return new Button(this.text, this.actionId, this.url, newValue, this.style, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ButtonIF#getValue() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final Button withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return new Button(this.text, this.actionId, this.url, value, this.style, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ButtonIF#getStyle() style} attribute.
   * @param value The value for style, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Button withStyle(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.style, newValue)) return this;
    return new Button(this.text, this.actionId, this.url, this.value, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ButtonIF#getStyle() style} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for style
   * @return A modified copy of {@code this} object
   */
  public final Button withStyle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.style, value)) return this;
    return new Button(this.text, this.actionId, this.url, this.value, value, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ButtonIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Button withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new Button(this.text, this.actionId, this.url, this.value, this.style, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ButtonIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final Button withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new Button(this.text, this.actionId, this.url, this.value, this.style, value);
  }

  /**
   * This instance is equal to all instances of {@code Button} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Button
        && equalTo((Button) another);
  }

  private boolean equalTo(Button another) {
    return type.equals(another.type)
        && text.equals(another.text)
        && actionId.equals(another.actionId)
        && Objects.equals(url, another.url)
        && Objects.equals(value, another.value)
        && Objects.equals(style, another.style)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code text}, {@code actionId}, {@code url}, {@code value}, {@code style}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + Objects.hashCode(url);
    h = h * 17 + Objects.hashCode(value);
    h = h * 17 + Objects.hashCode(style);
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code Button} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Button{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    if (url != null) {
      builder.append(", ");
      builder.append("url=").append(url);
    }
    if (value != null) {
      builder.append(", ");
      builder.append("value=").append(value);
    }
    if (style != null) {
      builder.append(", ");
      builder.append("style=").append(style);
    }
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ButtonIF {
    @Nullable Text text;
    @Nullable String actionId;
    Optional<String> url = Optional.empty();
    Optional<String> value = Optional.empty();
    Optional<String> style = Optional.empty();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setText(Text text) {
      this.text = text;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setUrl(Optional<String> url) {
      this.url = url;
    }
    @JsonProperty
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty
    public void setStyle(Optional<String> style) {
      this.style = style;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getStyle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Button fromJson(Json json) {
    Button.Builder builder = Button.builder();
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.url != null) {
      builder.setUrl(json.url);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.style != null) {
      builder.setStyle(json.style);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Button} instance.
   * @param text The value for the {@code text} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @return An immutable Button instance
   */
  public static Button of(Text text, String actionId) {
    return new Button(text, actionId);
  }

  /**
   * Creates an immutable copy of a {@link ButtonIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Button instance
   */
  public static Button copyOf(ButtonIF instance) {
    if (instance instanceof Button) {
      return (Button) instance;
    }
    return Button.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Button Button}.
   * @return A new Button builder
   */
  public static Button.Builder builder() {
    return new Button.Builder();
  }

  /**
   * Builds instances of type {@link Button Button}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEXT = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text text;
    private @Nullable String actionId;
    private @Nullable String url;
    private @Nullable String value;
    private @Nullable String style;
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.HasActionId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasActionId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.elements.ButtonIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ButtonIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasActionId) {
        HasActionId instance = (HasActionId) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ButtonIF) {
        ButtonIF instance = (ButtonIF) object;
        if ((bits & 0x1L) == 0) {
          setActionId(instance.getActionId());
          bits |= 0x1L;
        }
        Optional<String> styleOptional = instance.getStyle();
        if (styleOptional.isPresent()) {
          setStyle(styleOptional);
        }
        Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
        if (confirmationDialogOptional.isPresent()) {
          setConfirmationDialog(confirmationDialogOptional);
        }
        setText(instance.getText());
        Optional<String> valueOptional = instance.getValue();
        if (valueOptional.isPresent()) {
          setValue(valueOptional);
        }
        Optional<String> urlOptional = instance.getUrl();
        if (urlOptional.isPresent()) {
          setUrl(urlOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link ButtonIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Text text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ButtonIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getUrl() url} to url.
     * @param url The value for url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUrl(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getUrl() url} to url.
     * @param url The value for url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrl(Optional<String> url) {
      this.url = url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getValue() value} to value.
     * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getStyle() style} to style.
     * @param style The value for style, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setStyle(@Nullable String style) {
      this.style = style;
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getStyle() style} to style.
     * @param style The value for style
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStyle(Optional<String> style) {
      this.style = style.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link ButtonIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Button Button}.
     * @return An immutable instance of Button
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Button build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Button(text, actionId, url, value, style, confirmationDialog);
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!textIsSet()) attributes.add("text");
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build Button, some of required attributes are not set " + attributes;
    }
  }
}
