package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link HeaderIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Header.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Header.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "HeaderIF"})
@Immutable
public final class Header implements HeaderIF {
  private final String type;
  private final Text text;
  private final @Nullable String blockId;

  private Header(Text text) {
    this.text = Objects.requireNonNull(text, "text");
    this.blockId = null;
    this.type = Objects.requireNonNull(HeaderIF.super.getType(), "type");
  }

  private Header(
      Text text,
      @Nullable String blockId) {
    this.text = text;
    this.blockId = blockId;
    this.type = Objects.requireNonNull(HeaderIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Text getText() {
    return text;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HeaderIF#getText() text} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final Header withText(Text text) {
    if (this.text == text) return this;
    Text newValue = Objects.requireNonNull(text, "text");
    return validate(new Header(newValue, this.blockId));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HeaderIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Header withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return validate(new Header(this.text, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HeaderIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final Header withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return validate(new Header(this.text, value));
  }

  /**
   * This instance is equal to all instances of {@code Header} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Header
        && equalTo((Header) another);
  }

  private boolean equalTo(Header another) {
    return type.equals(another.type)
        && text.equals(another.text)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code text}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code Header} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Header{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("text=").append(text);
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements HeaderIF {
    @Nullable Text text;
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    public void setText(Text text) {
      this.text = text;
    }
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Header fromJson(Json json) {
    Header.Builder builder = Header.builder();
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Header} instance.
   * @param text The value for the {@code text} attribute
   * @return An immutable Header instance
   */
  public static Header of(Text text) {
    return validate(new Header(text));
  }

  private static Header validate(Header instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link HeaderIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Header instance
   */
  public static Header copyOf(HeaderIF instance) {
    if (instance instanceof Header) {
      return (Header) instance;
    }
    return Header.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Header Header}.
   * @return A new Header builder
   */
  public static Header.Builder builder() {
    return new Header.Builder();
  }

  /**
   * Builds instances of type {@link Header Header}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEXT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Text text;
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.HeaderIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HeaderIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
      if (object instanceof HeaderIF) {
        HeaderIF instance = (HeaderIF) object;
        setText(instance.getText());
      }
    }

    /**
     * Initializes the value for the {@link HeaderIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Text text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the optional value {@link HeaderIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link HeaderIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Header Header}.
     * @return An immutable instance of Header
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Header build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return Header.validate(new Header(text, blockId));
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!textIsSet()) attributes.add("text");
      return "Cannot build Header, some of required attributes are not set " + attributes;
    }
  }
}
