package com.hubspot.slack.client.models.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link BotCredentialsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BotCredentials.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BotCredentialsIF"})
@Immutable
public final class BotCredentials implements BotCredentialsIF {
  private final String botUserId;
  private final String botAccessToken;

  private BotCredentials(String botUserId, String botAccessToken) {
    this.botUserId = botUserId;
    this.botAccessToken = botAccessToken;
  }

  /**
   * @return The value of the {@code botUserId} attribute
   */
  @JsonProperty
  @Override
  public String getBotUserId() {
    return botUserId;
  }

  /**
   * @return The value of the {@code botAccessToken} attribute
   */
  @JsonProperty
  @Override
  public String getBotAccessToken() {
    return botAccessToken;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BotCredentialsIF#getBotUserId() botUserId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param botUserId A new value for botUserId
   * @return A modified copy of the {@code this} object
   */
  public final BotCredentials withBotUserId(String botUserId) {
    if (this.botUserId.equals(botUserId)) return this;
    String newValue = Objects.requireNonNull(botUserId, "botUserId");
    return new BotCredentials(newValue, this.botAccessToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BotCredentialsIF#getBotAccessToken() botAccessToken} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param botAccessToken A new value for botAccessToken
   * @return A modified copy of the {@code this} object
   */
  public final BotCredentials withBotAccessToken(String botAccessToken) {
    if (this.botAccessToken.equals(botAccessToken)) return this;
    String newValue = Objects.requireNonNull(botAccessToken, "botAccessToken");
    return new BotCredentials(this.botUserId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code BotCredentials} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof BotCredentials
        && equalTo((BotCredentials) another);
  }

  private boolean equalTo(BotCredentials another) {
    return botUserId.equals(another.botUserId)
        && botAccessToken.equals(another.botAccessToken);
  }

  /**
   * Computes a hash code from attributes: {@code botUserId}, {@code botAccessToken}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + botUserId.hashCode();
    h = h * 17 + botAccessToken.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BotCredentials} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BotCredentials{"
        + "botUserId=" + botUserId
        + ", botAccessToken=" + botAccessToken
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BotCredentialsIF {
    @Nullable String botUserId;
    @Nullable String botAccessToken;
    @JsonProperty
    public void setBotUserId(String botUserId) {
      this.botUserId = botUserId;
    }
    @JsonProperty
    public void setBotAccessToken(String botAccessToken) {
      this.botAccessToken = botAccessToken;
    }
    @Override
    public String getBotUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getBotAccessToken() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BotCredentials fromJson(Json json) {
    BotCredentials.Builder builder = BotCredentials.builder();
    if (json.botUserId != null) {
      builder.setBotUserId(json.botUserId);
    }
    if (json.botAccessToken != null) {
      builder.setBotAccessToken(json.botAccessToken);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BotCredentialsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BotCredentials instance
   */
  public static BotCredentials copyOf(BotCredentialsIF instance) {
    if (instance instanceof BotCredentials) {
      return (BotCredentials) instance;
    }
    return BotCredentials.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link BotCredentials BotCredentials}.
   * @return A new BotCredentials builder
   */
  public static BotCredentials.Builder builder() {
    return new BotCredentials.Builder();
  }

  /**
   * Builds instances of type {@link BotCredentials BotCredentials}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BOT_USER_ID = 0x1L;
    private static final long INIT_BIT_BOT_ACCESS_TOKEN = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String botUserId;
    private @Nullable String botAccessToken;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BotCredentialsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BotCredentialsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setBotUserId(instance.getBotUserId());
      setBotAccessToken(instance.getBotAccessToken());
      return this;
    }

    /**
     * Initializes the value for the {@link BotCredentialsIF#getBotUserId() botUserId} attribute.
     * @param botUserId The value for botUserId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBotUserId(String botUserId) {
      this.botUserId = Objects.requireNonNull(botUserId, "botUserId");
      initBits &= ~INIT_BIT_BOT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BotCredentialsIF#getBotAccessToken() botAccessToken} attribute.
     * @param botAccessToken The value for botAccessToken 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBotAccessToken(String botAccessToken) {
      this.botAccessToken = Objects.requireNonNull(botAccessToken, "botAccessToken");
      initBits &= ~INIT_BIT_BOT_ACCESS_TOKEN;
      return this;
    }

    /**
     * Builds a new {@link BotCredentials BotCredentials}.
     * @return An immutable instance of BotCredentials
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public BotCredentials build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new BotCredentials(botUserId, botAccessToken);
    }

    private boolean botUserIdIsSet() {
      return (initBits & INIT_BIT_BOT_USER_ID) == 0;
    }

    private boolean botAccessTokenIsSet() {
      return (initBits & INIT_BIT_BOT_ACCESS_TOKEN) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!botUserIdIsSet()) attributes.add("botUserId");
      if (!botAccessTokenIsSet()) attributes.add("botAccessToken");
      return "Cannot build BotCredentials, some of required attributes are not set " + attributes;
    }
  }
}
