package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link OptionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Option.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "OptionIF"})
@Immutable
public final class Option implements OptionIF {
  private final @Nullable String text;
  private final String value;

  private Option(@Nullable String text, String value) {
    this.text = text;
    this.value = value;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionIF#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Option withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return new Option(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionIF#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final Option withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return new Option(value, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final Option withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new Option(this.text, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Option} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Option
        && equalTo((Option) another);
  }

  private boolean equalTo(Option another) {
    return Objects.equals(text, another.text)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code text}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Option} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Option{");
    if (text != null) {
      builder.append("text=").append(text);
    }
    if (builder.length() > 7) builder.append(", ");
    builder.append("value=").append(value);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements OptionIF {
    Optional<String> text = Optional.empty();
    @Nullable String value;
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Option fromJson(Json json) {
    Option.Builder builder = Option.builder();
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OptionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Option instance
   */
  public static Option copyOf(OptionIF instance) {
    if (instance instanceof Option) {
      return (Option) instance;
    }
    return Option.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Option Option}.
   * @return A new Option builder
   */
  public static Option.Builder builder() {
    return new Option.Builder();
  }

  /**
   * Builds instances of type {@link Option Option}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String text;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OptionIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> textOptional = instance.getText();
      if (textOptional.isPresent()) {
        setText(textOptional);
      }
      setValue(instance.getValue());
      return this;
    }

    /**
     * Initializes the optional value {@link OptionIF#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionIF#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link OptionIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link Option Option}.
     * @return An immutable instance of Option
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Option build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Option(text, value);
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!valueIsSet()) attributes.add("value");
      return "Cannot build Option, some of required attributes are not set " + attributes;
    }
  }
}
