package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfirmIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Confirm.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfirmIF"})
@Immutable
public final class Confirm implements ConfirmIF {
  private final String title;
  private final String text;
  private final String okText;
  private final String dismissText;

  private Confirm(
      String title,
      String text,
      String okText,
      String dismissText) {
    this.title = title;
    this.text = text;
    this.okText = okText;
    this.dismissText = dismissText;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code okText} attribute
   */
  @JsonProperty
  @Override
  public String getOkText() {
    return okText;
  }

  /**
   * @return The value of the {@code dismissText} attribute
   */
  @JsonProperty
  @Override
  public String getDismissText() {
    return dismissText;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmIF#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final Confirm withTitle(String title) {
    if (this.title.equals(title)) return this;
    String newValue = Objects.requireNonNull(title, "title");
    return new Confirm(newValue, this.text, this.okText, this.dismissText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmIF#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final Confirm withText(String text) {
    if (this.text.equals(text)) return this;
    String newValue = Objects.requireNonNull(text, "text");
    return new Confirm(this.title, newValue, this.okText, this.dismissText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmIF#getOkText() okText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param okText A new value for okText
   * @return A modified copy of the {@code this} object
   */
  public final Confirm withOkText(String okText) {
    if (this.okText.equals(okText)) return this;
    String newValue = Objects.requireNonNull(okText, "okText");
    return new Confirm(this.title, this.text, newValue, this.dismissText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConfirmIF#getDismissText() dismissText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param dismissText A new value for dismissText
   * @return A modified copy of the {@code this} object
   */
  public final Confirm withDismissText(String dismissText) {
    if (this.dismissText.equals(dismissText)) return this;
    String newValue = Objects.requireNonNull(dismissText, "dismissText");
    return new Confirm(this.title, this.text, this.okText, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Confirm} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Confirm
        && equalTo((Confirm) another);
  }

  private boolean equalTo(Confirm another) {
    return title.equals(another.title)
        && text.equals(another.text)
        && okText.equals(another.okText)
        && dismissText.equals(another.dismissText);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code text}, {@code okText}, {@code dismissText}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + title.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + okText.hashCode();
    h = h * 17 + dismissText.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Confirm} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Confirm{"
        + "title=" + title
        + ", text=" + text
        + ", okText=" + okText
        + ", dismissText=" + dismissText
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConfirmIF {
    @Nullable String title;
    @Nullable String text;
    @Nullable String okText;
    @Nullable String dismissText;
    @JsonProperty
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty
    public void setText(String text) {
      this.text = text;
    }
    @JsonProperty
    public void setOkText(String okText) {
      this.okText = okText;
    }
    @JsonProperty
    public void setDismissText(String dismissText) {
      this.dismissText = dismissText;
    }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getOkText() { throw new UnsupportedOperationException(); }
    @Override
    public String getDismissText() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Confirm fromJson(Json json) {
    Confirm.Builder builder = Confirm.builder();
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.okText != null) {
      builder.setOkText(json.okText);
    }
    if (json.dismissText != null) {
      builder.setDismissText(json.dismissText);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConfirmIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Confirm instance
   */
  public static Confirm copyOf(ConfirmIF instance) {
    if (instance instanceof Confirm) {
      return (Confirm) instance;
    }
    return Confirm.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Confirm Confirm}.
   * @return A new Confirm builder
   */
  public static Confirm.Builder builder() {
    return new Confirm.Builder();
  }

  /**
   * Builds instances of type {@link Confirm Confirm}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private static final long INIT_BIT_TEXT = 0x2L;
    private static final long INIT_BIT_OK_TEXT = 0x4L;
    private static final long INIT_BIT_DISMISS_TEXT = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String title;
    private @Nullable String text;
    private @Nullable String okText;
    private @Nullable String dismissText;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConfirmIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConfirmIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTitle(instance.getTitle());
      setText(instance.getText());
      setOkText(instance.getOkText());
      setDismissText(instance.getDismissText());
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmIF#getOkText() okText} attribute.
     * @param okText The value for okText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOkText(String okText) {
      this.okText = Objects.requireNonNull(okText, "okText");
      initBits &= ~INIT_BIT_OK_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link ConfirmIF#getDismissText() dismissText} attribute.
     * @param dismissText The value for dismissText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDismissText(String dismissText) {
      this.dismissText = Objects.requireNonNull(dismissText, "dismissText");
      initBits &= ~INIT_BIT_DISMISS_TEXT;
      return this;
    }

    /**
     * Builds a new {@link Confirm Confirm}.
     * @return An immutable instance of Confirm
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Confirm build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Confirm(title, text, okText, dismissText);
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean okTextIsSet() {
      return (initBits & INIT_BIT_OK_TEXT) == 0;
    }

    private boolean dismissTextIsSet() {
      return (initBits & INIT_BIT_DISMISS_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!titleIsSet()) attributes.add("title");
      if (!textIsSet()) attributes.add("text");
      if (!okTextIsSet()) attributes.add("okText");
      if (!dismissTextIsSet()) attributes.add("dismissText");
      return "Cannot build Confirm, some of required attributes are not set " + attributes;
    }
  }
}
