package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ReplySkeletonIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ReplySkeleton.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ReplySkeletonIF"})
@Immutable
public final class ReplySkeleton implements ReplySkeletonIF {
  private final String userId;
  private final String replyTs;

  private ReplySkeleton(String userId, String replyTs) {
    this.userId = userId;
    this.replyTs = replyTs;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code replyTs} attribute
   */
  @JsonProperty("ts")
  @Override
  public String getReplyTs() {
    return replyTs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplySkeletonIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final ReplySkeleton withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new ReplySkeleton(newValue, this.replyTs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplySkeletonIF#getReplyTs() replyTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param replyTs A new value for replyTs
   * @return A modified copy of the {@code this} object
   */
  public final ReplySkeleton withReplyTs(String replyTs) {
    if (this.replyTs.equals(replyTs)) return this;
    String newValue = Objects.requireNonNull(replyTs, "replyTs");
    return new ReplySkeleton(this.userId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ReplySkeleton} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ReplySkeleton
        && equalTo((ReplySkeleton) another);
  }

  private boolean equalTo(ReplySkeleton another) {
    return userId.equals(another.userId)
        && replyTs.equals(another.replyTs);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code replyTs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + replyTs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReplySkeleton} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReplySkeleton{"
        + "userId=" + userId
        + ", replyTs=" + replyTs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReplySkeletonIF {
    @Nullable String userId;
    @Nullable String replyTs;
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("ts")
    public void setReplyTs(String replyTs) {
      this.replyTs = replyTs;
    }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getReplyTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ReplySkeleton fromJson(Json json) {
    ReplySkeleton.Builder builder = ReplySkeleton.builder();
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.replyTs != null) {
      builder.setReplyTs(json.replyTs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReplySkeletonIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReplySkeleton instance
   */
  public static ReplySkeleton copyOf(ReplySkeletonIF instance) {
    if (instance instanceof ReplySkeleton) {
      return (ReplySkeleton) instance;
    }
    return ReplySkeleton.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ReplySkeleton ReplySkeleton}.
   * @return A new ReplySkeleton builder
   */
  public static ReplySkeleton.Builder builder() {
    return new ReplySkeleton.Builder();
  }

  /**
   * Builds instances of type {@link ReplySkeleton ReplySkeleton}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long INIT_BIT_REPLY_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String userId;
    private @Nullable String replyTs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReplySkeletonIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReplySkeletonIF instance) {
      Objects.requireNonNull(instance, "instance");
      setUserId(instance.getUserId());
      setReplyTs(instance.getReplyTs());
      return this;
    }

    /**
     * Initializes the value for the {@link ReplySkeletonIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReplySkeletonIF#getReplyTs() replyTs} attribute.
     * @param replyTs The value for replyTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyTs(String replyTs) {
      this.replyTs = Objects.requireNonNull(replyTs, "replyTs");
      initBits &= ~INIT_BIT_REPLY_TS;
      return this;
    }

    /**
     * Builds a new {@link ReplySkeleton ReplySkeleton}.
     * @return An immutable instance of ReplySkeleton
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ReplySkeleton build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ReplySkeleton(userId, replyTs);
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean replyTsIsSet() {
      return (initBits & INIT_BIT_REPLY_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      if (!replyTsIsSet()) attributes.add("replyTs");
      return "Cannot build ReplySkeleton, some of required attributes are not set " + attributes;
    }
  }
}
