package com.hubspot.slack.client.methods.params.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.views.HomeTabViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PublishViewParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PublishViewParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code PublishViewParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PublishViewParamsIF"})
@Immutable
public final class PublishViewParams
    implements PublishViewParamsIF {
  private final String userId;
  private final HomeTabViewPayload view;
  private final @Nullable String hash;

  private PublishViewParams(String userId, HomeTabViewPayload view) {
    this.userId = Objects.requireNonNull(userId, "userId");
    this.view = Objects.requireNonNull(view, "view");
    this.hash = null;
  }

  private PublishViewParams(
      String userId,
      HomeTabViewPayload view,
      @Nullable String hash) {
    this.userId = userId;
    this.view = view;
    this.hash = hash;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public HomeTabViewPayload getView() {
    return view;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getHash() {
    return Optional.ofNullable(hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PublishViewParamsIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final PublishViewParams withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new PublishViewParams(newValue, this.view, this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PublishViewParamsIF#getView() view} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param view A new value for view
   * @return A modified copy of the {@code this} object
   */
  public final PublishViewParams withView(HomeTabViewPayload view) {
    if (this.view == view) return this;
    HomeTabViewPayload newValue = Objects.requireNonNull(view, "view");
    return new PublishViewParams(this.userId, newValue, this.hash);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PublishViewParamsIF#getHash() hash} attribute.
   * @param value The value for hash, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final PublishViewParams withHash(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.hash, newValue)) return this;
    return new PublishViewParams(this.userId, this.view, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PublishViewParamsIF#getHash() hash} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hash
   * @return A modified copy of {@code this} object
   */
  public final PublishViewParams withHash(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.hash, value)) return this;
    return new PublishViewParams(this.userId, this.view, value);
  }

  /**
   * This instance is equal to all instances of {@code PublishViewParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PublishViewParams
        && equalTo((PublishViewParams) another);
  }

  private boolean equalTo(PublishViewParams another) {
    return userId.equals(another.userId)
        && view.equals(another.view)
        && Objects.equals(hash, another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code view}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + view.hashCode();
    h = h * 17 + Objects.hashCode(hash);
    return h;
  }

  /**
   * Prints the immutable value {@code PublishViewParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PublishViewParams{");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("view=").append(view);
    if (hash != null) {
      builder.append(", ");
      builder.append("hash=").append(hash);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PublishViewParamsIF {
    @Nullable String userId;
    @Nullable HomeTabViewPayload view;
    Optional<String> hash = Optional.empty();
    @JsonProperty
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setView(HomeTabViewPayload view) {
      this.view = view;
    }
    @JsonProperty
    public void setHash(Optional<String> hash) {
      this.hash = hash;
    }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public HomeTabViewPayload getView() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static PublishViewParams fromJson(Json json) {
    PublishViewParams.Builder builder = PublishViewParams.builder();
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.view != null) {
      builder.setView(json.view);
    }
    if (json.hash != null) {
      builder.setHash(json.hash);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code PublishViewParams} instance.
   * @param userId The value for the {@code userId} attribute
   * @param view The value for the {@code view} attribute
   * @return An immutable PublishViewParams instance
   */
  public static PublishViewParams of(String userId, HomeTabViewPayload view) {
    return new PublishViewParams(userId, view);
  }

  /**
   * Creates an immutable copy of a {@link PublishViewParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PublishViewParams instance
   */
  public static PublishViewParams copyOf(PublishViewParamsIF instance) {
    if (instance instanceof PublishViewParams) {
      return (PublishViewParams) instance;
    }
    return PublishViewParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link PublishViewParams PublishViewParams}.
   * @return A new PublishViewParams builder
   */
  public static PublishViewParams.Builder builder() {
    return new PublishViewParams.Builder();
  }

  /**
   * Builds instances of type {@link PublishViewParams PublishViewParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long INIT_BIT_VIEW = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String userId;
    private @Nullable HomeTabViewPayload view;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PublishViewParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PublishViewParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setUserId(instance.getUserId());
      setView(instance.getView());
      Optional<String> hashOptional = instance.getHash();
      if (hashOptional.isPresent()) {
        setHash(hashOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PublishViewParamsIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PublishViewParamsIF#getView() view} attribute.
     * @param view The value for view 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(HomeTabViewPayload view) {
      this.view = Objects.requireNonNull(view, "view");
      initBits &= ~INIT_BIT_VIEW;
      return this;
    }

    /**
     * Initializes the optional value {@link PublishViewParamsIF#getHash() hash} to hash.
     * @param hash The value for hash, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setHash(@Nullable String hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Initializes the optional value {@link PublishViewParamsIF#getHash() hash} to hash.
     * @param hash The value for hash
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHash(Optional<String> hash) {
      this.hash = hash.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link PublishViewParams PublishViewParams}.
     * @return An immutable instance of PublishViewParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public PublishViewParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new PublishViewParams(userId, view, hash);
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean viewIsSet() {
      return (initBits & INIT_BIT_VIEW) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      if (!viewIsSet()) attributes.add("view");
      return "Cannot build PublishViewParams, some of required attributes are not set " + attributes;
    }
  }
}
