package com.hubspot.slack.client.methods.params.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.views.ModalViewPayload;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link OpenViewParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code OpenViewParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code OpenViewParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "OpenViewParamsIF"})
@Immutable
public final class OpenViewParams implements OpenViewParamsIF {
  private final String triggerId;
  private final ModalViewPayload view;

  private OpenViewParams(String triggerId, ModalViewPayload view) {
    this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
    this.view = Objects.requireNonNull(view, "view");
  }

  private OpenViewParams(
      OpenViewParams original,
      String triggerId,
      ModalViewPayload view) {
    this.triggerId = triggerId;
    this.view = view;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty
  @Override
  public ModalViewPayload getView() {
    return view;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OpenViewParamsIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final OpenViewParams withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new OpenViewParams(this, newValue, this.view);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OpenViewParamsIF#getView() view} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param view A new value for view
   * @return A modified copy of the {@code this} object
   */
  public final OpenViewParams withView(ModalViewPayload view) {
    if (this.view == view) return this;
    ModalViewPayload newValue = Objects.requireNonNull(view, "view");
    return new OpenViewParams(this, this.triggerId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code OpenViewParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof OpenViewParams
        && equalTo((OpenViewParams) another);
  }

  private boolean equalTo(OpenViewParams another) {
    return triggerId.equals(another.triggerId)
        && view.equals(another.view);
  }

  /**
   * Computes a hash code from attributes: {@code triggerId}, {@code view}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + view.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OpenViewParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OpenViewParams{"
        + "triggerId=" + triggerId
        + ", view=" + view
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements OpenViewParamsIF {
    @Nullable String triggerId;
    @Nullable ModalViewPayload view;
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setView(ModalViewPayload view) {
      this.view = view;
    }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public ModalViewPayload getView() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static OpenViewParams fromJson(Json json) {
    OpenViewParams.Builder builder = OpenViewParams.builder();
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.view != null) {
      builder.setView(json.view);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code OpenViewParams} instance.
   * @param triggerId The value for the {@code triggerId} attribute
   * @param view The value for the {@code view} attribute
   * @return An immutable OpenViewParams instance
   */
  public static OpenViewParams of(String triggerId, ModalViewPayload view) {
    return new OpenViewParams(triggerId, view);
  }

  /**
   * Creates an immutable copy of a {@link OpenViewParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OpenViewParams instance
   */
  public static OpenViewParams copyOf(OpenViewParamsIF instance) {
    if (instance instanceof OpenViewParams) {
      return (OpenViewParams) instance;
    }
    return OpenViewParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link OpenViewParams OpenViewParams}.
   * @return A new OpenViewParams builder
   */
  public static OpenViewParams.Builder builder() {
    return new OpenViewParams.Builder();
  }

  /**
   * Builds instances of type {@link OpenViewParams OpenViewParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRIGGER_ID = 0x1L;
    private static final long INIT_BIT_VIEW = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String triggerId;
    private @Nullable ModalViewPayload view;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OpenViewParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OpenViewParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTriggerId(instance.getTriggerId());
      setView(instance.getView());
      return this;
    }

    /**
     * Initializes the value for the {@link OpenViewParamsIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenViewParamsIF#getView() view} attribute.
     * @param view The value for view 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setView(ModalViewPayload view) {
      this.view = Objects.requireNonNull(view, "view");
      initBits &= ~INIT_BIT_VIEW;
      return this;
    }

    /**
     * Builds a new {@link OpenViewParams OpenViewParams}.
     * @return An immutable instance of OpenViewParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public OpenViewParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new OpenViewParams(null, triggerId, view);
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean viewIsSet() {
      return (initBits & INIT_BIT_VIEW) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!viewIsSet()) attributes.add("view");
      return "Cannot build OpenViewParams, some of required attributes are not set " + attributes;
    }
  }
}
