package com.hubspot.slack.client.methods.params.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsersListParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsersListParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsersListParamsIF"})
@Immutable
public final class UsersListParams implements UsersListParamsIF {
  private final @Nullable String cursor;
  private final @Nullable Integer limit;

  private UsersListParams(
      @Nullable String cursor,
      @Nullable Integer limit) {
    this.cursor = cursor;
    this.limit = limit;
  }

  /**
   * @return The value of the {@code cursor} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCursor() {
    return Optional.ofNullable(cursor);
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getLimit() {
    return Optional.ofNullable(limit);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsersListParamsIF#getCursor() cursor} attribute.
   * @param value The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsersListParams withCursor(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.cursor, newValue)) return this;
    return new UsersListParams(newValue, this.limit);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsersListParamsIF#getCursor() cursor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cursor
   * @return A modified copy of {@code this} object
   */
  public final UsersListParams withCursor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.cursor, value)) return this;
    return new UsersListParams(value, this.limit);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsersListParamsIF#getLimit() limit} attribute.
   * @param value The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsersListParams withLimit(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.limit, newValue)) return this;
    return new UsersListParams(this.cursor, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsersListParamsIF#getLimit() limit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for limit
   * @return A modified copy of {@code this} object
   */
  public final UsersListParams withLimit(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.limit, value)) return this;
    return new UsersListParams(this.cursor, value);
  }

  /**
   * This instance is equal to all instances of {@code UsersListParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsersListParams
        && equalTo((UsersListParams) another);
  }

  private boolean equalTo(UsersListParams another) {
    return Objects.equals(cursor, another.cursor)
        && Objects.equals(limit, another.limit);
  }

  /**
   * Computes a hash code from attributes: {@code cursor}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(cursor);
    h = h * 17 + Objects.hashCode(limit);
    return h;
  }

  /**
   * Prints the immutable value {@code UsersListParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsersListParams{");
    if (cursor != null) {
      builder.append("cursor=").append(cursor);
    }
    if (limit != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("limit=").append(limit);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsersListParamsIF {
    Optional<String> cursor = Optional.empty();
    Optional<Integer> limit = Optional.empty();
    @JsonProperty
    public void setCursor(Optional<String> cursor) {
      this.cursor = cursor;
    }
    @JsonProperty
    public void setLimit(Optional<Integer> limit) {
      this.limit = limit;
    }
    @Override
    public Optional<String> getCursor() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getLimit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsersListParams fromJson(Json json) {
    UsersListParams.Builder builder = UsersListParams.builder();
    if (json.cursor != null) {
      builder.setCursor(json.cursor);
    }
    if (json.limit != null) {
      builder.setLimit(json.limit);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsersListParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsersListParams instance
   */
  public static UsersListParams copyOf(UsersListParamsIF instance) {
    if (instance instanceof UsersListParams) {
      return (UsersListParams) instance;
    }
    return UsersListParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsersListParams UsersListParams}.
   * @return A new UsersListParams builder
   */
  public static UsersListParams.Builder builder() {
    return new UsersListParams.Builder();
  }

  /**
   * Builds instances of type {@link UsersListParams UsersListParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String cursor;
    private @Nullable Integer limit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsersListParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsersListParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> cursorOptional = instance.getCursor();
      if (cursorOptional.isPresent()) {
        setCursor(cursorOptional);
      }
      Optional<Integer> limitOptional = instance.getLimit();
      if (limitOptional.isPresent()) {
        setLimit(limitOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UsersListParamsIF#getCursor() cursor} to cursor.
     * @param cursor The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCursor(@Nullable String cursor) {
      this.cursor = cursor;
      return this;
    }

    /**
     * Initializes the optional value {@link UsersListParamsIF#getCursor() cursor} to cursor.
     * @param cursor The value for cursor
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCursor(Optional<String> cursor) {
      this.cursor = cursor.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UsersListParamsIF#getLimit() limit} to limit.
     * @param limit The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLimit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Initializes the optional value {@link UsersListParamsIF#getLimit() limit} to limit.
     * @param limit The value for limit
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLimit(Optional<Integer> limit) {
      this.limit = limit.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UsersListParams UsersListParams}.
     * @return An immutable instance of UsersListParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsersListParams build() throws InvalidImmutableStateException {
      return new UsersListParams(cursor, limit);
    }
  }
}
