package com.hubspot.slack.client.methods.params.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsersInfoParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsersInfoParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code UsersInfoParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsersInfoParamsIF"})
@Immutable
public final class UsersInfoParams implements UsersInfoParamsIF {
  private final String userId;
  private final boolean includeLocale;

  private UsersInfoParams(String userId) {
    this.userId = Objects.requireNonNull(userId, "userId");
    this.includeLocale = UsersInfoParamsIF.super.getIncludeLocale();
  }

  private UsersInfoParams(UsersInfoParams.Builder builder) {
    this.userId = builder.userId;
    this.includeLocale = builder.includeLocaleIsSet()
        ? builder.includeLocale
        : UsersInfoParamsIF.super.getIncludeLocale();
  }

  private UsersInfoParams(String userId, boolean includeLocale) {
    this.userId = userId;
    this.includeLocale = includeLocale;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code includeLocale} attribute
   */
  @JsonProperty("include_local")
  @Override
  public boolean getIncludeLocale() {
    return includeLocale;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersInfoParamsIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final UsersInfoParams withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new UsersInfoParams(newValue, this.includeLocale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersInfoParamsIF#getIncludeLocale() includeLocale} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param includeLocale A new value for includeLocale
   * @return A modified copy of the {@code this} object
   */
  public final UsersInfoParams withIncludeLocale(boolean includeLocale) {
    if (this.includeLocale == includeLocale) return this;
    return new UsersInfoParams(this.userId, includeLocale);
  }

  /**
   * This instance is equal to all instances of {@code UsersInfoParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsersInfoParams
        && equalTo((UsersInfoParams) another);
  }

  private boolean equalTo(UsersInfoParams another) {
    return userId.equals(another.userId)
        && includeLocale == another.includeLocale;
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code includeLocale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + Boolean.hashCode(includeLocale);
    return h;
  }

  /**
   * Prints the immutable value {@code UsersInfoParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UsersInfoParams{"
        + "userId=" + userId
        + ", includeLocale=" + includeLocale
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsersInfoParamsIF {
    @Nullable String userId;
    boolean includeLocale;
    boolean includeLocaleIsSet;
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("include_local")
    public void setIncludeLocale(boolean includeLocale) {
      this.includeLocale = includeLocale;
      this.includeLocaleIsSet = true;
    }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getIncludeLocale() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsersInfoParams fromJson(Json json) {
    UsersInfoParams.Builder builder = UsersInfoParams.builder();
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.includeLocaleIsSet) {
      builder.setIncludeLocale(json.includeLocale);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code UsersInfoParams} instance.
   * @param userId The value for the {@code userId} attribute
   * @return An immutable UsersInfoParams instance
   */
  public static UsersInfoParams of(String userId) {
    return new UsersInfoParams(userId);
  }

  /**
   * Creates an immutable copy of a {@link UsersInfoParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsersInfoParams instance
   */
  public static UsersInfoParams copyOf(UsersInfoParamsIF instance) {
    if (instance instanceof UsersInfoParams) {
      return (UsersInfoParams) instance;
    }
    return UsersInfoParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsersInfoParams UsersInfoParams}.
   * @return A new UsersInfoParams builder
   */
  public static UsersInfoParams.Builder builder() {
    return new UsersInfoParams.Builder();
  }

  /**
   * Builds instances of type {@link UsersInfoParams UsersInfoParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long OPT_BIT_INCLUDE_LOCALE = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String userId;
    private boolean includeLocale;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.users.UsersInfoParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsersInfoParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof UsersInfoParamsIF) {
        UsersInfoParamsIF instance = (UsersInfoParamsIF) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
        setIncludeLocale(instance.getIncludeLocale());
      }
      if (object instanceof HasUser) {
        HasUser instance = (HasUser) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link UsersInfoParamsIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UsersInfoParamsIF#getIncludeLocale() includeLocale} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link UsersInfoParamsIF#getIncludeLocale() includeLocale}.</em>
     * @param includeLocale The value for includeLocale 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeLocale(boolean includeLocale) {
      this.includeLocale = includeLocale;
      optBits |= OPT_BIT_INCLUDE_LOCALE;
      return this;
    }

    /**
     * Builds a new {@link UsersInfoParams UsersInfoParams}.
     * @return An immutable instance of UsersInfoParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsersInfoParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsersInfoParams(this);
    }

    private boolean includeLocaleIsSet() {
      return (optBits & OPT_BIT_INCLUDE_LOCALE) != 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      return "Cannot build UsersInfoParams, some of required attributes are not set " + attributes;
    }
  }
}
