package com.hubspot.slack.client.methods.params.usergroups.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedUserIds;
import com.hubspot.slack.client.methods.interceptor.HasUsergroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractUsergroupUsersUpdateParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsergroupUsersUpdateParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractUsergroupUsersUpdateParams"})
@Immutable
public final class UsergroupUsersUpdateParams
    extends AbstractUsergroupUsersUpdateParams {
  private final String usergroupId;
  private final @Nullable Boolean includeCount;
  private final List<String> rawUserIds;
  private final Optional<String> encodedUsers;

  private UsergroupUsersUpdateParams(
      String usergroupId,
      @Nullable Boolean includeCount,
      List<String> rawUserIds) {
    this.usergroupId = usergroupId;
    this.includeCount = includeCount;
    this.rawUserIds = rawUserIds;
    this.encodedUsers = Objects.requireNonNull(super.getEncodedUsers(), "encodedUsers");
  }

  /**
   * @return The value of the {@code usergroupId} attribute
   */
  @JsonProperty("usergroup")
  @Override
  public String getUsergroupId() {
    return usergroupId;
  }

  /**
   * @return The value of the {@code includeCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeCount() {
    return Optional.ofNullable(includeCount);
  }

  /**
   * @return The value of the {@code rawUserIds} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public List<String> getRawUserIds() {
    return rawUserIds;
  }

  /**
   * @return The computed-at-construction value of the {@code encodedUsers} attribute
   */
  @JsonProperty("users")
  @Override
  public Optional<String> getEncodedUsers() {
    return encodedUsers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractUsergroupUsersUpdateParams#getUsergroupId() usergroupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param usergroupId A new value for usergroupId
   * @return A modified copy of the {@code this} object
   */
  public final UsergroupUsersUpdateParams withUsergroupId(String usergroupId) {
    if (this.usergroupId.equals(usergroupId)) return this;
    String newValue = Objects.requireNonNull(usergroupId, "usergroupId");
    return new UsergroupUsersUpdateParams(newValue, this.includeCount, this.rawUserIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractUsergroupUsersUpdateParams#getIncludeCount() includeCount} attribute.
   * @param value The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupUsersUpdateParams withIncludeCount(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeCount, newValue)) return this;
    return new UsergroupUsersUpdateParams(this.usergroupId, newValue, this.rawUserIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractUsergroupUsersUpdateParams#getIncludeCount() includeCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeCount
   * @return A modified copy of {@code this} object
   */
  public final UsergroupUsersUpdateParams withIncludeCount(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeCount, value)) return this;
    return new UsergroupUsersUpdateParams(this.usergroupId, value, this.rawUserIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractUsergroupUsersUpdateParams#getRawUserIds() rawUserIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupUsersUpdateParams withRawUserIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new UsergroupUsersUpdateParams(this.usergroupId, this.includeCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractUsergroupUsersUpdateParams#getRawUserIds() rawUserIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rawUserIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupUsersUpdateParams withRawUserIds(Iterable<String> elements) {
    if (this.rawUserIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new UsergroupUsersUpdateParams(this.usergroupId, this.includeCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code UsergroupUsersUpdateParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsergroupUsersUpdateParams
        && equalTo((UsergroupUsersUpdateParams) another);
  }

  private boolean equalTo(UsergroupUsersUpdateParams another) {
    return usergroupId.equals(another.usergroupId)
        && Objects.equals(includeCount, another.includeCount)
        && rawUserIds.equals(another.rawUserIds)
        && encodedUsers.equals(another.encodedUsers);
  }

  /**
   * Computes a hash code from attributes: {@code usergroupId}, {@code includeCount}, {@code rawUserIds}, {@code encodedUsers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + usergroupId.hashCode();
    h = h * 17 + Objects.hashCode(includeCount);
    h = h * 17 + rawUserIds.hashCode();
    h = h * 17 + encodedUsers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsergroupUsersUpdateParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsergroupUsersUpdateParams{");
    builder.append("usergroupId=").append(usergroupId);
    if (includeCount != null) {
      builder.append(", ");
      builder.append("includeCount=").append(includeCount);
    }
    builder.append(", ");
    builder.append("rawUserIds=").append(rawUserIds);
    builder.append(", ");
    builder.append("encodedUsers=").append(encodedUsers);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractUsergroupUsersUpdateParams {
    @Nullable String usergroupId;
    Optional<Boolean> includeCount = Optional.empty();
    List<String> rawUserIds = Collections.emptyList();
    @JsonProperty("usergroup")
    public void setUsergroupId(String usergroupId) {
      this.usergroupId = usergroupId;
    }
    @JsonProperty
    public void setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount;
    }
    @JsonProperty
    @JsonIgnore
    public void setRawUserIds(List<String> rawUserIds) {
      this.rawUserIds = rawUserIds;
    }
    @Override
    public String getUsergroupId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeCount() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRawUserIds() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEncodedUsers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsergroupUsersUpdateParams fromJson(Json json) {
    UsergroupUsersUpdateParams.Builder builder = UsergroupUsersUpdateParams.builder();
    if (json.usergroupId != null) {
      builder.setUsergroupId(json.usergroupId);
    }
    if (json.includeCount != null) {
      builder.setIncludeCount(json.includeCount);
    }
    if (json.rawUserIds != null) {
      builder.addAllRawUserIds(json.rawUserIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractUsergroupUsersUpdateParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsergroupUsersUpdateParams instance
   */
  public static UsergroupUsersUpdateParams copyOf(AbstractUsergroupUsersUpdateParams instance) {
    if (instance instanceof UsergroupUsersUpdateParams) {
      return (UsergroupUsersUpdateParams) instance;
    }
    return UsergroupUsersUpdateParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsergroupUsersUpdateParams UsergroupUsersUpdateParams}.
   * @return A new UsergroupUsersUpdateParams builder
   */
  public static UsergroupUsersUpdateParams.Builder builder() {
    return new UsergroupUsersUpdateParams.Builder();
  }

  /**
   * Builds instances of type {@link UsergroupUsersUpdateParams UsergroupUsersUpdateParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USERGROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String usergroupId;
    private @Nullable Boolean includeCount;
    private List<String> rawUserIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUsergroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUsergroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.usergroups.users.AbstractUsergroupUsersUpdateParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUsergroupUsersUpdateParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedUserIds} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasCommaSeperatedUserIds instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasUsergroup) {
        HasUsergroup instance = (HasUsergroup) object;
        if ((bits & 0x1L) == 0) {
          setUsergroupId(instance.getUsergroupId());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractUsergroupUsersUpdateParams) {
        AbstractUsergroupUsersUpdateParams instance = (AbstractUsergroupUsersUpdateParams) object;
        if ((bits & 0x1L) == 0) {
          setUsergroupId(instance.getUsergroupId());
          bits |= 0x1L;
        }
        Optional<Boolean> includeCountOptional = instance.getIncludeCount();
        if (includeCountOptional.isPresent()) {
          setIncludeCount(includeCountOptional);
        }
      }
      if (object instanceof HasCommaSeperatedUserIds) {
        HasCommaSeperatedUserIds instance = (HasCommaSeperatedUserIds) object;
        addAllRawUserIds(instance.getRawUserIds());
      }
    }

    /**
     * Initializes the value for the {@link AbstractUsergroupUsersUpdateParams#getUsergroupId() usergroupId} attribute.
     * @param usergroupId The value for usergroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsergroupId(String usergroupId) {
      this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
      initBits &= ~INIT_BIT_USERGROUP_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractUsergroupUsersUpdateParams#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeCount(@Nullable Boolean includeCount) {
      this.includeCount = includeCount;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractUsergroupUsersUpdateParams#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link AbstractUsergroupUsersUpdateParams#getRawUserIds() rawUserIds} list.
     * @param element A rawUserIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRawUserIds(String element) {
      this.rawUserIds.add(Objects.requireNonNull(element, "rawUserIds element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractUsergroupUsersUpdateParams#getRawUserIds() rawUserIds} list.
     * @param elements An array of rawUserIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRawUserIds(String... elements) {
      for (String element : elements) {
        this.rawUserIds.add(Objects.requireNonNull(element, "rawUserIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractUsergroupUsersUpdateParams#getRawUserIds() rawUserIds} list.
     * @param elements An iterable of rawUserIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRawUserIds(Iterable<String> elements) {
      this.rawUserIds.clear();
      return addAllRawUserIds(elements);
    }

    /**
     * Adds elements to {@link AbstractUsergroupUsersUpdateParams#getRawUserIds() rawUserIds} list.
     * @param elements An iterable of rawUserIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRawUserIds(Iterable<String> elements) {
      for (String element : elements) {
        this.rawUserIds.add(Objects.requireNonNull(element, "rawUserIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UsergroupUsersUpdateParams UsergroupUsersUpdateParams}.
     * @return An immutable instance of UsergroupUsersUpdateParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsergroupUsersUpdateParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsergroupUsersUpdateParams(usergroupId, includeCount, createUnmodifiableList(true, rawUserIds));
    }

    private boolean usergroupIdIsSet() {
      return (initBits & INIT_BIT_USERGROUP_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!usergroupIdIsSet()) attributes.add("usergroupId");
      return "Cannot build UsergroupUsersUpdateParams, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
