package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedChannelIds;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsergroupCreateParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsergroupCreateParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsergroupCreateParamsIF"})
@Immutable
public final class UsergroupCreateParams
    implements UsergroupCreateParamsIF {
  private final String name;
  private final @Nullable String description;
  private final @Nullable String handle;
  private final @Nullable Boolean includeCount;
  private final List<String> rawChannelIds;
  private final Optional<String> encodedChannels;

  private UsergroupCreateParams(
      String name,
      @Nullable String description,
      @Nullable String handle,
      @Nullable Boolean includeCount,
      List<String> rawChannelIds) {
    this.name = name;
    this.description = description;
    this.handle = handle;
    this.includeCount = includeCount;
    this.rawChannelIds = rawChannelIds;
    this.encodedChannels = Objects.requireNonNull(UsergroupCreateParamsIF.super.getEncodedChannels(), "encodedChannels");
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getDescription() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code handle} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getHandle() {
    return Optional.ofNullable(handle);
  }

  /**
   * @return The value of the {@code includeCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeCount() {
    return Optional.ofNullable(includeCount);
  }

  /**
   * @return The value of the {@code rawChannelIds} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public List<String> getRawChannelIds() {
    return rawChannelIds;
  }

  /**
   * @return The computed-at-construction value of the {@code encodedChannels} attribute
   */
  @JsonProperty("channels")
  @Override
  public Optional<String> getEncodedChannels() {
    return encodedChannels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsergroupCreateParamsIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final UsergroupCreateParams withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new UsergroupCreateParams(newValue, this.description, this.handle, this.includeCount, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupCreateParamsIF#getDescription() description} attribute.
   * @param value The value for description, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withDescription(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.description, newValue)) return this;
    return new UsergroupCreateParams(this.name, newValue, this.handle, this.includeCount, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupCreateParamsIF#getDescription() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new UsergroupCreateParams(this.name, value, this.handle, this.includeCount, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupCreateParamsIF#getHandle() handle} attribute.
   * @param value The value for handle, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withHandle(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.handle, newValue)) return this;
    return new UsergroupCreateParams(this.name, this.description, newValue, this.includeCount, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupCreateParamsIF#getHandle() handle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for handle
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withHandle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.handle, value)) return this;
    return new UsergroupCreateParams(this.name, this.description, value, this.includeCount, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupCreateParamsIF#getIncludeCount() includeCount} attribute.
   * @param value The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withIncludeCount(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeCount, newValue)) return this;
    return new UsergroupCreateParams(this.name, this.description, this.handle, newValue, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupCreateParamsIF#getIncludeCount() includeCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeCount
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withIncludeCount(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeCount, value)) return this;
    return new UsergroupCreateParams(this.name, this.description, this.handle, value, this.rawChannelIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupCreateParamsIF#getRawChannelIds() rawChannelIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withRawChannelIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new UsergroupCreateParams(this.name, this.description, this.handle, this.includeCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupCreateParamsIF#getRawChannelIds() rawChannelIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rawChannelIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupCreateParams withRawChannelIds(Iterable<String> elements) {
    if (this.rawChannelIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new UsergroupCreateParams(this.name, this.description, this.handle, this.includeCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code UsergroupCreateParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsergroupCreateParams
        && equalTo((UsergroupCreateParams) another);
  }

  private boolean equalTo(UsergroupCreateParams another) {
    return name.equals(another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(handle, another.handle)
        && Objects.equals(includeCount, another.includeCount)
        && rawChannelIds.equals(another.rawChannelIds)
        && encodedChannels.equals(another.encodedChannels);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code handle}, {@code includeCount}, {@code rawChannelIds}, {@code encodedChannels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(description);
    h = h * 17 + Objects.hashCode(handle);
    h = h * 17 + Objects.hashCode(includeCount);
    h = h * 17 + rawChannelIds.hashCode();
    h = h * 17 + encodedChannels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsergroupCreateParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsergroupCreateParams{");
    builder.append("name=").append(name);
    if (description != null) {
      builder.append(", ");
      builder.append("description=").append(description);
    }
    if (handle != null) {
      builder.append(", ");
      builder.append("handle=").append(handle);
    }
    if (includeCount != null) {
      builder.append(", ");
      builder.append("includeCount=").append(includeCount);
    }
    builder.append(", ");
    builder.append("rawChannelIds=").append(rawChannelIds);
    builder.append(", ");
    builder.append("encodedChannels=").append(encodedChannels);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements UsergroupCreateParamsIF {
    @Nullable String name;
    Optional<String> description = Optional.empty();
    Optional<String> handle = Optional.empty();
    Optional<Boolean> includeCount = Optional.empty();
    List<String> rawChannelIds = Collections.emptyList();
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setDescription(Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setHandle(Optional<String> handle) {
      this.handle = handle;
    }
    @JsonProperty
    public void setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount;
    }
    @JsonProperty
    @JsonIgnore
    public void setRawChannelIds(List<String> rawChannelIds) {
      this.rawChannelIds = rawChannelIds;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getHandle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeCount() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRawChannelIds() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEncodedChannels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsergroupCreateParams fromJson(Json json) {
    UsergroupCreateParams.Builder builder = UsergroupCreateParams.builder();
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.description != null) {
      builder.setDescription(json.description);
    }
    if (json.handle != null) {
      builder.setHandle(json.handle);
    }
    if (json.includeCount != null) {
      builder.setIncludeCount(json.includeCount);
    }
    if (json.rawChannelIds != null) {
      builder.addAllRawChannelIds(json.rawChannelIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsergroupCreateParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsergroupCreateParams instance
   */
  public static UsergroupCreateParams copyOf(UsergroupCreateParamsIF instance) {
    if (instance instanceof UsergroupCreateParams) {
      return (UsergroupCreateParams) instance;
    }
    return UsergroupCreateParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsergroupCreateParams UsergroupCreateParams}.
   * @return A new UsergroupCreateParams builder
   */
  public static UsergroupCreateParams.Builder builder() {
    return new UsergroupCreateParams.Builder();
  }

  /**
   * Builds instances of type {@link UsergroupCreateParams UsergroupCreateParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String handle;
    private @Nullable Boolean includeCount;
    private List<String> rawChannelIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasCommaSeperatedChannelIds} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasCommaSeperatedChannelIds instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.usergroups.UsergroupCreateParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsergroupCreateParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof HasCommaSeperatedChannelIds) {
        HasCommaSeperatedChannelIds instance = (HasCommaSeperatedChannelIds) object;
        addAllRawChannelIds(instance.getRawChannelIds());
      }
      if (object instanceof UsergroupCreateParamsIF) {
        UsergroupCreateParamsIF instance = (UsergroupCreateParamsIF) object;
        setName(instance.getName());
        Optional<String> descriptionOptional = instance.getDescription();
        if (descriptionOptional.isPresent()) {
          setDescription(descriptionOptional);
        }
        Optional<String> handleOptional = instance.getHandle();
        if (handleOptional.isPresent()) {
          setHandle(handleOptional);
        }
        Optional<Boolean> includeCountOptional = instance.getIncludeCount();
        if (includeCountOptional.isPresent()) {
          setIncludeCount(includeCountOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link UsergroupCreateParamsIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupCreateParamsIF#getDescription() description} to description.
     * @param description The value for description, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setDescription(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupCreateParamsIF#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDescription(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupCreateParamsIF#getHandle() handle} to handle.
     * @param handle The value for handle, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setHandle(@Nullable String handle) {
      this.handle = handle;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupCreateParamsIF#getHandle() handle} to handle.
     * @param handle The value for handle
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHandle(Optional<String> handle) {
      this.handle = handle.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupCreateParamsIF#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeCount(@Nullable Boolean includeCount) {
      this.includeCount = includeCount;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupCreateParamsIF#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link UsergroupCreateParamsIF#getRawChannelIds() rawChannelIds} list.
     * @param element A rawChannelIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRawChannelIds(String element) {
      this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UsergroupCreateParamsIF#getRawChannelIds() rawChannelIds} list.
     * @param elements An array of rawChannelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRawChannelIds(String... elements) {
      for (String element : elements) {
        this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link UsergroupCreateParamsIF#getRawChannelIds() rawChannelIds} list.
     * @param elements An iterable of rawChannelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRawChannelIds(Iterable<String> elements) {
      this.rawChannelIds.clear();
      return addAllRawChannelIds(elements);
    }

    /**
     * Adds elements to {@link UsergroupCreateParamsIF#getRawChannelIds() rawChannelIds} list.
     * @param elements An iterable of rawChannelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRawChannelIds(Iterable<String> elements) {
      for (String element : elements) {
        this.rawChannelIds.add(Objects.requireNonNull(element, "rawChannelIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UsergroupCreateParams UsergroupCreateParams}.
     * @return An immutable instance of UsergroupCreateParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsergroupCreateParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsergroupCreateParams(name, description, handle, includeCount, createUnmodifiableList(true, rawChannelIds));
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      return "Cannot build UsergroupCreateParams, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
