package com.hubspot.slack.client.methods.params.reactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ReactionsAddParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ReactionsAddParams.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ReactionsAddParamsIF"})
@Immutable
public final class ReactionsAddParams
    implements ReactionsAddParamsIF {
  private final String name;
  private final @Nullable String channel;
  private final @Nullable String timestamp;
  private final @Nullable String file;
  private final @Nullable String fileComment;

  private ReactionsAddParams(
      String name,
      @Nullable String channel,
      @Nullable String timestamp,
      @Nullable String file,
      @Nullable String fileComment) {
    this.name = name;
    this.channel = channel;
    this.timestamp = timestamp;
    this.file = file;
    this.fileComment = fileComment;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getChannel() {
    return Optional.ofNullable(channel);
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getTimestamp() {
    return Optional.ofNullable(timestamp);
  }

  /**
   * @deprecated As of 22nd August 2019, Slack has removed support for file comments -
   * <a href="https://api.slack.com/changelog/2018-05-file-threads-soon-tread#whats_changed">
   *   file threads are the replacement
   * </a>
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<String> getFile() {
    return Optional.ofNullable(file);
  }

  /**
   * @deprecated As of 22nd August 2019, Slack has removed support for file comments -
   * <a href="https://api.slack.com/changelog/2018-05-file-threads-soon-tread#whats_changed">
   *   file threads are the replacement
   * </a>
   */
  @JsonProperty
  @Deprecated
  @Override
  public Optional<String> getFileComment() {
    return Optional.ofNullable(fileComment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReactionsAddParamsIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ReactionsAddParams withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return validate(new ReactionsAddParams(newValue, this.channel, this.timestamp, this.file, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ReactionsAddParamsIF#getChannel() channel} attribute.
   * @param value The value for channel, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ReactionsAddParams withChannel(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.channel, newValue)) return this;
    return validate(new ReactionsAddParams(this.name, newValue, this.timestamp, this.file, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ReactionsAddParamsIF#getChannel() channel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for channel
   * @return A modified copy of {@code this} object
   */
  public final ReactionsAddParams withChannel(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.channel, value)) return this;
    return validate(new ReactionsAddParams(this.name, value, this.timestamp, this.file, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ReactionsAddParamsIF#getTimestamp() timestamp} attribute.
   * @param value The value for timestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ReactionsAddParams withTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.timestamp, newValue)) return this;
    return validate(new ReactionsAddParams(this.name, this.channel, newValue, this.file, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ReactionsAddParamsIF#getTimestamp() timestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for timestamp
   * @return A modified copy of {@code this} object
   */
  public final ReactionsAddParams withTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.timestamp, value)) return this;
    return validate(new ReactionsAddParams(this.name, this.channel, value, this.file, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ReactionsAddParamsIF#getFile() file} attribute.
   * @param value The value for file, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ReactionsAddParams withFile(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.file, newValue)) return this;
    return validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, newValue, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ReactionsAddParamsIF#getFile() file} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for file
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ReactionsAddParams withFile(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.file, value)) return this;
    return validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, value, this.fileComment));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ReactionsAddParamsIF#getFileComment() fileComment} attribute.
   * @param value The value for fileComment, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ReactionsAddParams withFileComment(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.fileComment, newValue)) return this;
    return validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, this.file, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ReactionsAddParamsIF#getFileComment() fileComment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for fileComment
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ReactionsAddParams withFileComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.fileComment, value)) return this;
    return validate(new ReactionsAddParams(this.name, this.channel, this.timestamp, this.file, value));
  }

  /**
   * This instance is equal to all instances of {@code ReactionsAddParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ReactionsAddParams
        && equalTo((ReactionsAddParams) another);
  }

  private boolean equalTo(ReactionsAddParams another) {
    return name.equals(another.name)
        && Objects.equals(channel, another.channel)
        && Objects.equals(timestamp, another.timestamp)
        && Objects.equals(file, another.file)
        && Objects.equals(fileComment, another.fileComment);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code channel}, {@code timestamp}, {@code file}, {@code fileComment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(channel);
    h = h * 17 + Objects.hashCode(timestamp);
    h = h * 17 + Objects.hashCode(file);
    h = h * 17 + Objects.hashCode(fileComment);
    return h;
  }

  /**
   * Prints the immutable value {@code ReactionsAddParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ReactionsAddParams{");
    builder.append("name=").append(name);
    if (channel != null) {
      builder.append(", ");
      builder.append("channel=").append(channel);
    }
    if (timestamp != null) {
      builder.append(", ");
      builder.append("timestamp=").append(timestamp);
    }
    if (file != null) {
      builder.append(", ");
      builder.append("file=").append(file);
    }
    if (fileComment != null) {
      builder.append(", ");
      builder.append("fileComment=").append(fileComment);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReactionsAddParamsIF {
    @Nullable String name;
    Optional<String> channel = Optional.empty();
    Optional<String> timestamp = Optional.empty();
    Optional<String> file = Optional.empty();
    Optional<String> fileComment = Optional.empty();
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setChannel(Optional<String> channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setTimestamp(Optional<String> timestamp) {
      this.timestamp = timestamp;
    }
    @JsonProperty
    public void setFile(Optional<String> file) {
      this.file = file;
    }
    @JsonProperty
    public void setFileComment(Optional<String> fileComment) {
      this.fileComment = fileComment;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getFile() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getFileComment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ReactionsAddParams fromJson(Json json) {
    ReactionsAddParams.Builder builder = ReactionsAddParams.builder();
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.timestamp != null) {
      builder.setTimestamp(json.timestamp);
    }
    if (json.file != null) {
      builder.setFile(json.file);
    }
    if (json.fileComment != null) {
      builder.setFileComment(json.fileComment);
    }
    return builder.build();
  }

  private static ReactionsAddParams validate(ReactionsAddParams instance) {
    instance.reactionRecipientExists();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ReactionsAddParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReactionsAddParams instance
   */
  public static ReactionsAddParams copyOf(ReactionsAddParamsIF instance) {
    if (instance instanceof ReactionsAddParams) {
      return (ReactionsAddParams) instance;
    }
    return ReactionsAddParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ReactionsAddParams ReactionsAddParams}.
   * @return A new ReactionsAddParams builder
   */
  public static ReactionsAddParams.Builder builder() {
    return new ReactionsAddParams.Builder();
  }

  /**
   * Builds instances of type {@link ReactionsAddParams ReactionsAddParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable String channel;
    private @Nullable String timestamp;
    private @Nullable String file;
    private @Nullable String fileComment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReactionsAddParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReactionsAddParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setName(instance.getName());
      Optional<String> channelOptional = instance.getChannel();
      if (channelOptional.isPresent()) {
        setChannel(channelOptional);
      }
      Optional<String> timestampOptional = instance.getTimestamp();
      if (timestampOptional.isPresent()) {
        setTimestamp(timestampOptional);
      }
      Optional<String> fileOptional = instance.getFile();
      if (fileOptional.isPresent()) {
        setFile(fileOptional);
      }
      Optional<String> fileCommentOptional = instance.getFileComment();
      if (fileCommentOptional.isPresent()) {
        setFileComment(fileCommentOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReactionsAddParamsIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getChannel() channel} to channel.
     * @param channel The value for channel, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setChannel(@Nullable String channel) {
      this.channel = channel;
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getChannel() channel} to channel.
     * @param channel The value for channel
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(Optional<String> channel) {
      this.channel = channel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getTimestamp() timestamp} to timestamp.
     * @param timestamp The value for timestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTimestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getTimestamp() timestamp} to timestamp.
     * @param timestamp The value for timestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimestamp(Optional<String> timestamp) {
      this.timestamp = timestamp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getFile() file} to file.
     * @param file The value for file, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @Deprecated
    public final Builder setFile(@Nullable String file) {
      this.file = file;
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getFile() file} to file.
     * @param file The value for file
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder setFile(Optional<String> file) {
      this.file = file.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getFileComment() fileComment} to fileComment.
     * @param fileComment The value for fileComment, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @Deprecated
    public final Builder setFileComment(@Nullable String fileComment) {
      this.fileComment = fileComment;
      return this;
    }

    /**
     * Initializes the optional value {@link ReactionsAddParamsIF#getFileComment() fileComment} to fileComment.
     * @param fileComment The value for fileComment
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder setFileComment(Optional<String> fileComment) {
      this.fileComment = fileComment.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ReactionsAddParams ReactionsAddParams}.
     * @return An immutable instance of ReactionsAddParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ReactionsAddParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return ReactionsAddParams.validate(new ReactionsAddParams(name, channel, timestamp, file, fileComment));
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      return "Cannot build ReactionsAddParams, some of required attributes are not set " + attributes;
    }
  }
}
