package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationsJoinParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationsJoinParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationsJoinParamsIF"})
@Immutable
public final class ConversationsJoinParams
    implements ConversationsJoinParamsIF {
  private final String channelId;

  private ConversationsJoinParams(String channelId) {
    this.channelId = channelId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsJoinParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsJoinParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationsJoinParams(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationsJoinParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationsJoinParams
        && equalTo((ConversationsJoinParams) another);
  }

  private boolean equalTo(ConversationsJoinParams another) {
    return channelId.equals(another.channelId);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationsJoinParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationsJoinParams{"
        + "channelId=" + channelId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationsJoinParamsIF {
    @Nullable String channelId;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationsJoinParams fromJson(Json json) {
    ConversationsJoinParams.Builder builder = ConversationsJoinParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationsJoinParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationsJoinParams instance
   */
  public static ConversationsJoinParams copyOf(ConversationsJoinParamsIF instance) {
    if (instance instanceof ConversationsJoinParams) {
      return (ConversationsJoinParams) instance;
    }
    return ConversationsJoinParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationsJoinParams ConversationsJoinParams}.
   * @return A new ConversationsJoinParams builder
   */
  public static ConversationsJoinParams.Builder builder() {
    return new ConversationsJoinParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationsJoinParams ConversationsJoinParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String channelId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationsJoinParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationsJoinParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setChannelId(instance.getChannelId());
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsJoinParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Builds a new {@link ConversationsJoinParams ConversationsJoinParams}.
     * @return An immutable instance of ConversationsJoinParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationsJoinParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationsJoinParams(channelId);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationsJoinParams, some of required attributes are not set " + attributes;
    }
  }
}
