package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationSetTopicParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationSetTopicParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationSetTopicParamsIF"})
@Immutable
public final class ConversationSetTopicParams
    implements ConversationSetTopicParamsIF {
  private final String topic;
  private final String channelId;

  private ConversationSetTopicParams(String topic, String channelId) {
    this.topic = topic;
    this.channelId = channelId;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @JsonProperty
  @Override
  public String getTopic() {
    return topic;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationSetTopicParamsIF#getTopic() topic} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param topic A new value for topic
   * @return A modified copy of the {@code this} object
   */
  public final ConversationSetTopicParams withTopic(String topic) {
    if (this.topic.equals(topic)) return this;
    String newValue = Objects.requireNonNull(topic, "topic");
    return new ConversationSetTopicParams(newValue, this.channelId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationSetTopicParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationSetTopicParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationSetTopicParams(this.topic, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationSetTopicParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationSetTopicParams
        && equalTo((ConversationSetTopicParams) another);
  }

  private boolean equalTo(ConversationSetTopicParams another) {
    return topic.equals(another.topic)
        && channelId.equals(another.channelId);
  }

  /**
   * Computes a hash code from attributes: {@code topic}, {@code channelId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + topic.hashCode();
    h = h * 17 + channelId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationSetTopicParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationSetTopicParams{"
        + "topic=" + topic
        + ", channelId=" + channelId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationSetTopicParamsIF {
    @Nullable String topic;
    @Nullable String channelId;
    @JsonProperty
    public void setTopic(String topic) {
      this.topic = topic;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @Override
    public String getTopic() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationSetTopicParams fromJson(Json json) {
    ConversationSetTopicParams.Builder builder = ConversationSetTopicParams.builder();
    if (json.topic != null) {
      builder.setTopic(json.topic);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationSetTopicParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationSetTopicParams instance
   */
  public static ConversationSetTopicParams copyOf(ConversationSetTopicParamsIF instance) {
    if (instance instanceof ConversationSetTopicParams) {
      return (ConversationSetTopicParams) instance;
    }
    return ConversationSetTopicParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationSetTopicParams ConversationSetTopicParams}.
   * @return A new ConversationSetTopicParams builder
   */
  public static ConversationSetTopicParams.Builder builder() {
    return new ConversationSetTopicParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationSetTopicParams ConversationSetTopicParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOPIC = 0x1L;
    private static final long INIT_BIT_CHANNEL_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String topic;
    private @Nullable String channelId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationSetTopicParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationSetTopicParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTopic(instance.getTopic());
      setChannelId(instance.getChannelId());
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationSetTopicParamsIF#getTopic() topic} attribute.
     * @param topic The value for topic 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTopic(String topic) {
      this.topic = Objects.requireNonNull(topic, "topic");
      initBits &= ~INIT_BIT_TOPIC;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationSetTopicParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Builds a new {@link ConversationSetTopicParams ConversationSetTopicParams}.
     * @return An immutable instance of ConversationSetTopicParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationSetTopicParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationSetTopicParams(topic, channelId);
    }

    private boolean topicIsSet() {
      return (initBits & INIT_BIT_TOPIC) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!topicIsSet()) attributes.add("topic");
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationSetTopicParams, some of required attributes are not set " + attributes;
    }
  }
}
