package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationSetPurposeParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationSetPurposeParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationSetPurposeParamsIF"})
@Immutable
public final class ConversationSetPurposeParams
    implements ConversationSetPurposeParamsIF {
  private final String purpose;
  private final String channelId;

  private ConversationSetPurposeParams(String purpose, String channelId) {
    this.purpose = purpose;
    this.channelId = channelId;
  }

  /**
   * @return The value of the {@code purpose} attribute
   */
  @JsonProperty
  @Override
  public String getPurpose() {
    return purpose;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationSetPurposeParamsIF#getPurpose() purpose} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param purpose A new value for purpose
   * @return A modified copy of the {@code this} object
   */
  public final ConversationSetPurposeParams withPurpose(String purpose) {
    if (this.purpose.equals(purpose)) return this;
    String newValue = Objects.requireNonNull(purpose, "purpose");
    return new ConversationSetPurposeParams(newValue, this.channelId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationSetPurposeParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationSetPurposeParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationSetPurposeParams(this.purpose, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationSetPurposeParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationSetPurposeParams
        && equalTo((ConversationSetPurposeParams) another);
  }

  private boolean equalTo(ConversationSetPurposeParams another) {
    return purpose.equals(another.purpose)
        && channelId.equals(another.channelId);
  }

  /**
   * Computes a hash code from attributes: {@code purpose}, {@code channelId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + purpose.hashCode();
    h = h * 17 + channelId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationSetPurposeParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationSetPurposeParams{"
        + "purpose=" + purpose
        + ", channelId=" + channelId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationSetPurposeParamsIF {
    @Nullable String purpose;
    @Nullable String channelId;
    @JsonProperty
    public void setPurpose(String purpose) {
      this.purpose = purpose;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @Override
    public String getPurpose() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationSetPurposeParams fromJson(Json json) {
    ConversationSetPurposeParams.Builder builder = ConversationSetPurposeParams.builder();
    if (json.purpose != null) {
      builder.setPurpose(json.purpose);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationSetPurposeParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationSetPurposeParams instance
   */
  public static ConversationSetPurposeParams copyOf(ConversationSetPurposeParamsIF instance) {
    if (instance instanceof ConversationSetPurposeParams) {
      return (ConversationSetPurposeParams) instance;
    }
    return ConversationSetPurposeParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationSetPurposeParams ConversationSetPurposeParams}.
   * @return A new ConversationSetPurposeParams builder
   */
  public static ConversationSetPurposeParams.Builder builder() {
    return new ConversationSetPurposeParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationSetPurposeParams ConversationSetPurposeParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PURPOSE = 0x1L;
    private static final long INIT_BIT_CHANNEL_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String purpose;
    private @Nullable String channelId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationSetPurposeParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationSetPurposeParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setPurpose(instance.getPurpose());
      setChannelId(instance.getChannelId());
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationSetPurposeParamsIF#getPurpose() purpose} attribute.
     * @param purpose The value for purpose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPurpose(String purpose) {
      this.purpose = Objects.requireNonNull(purpose, "purpose");
      initBits &= ~INIT_BIT_PURPOSE;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationSetPurposeParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Builds a new {@link ConversationSetPurposeParams ConversationSetPurposeParams}.
     * @return An immutable instance of ConversationSetPurposeParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationSetPurposeParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationSetPurposeParams(purpose, channelId);
    }

    private boolean purposeIsSet() {
      return (initBits & INIT_BIT_PURPOSE) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!purposeIsSet()) attributes.add("purpose");
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationSetPurposeParams, some of required attributes are not set " + attributes;
    }
  }
}
