package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationInviteParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationInviteParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationInviteParamsIF"})
@Immutable
public final class ConversationInviteParams
    implements ConversationInviteParamsIF {
  private final String channelId;
  private final List<String> users;

  private ConversationInviteParams(String channelId, List<String> users) {
    this.channelId = channelId;
    this.users = users;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public List<String> getUsers() {
    return users;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationInviteParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationInviteParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationInviteParams(newValue, this.users);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationInviteParamsIF#getUsers() users}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationInviteParams withUsers(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ConversationInviteParams(this.channelId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationInviteParamsIF#getUsers() users}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of users elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationInviteParams withUsers(Iterable<String> elements) {
    if (this.users == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ConversationInviteParams(this.channelId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationInviteParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationInviteParams
        && equalTo((ConversationInviteParams) another);
  }

  private boolean equalTo(ConversationInviteParams another) {
    return channelId.equals(another.channelId)
        && users.equals(another.users);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code users}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + users.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationInviteParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationInviteParams{"
        + "channelId=" + channelId
        + ", users=" + users
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationInviteParamsIF {
    @Nullable String channelId;
    List<String> users = Collections.emptyList();
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    @JsonIgnore
    public void setUsers(List<String> users) {
      this.users = users;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getUsers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationInviteParams fromJson(Json json) {
    ConversationInviteParams.Builder builder = ConversationInviteParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.users != null) {
      builder.addAllUsers(json.users);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationInviteParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationInviteParams instance
   */
  public static ConversationInviteParams copyOf(ConversationInviteParamsIF instance) {
    if (instance instanceof ConversationInviteParams) {
      return (ConversationInviteParams) instance;
    }
    return ConversationInviteParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationInviteParams ConversationInviteParams}.
   * @return A new ConversationInviteParams builder
   */
  public static ConversationInviteParams.Builder builder() {
    return new ConversationInviteParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationInviteParams ConversationInviteParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String channelId;
    private List<String> users = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.conversations.ConversationInviteParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationInviteParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ConversationInviteParamsIF) {
        ConversationInviteParamsIF instance = (ConversationInviteParamsIF) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
        addAllUsers(instance.getUsers());
      }
    }

    /**
     * Initializes the value for the {@link ConversationInviteParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Adds one element to {@link ConversationInviteParamsIF#getUsers() users} list.
     * @param element A users element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String element) {
      this.users.add(Objects.requireNonNull(element, "users element"));
      return this;
    }

    /**
     * Adds elements to {@link ConversationInviteParamsIF#getUsers() users} list.
     * @param elements An array of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String... elements) {
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ConversationInviteParamsIF#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsers(Iterable<String> elements) {
      this.users.clear();
      return addAllUsers(elements);
    }

    /**
     * Adds elements to {@link ConversationInviteParamsIF#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUsers(Iterable<String> elements) {
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ConversationInviteParams ConversationInviteParams}.
     * @return An immutable instance of ConversationInviteParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationInviteParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationInviteParams(channelId, createUnmodifiableList(true, users));
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationInviteParams, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
