package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationCreateParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationCreateParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationCreateParamsIF"})
@Immutable
public final class ConversationCreateParams
    implements ConversationCreateParamsIF {
  private final String name;
  private final boolean isPrivate;

  private ConversationCreateParams(String name, boolean isPrivate) {
    this.name = name;
    this.isPrivate = isPrivate;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code isPrivate} attribute
   */
  @JsonProperty("is_private")
  @Override
  public boolean isPrivate() {
    return isPrivate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationCreateParamsIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ConversationCreateParams withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new ConversationCreateParams(newValue, this.isPrivate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationCreateParamsIF#isPrivate() isPrivate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isPrivate A new value for isPrivate
   * @return A modified copy of the {@code this} object
   */
  public final ConversationCreateParams withIsPrivate(boolean isPrivate) {
    if (this.isPrivate == isPrivate) return this;
    return new ConversationCreateParams(this.name, isPrivate);
  }

  /**
   * This instance is equal to all instances of {@code ConversationCreateParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationCreateParams
        && equalTo((ConversationCreateParams) another);
  }

  private boolean equalTo(ConversationCreateParams another) {
    return name.equals(another.name)
        && isPrivate == another.isPrivate;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code isPrivate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Boolean.hashCode(isPrivate);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationCreateParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationCreateParams{"
        + "name=" + name
        + ", isPrivate=" + isPrivate
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationCreateParamsIF {
    @Nullable String name;
    boolean isPrivate;
    boolean isPrivateIsSet;
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("is_private")
    public void setIsPrivate(boolean isPrivate) {
      this.isPrivate = isPrivate;
      this.isPrivateIsSet = true;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPrivate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationCreateParams fromJson(Json json) {
    ConversationCreateParams.Builder builder = ConversationCreateParams.builder();
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.isPrivateIsSet) {
      builder.setIsPrivate(json.isPrivate);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationCreateParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationCreateParams instance
   */
  public static ConversationCreateParams copyOf(ConversationCreateParamsIF instance) {
    if (instance instanceof ConversationCreateParams) {
      return (ConversationCreateParams) instance;
    }
    return ConversationCreateParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationCreateParams ConversationCreateParams}.
   * @return A new ConversationCreateParams builder
   */
  public static ConversationCreateParams.Builder builder() {
    return new ConversationCreateParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationCreateParams ConversationCreateParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_IS_PRIVATE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private boolean isPrivate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationCreateParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationCreateParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setName(instance.getName());
      setIsPrivate(instance.isPrivate());
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationCreateParamsIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationCreateParamsIF#isPrivate() isPrivate} attribute.
     * @param isPrivate The value for isPrivate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsPrivate(boolean isPrivate) {
      this.isPrivate = isPrivate;
      initBits &= ~INIT_BIT_IS_PRIVATE;
      return this;
    }

    /**
     * Builds a new {@link ConversationCreateParams ConversationCreateParams}.
     * @return An immutable instance of ConversationCreateParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationCreateParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationCreateParams(name, isPrivate);
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean isPrivateIsSet() {
      return (initBits & INIT_BIT_IS_PRIVATE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      if (!isPrivateIsSet()) attributes.add("isPrivate");
      return "Cannot build ConversationCreateParams, some of required attributes are not set " + attributes;
    }
  }
}
