package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.TopLevelMessageResponseType;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlashCommandResponseParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlashCommandResponseParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlashCommandResponseParams"})
@Immutable
public final class SlashCommandResponseParams
    extends AbstractSlashCommandResponseParams {
  private final TopLevelMessageResponseType responseType;
  private final String channelId;
  private final @Nullable String text;
  private final @Nullable String threadTs;
  private final @Nullable String username;
  private final @Nullable Boolean asUser;
  private final @Nullable String iconEmoji;
  private final @Nullable String iconUrl;
  private final @Nullable Boolean linkNames;
  private final @Nullable Boolean unfurlLinks;
  private final @Nullable Boolean unfurlMedia;
  private final @Nullable Boolean replyBroadcast;
  private final List<Attachment> attachments;
  private final List<Block> blocks;

  private SlashCommandResponseParams(SlashCommandResponseParams.Builder builder) {
    this.channelId = builder.channelId;
    this.text = builder.text;
    this.threadTs = builder.threadTs;
    this.username = builder.username;
    this.asUser = builder.asUser;
    this.iconEmoji = builder.iconEmoji;
    this.iconUrl = builder.iconUrl;
    this.linkNames = builder.linkNames;
    this.unfurlLinks = builder.unfurlLinks;
    this.unfurlMedia = builder.unfurlMedia;
    this.replyBroadcast = builder.replyBroadcast;
    this.attachments = createUnmodifiableList(true, builder.attachments);
    if (builder.responseType != null) {
      initShim.setResponseType(builder.responseType);
    }
    if (builder.blocksIsSet()) {
      initShim.setBlocks(createUnmodifiableList(true, builder.blocks));
    }
    this.responseType = initShim.getResponseType();
    this.blocks = initShim.getBlocks();
    this.initShim = null;
  }

  private SlashCommandResponseParams(
      TopLevelMessageResponseType responseType,
      String channelId,
      @Nullable String text,
      @Nullable String threadTs,
      @Nullable String username,
      @Nullable Boolean asUser,
      @Nullable String iconEmoji,
      @Nullable String iconUrl,
      @Nullable Boolean linkNames,
      @Nullable Boolean unfurlLinks,
      @Nullable Boolean unfurlMedia,
      @Nullable Boolean replyBroadcast,
      List<Attachment> attachments,
      List<Block> blocks) {
    this.responseType = responseType;
    this.channelId = channelId;
    this.text = text;
    this.threadTs = threadTs;
    this.username = username;
    this.asUser = asUser;
    this.iconEmoji = iconEmoji;
    this.iconUrl = iconUrl;
    this.linkNames = linkNames;
    this.unfurlLinks = unfurlLinks;
    this.unfurlMedia = unfurlMedia;
    this.replyBroadcast = replyBroadcast;
    this.attachments = attachments;
    this.blocks = blocks;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private TopLevelMessageResponseType responseType;
    private int responseTypeStage;

    TopLevelMessageResponseType getResponseType() {
      if (responseTypeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (responseTypeStage == STAGE_UNINITIALIZED) {
        responseTypeStage = STAGE_INITIALIZING;
        this.responseType = Objects.requireNonNull(SlashCommandResponseParams.super.getResponseType(), "responseType");
        responseTypeStage = STAGE_INITIALIZED;
      }
      return this.responseType;
    }

    void setResponseType(TopLevelMessageResponseType responseType) {
      this.responseType = responseType;
      responseTypeStage = STAGE_INITIALIZED;
    }
    private List<Block> blocks;
    private int blocksStage;

    List<Block> getBlocks() {
      if (blocksStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (blocksStage == STAGE_UNINITIALIZED) {
        blocksStage = STAGE_INITIALIZING;
        this.blocks = createUnmodifiableList(false, createSafeList(SlashCommandResponseParams.super.getBlocks(), true, false));
        blocksStage = STAGE_INITIALIZED;
      }
      return this.blocks;
    }

    void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      blocksStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (responseTypeStage == STAGE_INITIALIZING) attributes.add("responseType");
      if (blocksStage == STAGE_INITIALIZING) attributes.add("blocks");
      return "Cannot build SlashCommandResponseParams, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code responseType} attribute
   */
  @JsonProperty
  @Override
  public TopLevelMessageResponseType getResponseType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getResponseType()
        : this.responseType;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getThreadTs() {
    return Optional.ofNullable(threadTs);
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUsername() {
    return Optional.ofNullable(username);
  }

  /**
   * @return The value of the {@code asUser} attribute
   */
  @JsonProperty
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<Boolean> getAsUser() {
    return Optional.ofNullable(asUser);
  }

  /**
   * @return The value of the {@code iconEmoji} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getIconEmoji() {
    return Optional.ofNullable(iconEmoji);
  }

  /**
   * @return The value of the {@code iconUrl} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getIconUrl() {
    return Optional.ofNullable(iconUrl);
  }

  /**
   * @return The value of the {@code linkNames} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getLinkNames() {
    return Optional.ofNullable(linkNames);
  }

  /**
   * @return The value of the {@code unfurlLinks} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getUnfurlLinks() {
    return Optional.ofNullable(unfurlLinks);
  }

  /**
   * @return The value of the {@code unfurlMedia} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getUnfurlMedia() {
    return Optional.ofNullable(unfurlMedia);
  }

  /**
   * @return The value of the {@code replyBroadcast} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getReplyBroadcast() {
    return Optional.ofNullable(replyBroadcast);
  }

  /**
   * @return The value of the {@code attachments} attribute
   */
  @JsonProperty
  @Override
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBlocks()
        : this.blocks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlashCommandResponseParams#getResponseType() responseType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param responseType A new value for responseType
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandResponseParams withResponseType(TopLevelMessageResponseType responseType) {
    if (this.responseType == responseType) return this;
    TopLevelMessageResponseType newValue = Objects.requireNonNull(responseType, "responseType");
    return validate(new SlashCommandResponseParams(
        newValue,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlashCommandResponseParams#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlashCommandResponseParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return validate(new SlashCommandResponseParams(
        this.responseType,
        newValue,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        newValue,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        value,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getThreadTs() threadTs} attribute.
   * @param value The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withThreadTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.threadTs, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        newValue,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getThreadTs() threadTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for threadTs
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withThreadTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.threadTs, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        value,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getUsername() username} attribute.
   * @param value The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withUsername(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.username, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        newValue,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getUsername() username} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for username
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withUsername(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.username, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        value,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getAsUser() asUser} attribute.
   * @param value The value for asUser, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withAsUser(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.asUser, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        newValue,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getAsUser() asUser} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for asUser
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withAsUser(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.asUser, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        value,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getIconEmoji() iconEmoji} attribute.
   * @param value The value for iconEmoji, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withIconEmoji(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.iconEmoji, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        newValue,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getIconEmoji() iconEmoji} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for iconEmoji
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withIconEmoji(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.iconEmoji, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        value,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getIconUrl() iconUrl} attribute.
   * @param value The value for iconUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withIconUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.iconUrl, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        newValue,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getIconUrl() iconUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for iconUrl
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withIconUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.iconUrl, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        value,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getLinkNames() linkNames} attribute.
   * @param value The value for linkNames, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withLinkNames(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.linkNames, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        newValue,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getLinkNames() linkNames} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for linkNames
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withLinkNames(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.linkNames, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        value,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getUnfurlLinks() unfurlLinks} attribute.
   * @param value The value for unfurlLinks, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withUnfurlLinks(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.unfurlLinks, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        newValue,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getUnfurlLinks() unfurlLinks} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for unfurlLinks
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withUnfurlLinks(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.unfurlLinks, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        value,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getUnfurlMedia() unfurlMedia} attribute.
   * @param value The value for unfurlMedia, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withUnfurlMedia(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.unfurlMedia, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        newValue,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getUnfurlMedia() unfurlMedia} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for unfurlMedia
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withUnfurlMedia(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.unfurlMedia, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        value,
        this.replyBroadcast,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlashCommandResponseParams#getReplyBroadcast() replyBroadcast} attribute.
   * @param value The value for replyBroadcast, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withReplyBroadcast(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.replyBroadcast, newValue)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        newValue,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlashCommandResponseParams#getReplyBroadcast() replyBroadcast} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replyBroadcast
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withReplyBroadcast(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.replyBroadcast, value)) return this;
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        value,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlashCommandResponseParams#getAttachments() attachments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withAttachments(Attachment... elements) {
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        newValue,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlashCommandResponseParams#getAttachments() attachments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attachments elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withAttachments(Iterable<? extends Attachment> elements) {
    if (this.attachments == elements) return this;
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        newValue,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlashCommandResponseParams#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlashCommandResponseParams#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlashCommandResponseParams withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlashCommandResponseParams(
        this.responseType,
        this.channelId,
        this.text,
        this.threadTs,
        this.username,
        this.asUser,
        this.iconEmoji,
        this.iconUrl,
        this.linkNames,
        this.unfurlLinks,
        this.unfurlMedia,
        this.replyBroadcast,
        this.attachments,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code SlashCommandResponseParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlashCommandResponseParams
        && equalTo((SlashCommandResponseParams) another);
  }

  private boolean equalTo(SlashCommandResponseParams another) {
    return responseType.equals(another.responseType)
        && channelId.equals(another.channelId)
        && Objects.equals(text, another.text)
        && Objects.equals(threadTs, another.threadTs)
        && Objects.equals(username, another.username)
        && Objects.equals(asUser, another.asUser)
        && Objects.equals(iconEmoji, another.iconEmoji)
        && Objects.equals(iconUrl, another.iconUrl)
        && Objects.equals(linkNames, another.linkNames)
        && Objects.equals(unfurlLinks, another.unfurlLinks)
        && Objects.equals(unfurlMedia, another.unfurlMedia)
        && Objects.equals(replyBroadcast, another.replyBroadcast)
        && attachments.equals(another.attachments)
        && blocks.equals(another.blocks);
  }

  /**
   * Computes a hash code from attributes: {@code responseType}, {@code channelId}, {@code text}, {@code threadTs}, {@code username}, {@code asUser}, {@code iconEmoji}, {@code iconUrl}, {@code linkNames}, {@code unfurlLinks}, {@code unfurlMedia}, {@code replyBroadcast}, {@code attachments}, {@code blocks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + responseType.hashCode();
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + Objects.hashCode(threadTs);
    h = h * 17 + Objects.hashCode(username);
    h = h * 17 + Objects.hashCode(asUser);
    h = h * 17 + Objects.hashCode(iconEmoji);
    h = h * 17 + Objects.hashCode(iconUrl);
    h = h * 17 + Objects.hashCode(linkNames);
    h = h * 17 + Objects.hashCode(unfurlLinks);
    h = h * 17 + Objects.hashCode(unfurlMedia);
    h = h * 17 + Objects.hashCode(replyBroadcast);
    h = h * 17 + attachments.hashCode();
    h = h * 17 + blocks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlashCommandResponseParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlashCommandResponseParams{");
    builder.append("responseType=").append(responseType);
    builder.append(", ");
    builder.append("channelId=").append(channelId);
    if (text != null) {
      builder.append(", ");
      builder.append("text=").append(text);
    }
    if (threadTs != null) {
      builder.append(", ");
      builder.append("threadTs=").append(threadTs);
    }
    if (username != null) {
      builder.append(", ");
      builder.append("username=").append(username);
    }
    if (asUser != null) {
      builder.append(", ");
      builder.append("asUser=").append(asUser);
    }
    if (iconEmoji != null) {
      builder.append(", ");
      builder.append("iconEmoji=").append(iconEmoji);
    }
    if (iconUrl != null) {
      builder.append(", ");
      builder.append("iconUrl=").append(iconUrl);
    }
    if (linkNames != null) {
      builder.append(", ");
      builder.append("linkNames=").append(linkNames);
    }
    if (unfurlLinks != null) {
      builder.append(", ");
      builder.append("unfurlLinks=").append(unfurlLinks);
    }
    if (unfurlMedia != null) {
      builder.append(", ");
      builder.append("unfurlMedia=").append(unfurlMedia);
    }
    if (replyBroadcast != null) {
      builder.append(", ");
      builder.append("replyBroadcast=").append(replyBroadcast);
    }
    builder.append(", ");
    builder.append("attachments=").append(attachments);
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractSlashCommandResponseParams {
    @Nullable TopLevelMessageResponseType responseType;
    @Nullable String channelId;
    Optional<String> text = Optional.empty();
    Optional<String> threadTs = Optional.empty();
    Optional<String> username = Optional.empty();
    Optional<Boolean> asUser = Optional.empty();
    Optional<String> iconEmoji = Optional.empty();
    Optional<String> iconUrl = Optional.empty();
    Optional<Boolean> linkNames = Optional.empty();
    Optional<Boolean> unfurlLinks = Optional.empty();
    Optional<Boolean> unfurlMedia = Optional.empty();
    Optional<Boolean> replyBroadcast = Optional.empty();
    List<Attachment> attachments = Collections.emptyList();
    List<Block> blocks = Collections.emptyList();
    boolean blocksIsSet;
    @JsonProperty
    public void setResponseType(TopLevelMessageResponseType responseType) {
      this.responseType = responseType;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs;
    }
    @JsonProperty
    public void setUsername(Optional<String> username) {
      this.username = username;
    }
    @JsonProperty
    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    public void setAsUser(Optional<Boolean> asUser) {
      this.asUser = asUser;
    }
    @JsonProperty
    public void setIconEmoji(Optional<String> iconEmoji) {
      this.iconEmoji = iconEmoji;
    }
    @JsonProperty
    public void setIconUrl(Optional<String> iconUrl) {
      this.iconUrl = iconUrl;
    }
    @JsonProperty
    public void setLinkNames(Optional<Boolean> linkNames) {
      this.linkNames = linkNames;
    }
    @JsonProperty
    public void setUnfurlLinks(Optional<Boolean> unfurlLinks) {
      this.unfurlLinks = unfurlLinks;
    }
    @JsonProperty
    public void setUnfurlMedia(Optional<Boolean> unfurlMedia) {
      this.unfurlMedia = unfurlMedia;
    }
    @JsonProperty
    public void setReplyBroadcast(Optional<Boolean> replyBroadcast) {
      this.replyBroadcast = replyBroadcast;
    }
    @JsonProperty
    public void setAttachments(List<Attachment> attachments) {
      this.attachments = attachments;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      this.blocksIsSet = true;
    }
    @Override
    public TopLevelMessageResponseType getResponseType() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThreadTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUsername() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getAsUser() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getIconEmoji() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getIconUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getLinkNames() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getUnfurlLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getUnfurlMedia() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getReplyBroadcast() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attachment> getAttachments() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlashCommandResponseParams fromJson(Json json) {
    SlashCommandResponseParams.Builder builder = SlashCommandResponseParams.builder();
    if (json.responseType != null) {
      builder.setResponseType(json.responseType);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    if (json.asUser != null) {
      builder.setAsUser(json.asUser);
    }
    if (json.iconEmoji != null) {
      builder.setIconEmoji(json.iconEmoji);
    }
    if (json.iconUrl != null) {
      builder.setIconUrl(json.iconUrl);
    }
    if (json.linkNames != null) {
      builder.setLinkNames(json.linkNames);
    }
    if (json.unfurlLinks != null) {
      builder.setUnfurlLinks(json.unfurlLinks);
    }
    if (json.unfurlMedia != null) {
      builder.setUnfurlMedia(json.unfurlMedia);
    }
    if (json.replyBroadcast != null) {
      builder.setReplyBroadcast(json.replyBroadcast);
    }
    if (json.attachments != null) {
      builder.addAllAttachments(json.attachments);
    }
    if (json.blocksIsSet) {
      builder.setBlocks(json.blocks);
    }
    return builder.build();
  }

  private static SlashCommandResponseParams validate(SlashCommandResponseParams instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlashCommandResponseParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlashCommandResponseParams instance
   */
  public static SlashCommandResponseParams copyOf(AbstractSlashCommandResponseParams instance) {
    if (instance instanceof SlashCommandResponseParams) {
      return (SlashCommandResponseParams) instance;
    }
    return SlashCommandResponseParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlashCommandResponseParams SlashCommandResponseParams}.
   * @return A new SlashCommandResponseParams builder
   */
  public static SlashCommandResponseParams.Builder builder() {
    return new SlashCommandResponseParams.Builder();
  }

  /**
   * Builds instances of type {@link SlashCommandResponseParams SlashCommandResponseParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long OPT_BIT_BLOCKS = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable TopLevelMessageResponseType responseType;
    private @Nullable String channelId;
    private @Nullable String text;
    private @Nullable String threadTs;
    private @Nullable String username;
    private @Nullable Boolean asUser;
    private @Nullable String iconEmoji;
    private @Nullable String iconUrl;
    private @Nullable Boolean linkNames;
    private @Nullable Boolean unfurlLinks;
    private @Nullable Boolean unfurlMedia;
    private @Nullable Boolean replyBroadcast;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Block> blocks = new ArrayList<Block>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.MessageParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.AbstractSlashCommandResponseParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlashCommandResponseParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.AbstractChatMessageParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChatMessageParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MessageParams) {
        MessageParams instance = (MessageParams) object;
        addAllBlocks(instance.getBlocks());
        addAllAttachments(instance.getAttachments());
        if ((bits & 0x1L) == 0) {
          Optional<String> textOptional = instance.getText();
          if (textOptional.isPresent()) {
            setText(textOptional);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlashCommandResponseParams) {
        AbstractSlashCommandResponseParams instance = (AbstractSlashCommandResponseParams) object;
        setResponseType(instance.getResponseType());
      }
      if (object instanceof AbstractChatMessageParams) {
        AbstractChatMessageParams instance = (AbstractChatMessageParams) object;
        Optional<Boolean> unfurlMediaOptional = instance.getUnfurlMedia();
        if (unfurlMediaOptional.isPresent()) {
          setUnfurlMedia(unfurlMediaOptional);
        }
        Optional<String> iconEmojiOptional = instance.getIconEmoji();
        if (iconEmojiOptional.isPresent()) {
          setIconEmoji(iconEmojiOptional);
        }
        Optional<Boolean> unfurlLinksOptional = instance.getUnfurlLinks();
        if (unfurlLinksOptional.isPresent()) {
          setUnfurlLinks(unfurlLinksOptional);
        }
        Optional<Boolean> replyBroadcastOptional = instance.getReplyBroadcast();
        if (replyBroadcastOptional.isPresent()) {
          setReplyBroadcast(replyBroadcastOptional);
        }
        Optional<Boolean> linkNamesOptional = instance.getLinkNames();
        if (linkNamesOptional.isPresent()) {
          setLinkNames(linkNamesOptional);
        }
        if ((bits & 0x1L) == 0) {
          Optional<String> textOptional = instance.getText();
          if (textOptional.isPresent()) {
            setText(textOptional);
          }
          bits |= 0x1L;
        }
        Optional<String> iconUrlOptional = instance.getIconUrl();
        if (iconUrlOptional.isPresent()) {
          setIconUrl(iconUrlOptional);
        }
        Optional<String> threadTsOptional = instance.getThreadTs();
        if (threadTsOptional.isPresent()) {
          setThreadTs(threadTsOptional);
        }
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
        Optional<Boolean> asUserOptional = instance.getAsUser();
        if (asUserOptional.isPresent()) {
          setAsUser(asUserOptional);
        }
        Optional<String> usernameOptional = instance.getUsername();
        if (usernameOptional.isPresent()) {
          setUsername(usernameOptional);
        }
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlashCommandResponseParams#getResponseType() responseType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlashCommandResponseParams#getResponseType() responseType}.</em>
     * @param responseType The value for responseType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseType(TopLevelMessageResponseType responseType) {
      this.responseType = Objects.requireNonNull(responseType, "responseType");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlashCommandResponseParams#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThreadTs(@Nullable String threadTs) {
      this.threadTs = threadTs;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getUsername() username} to username.
     * @param username The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUsername(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getAsUser() asUser} to asUser.
     * @param asUser The value for asUser, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAsUser(@Nullable Boolean asUser) {
      this.asUser = asUser;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getAsUser() asUser} to asUser.
     * @param asUser The value for asUser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAsUser(Optional<Boolean> asUser) {
      this.asUser = asUser.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getIconEmoji() iconEmoji} to iconEmoji.
     * @param iconEmoji The value for iconEmoji, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIconEmoji(@Nullable String iconEmoji) {
      this.iconEmoji = iconEmoji;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getIconEmoji() iconEmoji} to iconEmoji.
     * @param iconEmoji The value for iconEmoji
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIconEmoji(Optional<String> iconEmoji) {
      this.iconEmoji = iconEmoji.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getIconUrl() iconUrl} to iconUrl.
     * @param iconUrl The value for iconUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIconUrl(@Nullable String iconUrl) {
      this.iconUrl = iconUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getIconUrl() iconUrl} to iconUrl.
     * @param iconUrl The value for iconUrl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIconUrl(Optional<String> iconUrl) {
      this.iconUrl = iconUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getLinkNames() linkNames} to linkNames.
     * @param linkNames The value for linkNames, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLinkNames(@Nullable Boolean linkNames) {
      this.linkNames = linkNames;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getLinkNames() linkNames} to linkNames.
     * @param linkNames The value for linkNames
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLinkNames(Optional<Boolean> linkNames) {
      this.linkNames = linkNames.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getUnfurlLinks() unfurlLinks} to unfurlLinks.
     * @param unfurlLinks The value for unfurlLinks, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUnfurlLinks(@Nullable Boolean unfurlLinks) {
      this.unfurlLinks = unfurlLinks;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getUnfurlLinks() unfurlLinks} to unfurlLinks.
     * @param unfurlLinks The value for unfurlLinks
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUnfurlLinks(Optional<Boolean> unfurlLinks) {
      this.unfurlLinks = unfurlLinks.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getUnfurlMedia() unfurlMedia} to unfurlMedia.
     * @param unfurlMedia The value for unfurlMedia, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUnfurlMedia(@Nullable Boolean unfurlMedia) {
      this.unfurlMedia = unfurlMedia;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getUnfurlMedia() unfurlMedia} to unfurlMedia.
     * @param unfurlMedia The value for unfurlMedia
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUnfurlMedia(Optional<Boolean> unfurlMedia) {
      this.unfurlMedia = unfurlMedia.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getReplyBroadcast() replyBroadcast} to replyBroadcast.
     * @param replyBroadcast The value for replyBroadcast, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setReplyBroadcast(@Nullable Boolean replyBroadcast) {
      this.replyBroadcast = replyBroadcast;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlashCommandResponseParams#getReplyBroadcast() replyBroadcast} to replyBroadcast.
     * @param replyBroadcast The value for replyBroadcast
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyBroadcast(Optional<Boolean> replyBroadcast) {
      this.replyBroadcast = replyBroadcast.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlashCommandResponseParams#getAttachments() attachments} list.
     * @param element A attachments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment element) {
      this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlashCommandResponseParams#getAttachments() attachments} list.
     * @param elements An array of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment... elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlashCommandResponseParams#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachments(Iterable<? extends Attachment> elements) {
      this.attachments.clear();
      return addAllAttachments(elements);
    }

    /**
     * Adds elements to {@link AbstractSlashCommandResponseParams#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlashCommandResponseParams#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlashCommandResponseParams#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlashCommandResponseParams#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link AbstractSlashCommandResponseParams#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Builds a new {@link SlashCommandResponseParams SlashCommandResponseParams}.
     * @return An immutable instance of SlashCommandResponseParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlashCommandResponseParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return SlashCommandResponseParams.validate(new SlashCommandResponseParams(this));
    }

    private boolean blocksIsSet() {
      return (optBits & OPT_BIT_BLOCKS) != 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build SlashCommandResponseParams, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
