package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import java.util.Optional;
import org.immutables.value.Value.Check;
import org.immutables.value.Value.Default;
import org.immutables.value.Value.Immutable;

@Immutable
@HubSpotStyle
@JsonNaming(SnakeCaseStrategy.class)
@JsonInclude(Include.NON_EMPTY)
public interface ChatUpdateMessageParamsIF extends MessageParams {
  @JsonProperty("channel")
  String getChannelId();

  Optional<String> getText();

  String getTs();

  @JsonProperty("as_user")
  Optional<Boolean> getAsUser();

  @Default
  @JsonProperty("link_names")
  default boolean shouldLinkNames() {
    return true;
  }

  @Default
  default String getParse() {
    return "none";
  }

  @Check
  default void check() {
    Preconditions.checkState(
      (getText().isPresent() && !Strings.isNullOrEmpty(getText().get())) ||
      !getAttachments().isEmpty() ||
      !getBlocks().isEmpty(),
      "Must include text if not providing attachments or blocks"
    );
  }
}
