package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.BlockOrAttachment;
import com.hubspot.slack.client.models.json.BlockOrAttachmentDeserializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatUnfurlParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatUnfurlParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatUnfurlParamsIF"})
@Immutable
public final class ChatUnfurlParams implements ChatUnfurlParamsIF {
  private final String channelId;
  private final String ts;
  private final Map<String, BlockOrAttachment> unfurls;
  private final @Nullable Boolean userAuthRequired;
  private final @Nullable String userAuthMessage;
  private final @Nullable URI userAuthUrl;

  private ChatUnfurlParams(
      String channelId,
      String ts,
      Map<String, BlockOrAttachment> unfurls,
      @Nullable Boolean userAuthRequired,
      @Nullable String userAuthMessage,
      @Nullable URI userAuthUrl) {
    this.channelId = channelId;
    this.ts = ts;
    this.unfurls = unfurls;
    this.userAuthRequired = userAuthRequired;
    this.userAuthMessage = userAuthMessage;
    this.userAuthUrl = userAuthUrl;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * @return The value of the {@code unfurls} attribute
   */
  @JsonProperty
  @JsonDeserialize(contentUsing = BlockOrAttachmentDeserializer.class)
  @Override
  public Map<String, BlockOrAttachment> getUnfurls() {
    return unfurls;
  }

  /**
   * @return The value of the {@code userAuthRequired} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> isUserAuthRequired() {
    return Optional.ofNullable(userAuthRequired);
  }

  /**
   * @return The value of the {@code userAuthMessage} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUserAuthMessage() {
    return Optional.ofNullable(userAuthMessage);
  }

  /**
   * @return The value of the {@code userAuthUrl} attribute
   */
  @JsonProperty
  @Override
  public Optional<URI> getUserAuthUrl() {
    return Optional.ofNullable(userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUnfurlParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChatUnfurlParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ChatUnfurlParams(newValue, this.ts, this.unfurls, this.userAuthRequired, this.userAuthMessage, this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUnfurlParamsIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final ChatUnfurlParams withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new ChatUnfurlParams(
        this.channelId,
        newValue,
        this.unfurls,
        this.userAuthRequired,
        this.userAuthMessage,
        this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by replacing the {@link ChatUnfurlParamsIF#getUnfurls() unfurls} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param unfurls The entries to be added to the unfurls map
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUnfurls(Map<String, ? extends BlockOrAttachment> unfurls) {
    if (this.unfurls == unfurls) return this;
    Map<String, BlockOrAttachment> newValue = createUnmodifiableMap(true, false, unfurls);
    return new ChatUnfurlParams(
        this.channelId,
        this.ts,
        newValue,
        this.userAuthRequired,
        this.userAuthMessage,
        this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatUnfurlParamsIF#isUserAuthRequired() userAuthRequired} attribute.
   * @param value The value for userAuthRequired, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUserAuthRequired(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.userAuthRequired, newValue)) return this;
    return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, newValue, this.userAuthMessage, this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatUnfurlParamsIF#isUserAuthRequired() userAuthRequired} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for userAuthRequired
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUserAuthRequired(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.userAuthRequired, value)) return this;
    return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, value, this.userAuthMessage, this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatUnfurlParamsIF#getUserAuthMessage() userAuthMessage} attribute.
   * @param value The value for userAuthMessage, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUserAuthMessage(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.userAuthMessage, newValue)) return this;
    return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.userAuthRequired, newValue, this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatUnfurlParamsIF#getUserAuthMessage() userAuthMessage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for userAuthMessage
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUserAuthMessage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.userAuthMessage, value)) return this;
    return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.userAuthRequired, value, this.userAuthUrl);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatUnfurlParamsIF#getUserAuthUrl() userAuthUrl} attribute.
   * @param value The value for userAuthUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUserAuthUrl(@Nullable URI value) {
    @Nullable URI newValue = value;
    if (this.userAuthUrl == newValue) return this;
    return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.userAuthRequired, this.userAuthMessage, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatUnfurlParamsIF#getUserAuthUrl() userAuthUrl} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for userAuthUrl
   * @return A modified copy of {@code this} object
   */
  public final ChatUnfurlParams withUserAuthUrl(Optional<URI> optional) {
    @Nullable URI value = optional.orElse(null);
    if (this.userAuthUrl == value) return this;
    return new ChatUnfurlParams(this.channelId, this.ts, this.unfurls, this.userAuthRequired, this.userAuthMessage, value);
  }

  /**
   * This instance is equal to all instances of {@code ChatUnfurlParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatUnfurlParams
        && equalTo((ChatUnfurlParams) another);
  }

  private boolean equalTo(ChatUnfurlParams another) {
    return channelId.equals(another.channelId)
        && ts.equals(another.ts)
        && unfurls.equals(another.unfurls)
        && Objects.equals(userAuthRequired, another.userAuthRequired)
        && Objects.equals(userAuthMessage, another.userAuthMessage)
        && Objects.equals(userAuthUrl, another.userAuthUrl);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code ts}, {@code unfurls}, {@code userAuthRequired}, {@code userAuthMessage}, {@code userAuthUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + ts.hashCode();
    h = h * 17 + unfurls.hashCode();
    h = h * 17 + Objects.hashCode(userAuthRequired);
    h = h * 17 + Objects.hashCode(userAuthMessage);
    h = h * 17 + Objects.hashCode(userAuthUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code ChatUnfurlParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatUnfurlParams{");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("ts=").append(ts);
    builder.append(", ");
    builder.append("unfurls=").append(unfurls);
    if (userAuthRequired != null) {
      builder.append(", ");
      builder.append("userAuthRequired=").append(userAuthRequired);
    }
    if (userAuthMessage != null) {
      builder.append(", ");
      builder.append("userAuthMessage=").append(userAuthMessage);
    }
    if (userAuthUrl != null) {
      builder.append(", ");
      builder.append("userAuthUrl=").append(userAuthUrl);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatUnfurlParamsIF {
    @Nullable String channelId;
    @Nullable String ts;
    @Nullable Map<String, BlockOrAttachment> unfurls;
    Optional<Boolean> userAuthRequired = Optional.empty();
    Optional<String> userAuthMessage = Optional.empty();
    Optional<URI> userAuthUrl = Optional.empty();
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @JsonProperty
    @JsonDeserialize(contentUsing = BlockOrAttachmentDeserializer.class)
    public void setUnfurls(Map<String, BlockOrAttachment> unfurls) {
      this.unfurls = unfurls;
    }
    @JsonProperty
    public void setUserAuthRequired(Optional<Boolean> userAuthRequired) {
      this.userAuthRequired = userAuthRequired;
    }
    @JsonProperty
    public void setUserAuthMessage(Optional<String> userAuthMessage) {
      this.userAuthMessage = userAuthMessage;
    }
    @JsonProperty
    public void setUserAuthUrl(Optional<URI> userAuthUrl) {
      this.userAuthUrl = userAuthUrl;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, BlockOrAttachment> getUnfurls() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isUserAuthRequired() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUserAuthMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<URI> getUserAuthUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatUnfurlParams fromJson(Json json) {
    ChatUnfurlParams.Builder builder = ChatUnfurlParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    if (json.unfurls != null) {
      builder.putAllUnfurls(json.unfurls);
    }
    if (json.userAuthRequired != null) {
      builder.setUserAuthRequired(json.userAuthRequired);
    }
    if (json.userAuthMessage != null) {
      builder.setUserAuthMessage(json.userAuthMessage);
    }
    if (json.userAuthUrl != null) {
      builder.setUserAuthUrl(json.userAuthUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChatUnfurlParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatUnfurlParams instance
   */
  public static ChatUnfurlParams copyOf(ChatUnfurlParamsIF instance) {
    if (instance instanceof ChatUnfurlParams) {
      return (ChatUnfurlParams) instance;
    }
    return ChatUnfurlParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatUnfurlParams ChatUnfurlParams}.
   * @return A new ChatUnfurlParams builder
   */
  public static ChatUnfurlParams.Builder builder() {
    return new ChatUnfurlParams.Builder();
  }

  /**
   * Builds instances of type {@link ChatUnfurlParams ChatUnfurlParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String channelId;
    private @Nullable String ts;
    private Map<String, BlockOrAttachment> unfurls = new LinkedHashMap<String, BlockOrAttachment>();
    private @Nullable Boolean userAuthRequired;
    private @Nullable String userAuthMessage;
    private @Nullable URI userAuthUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.ChatUnfurlParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatUnfurlParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ChatUnfurlParamsIF) {
        ChatUnfurlParamsIF instance = (ChatUnfurlParamsIF) object;
        putAllUnfurls(instance.getUnfurls());
        Optional<URI> userAuthUrlOptional = instance.getUserAuthUrl();
        if (userAuthUrlOptional.isPresent()) {
          setUserAuthUrl(userAuthUrlOptional);
        }
        Optional<String> userAuthMessageOptional = instance.getUserAuthMessage();
        if (userAuthMessageOptional.isPresent()) {
          setUserAuthMessage(userAuthMessageOptional);
        }
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
        Optional<Boolean> userAuthRequiredOptional = instance.isUserAuthRequired();
        if (userAuthRequiredOptional.isPresent()) {
          setUserAuthRequired(userAuthRequiredOptional);
        }
        setTs(instance.getTs());
      }
    }

    /**
     * Initializes the value for the {@link ChatUnfurlParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUnfurlParamsIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Put one entry to the {@link ChatUnfurlParamsIF#getUnfurls() unfurls} map.
     * @param key The key in the unfurls map
     * @param value The associated value in the unfurls map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUnfurls(String key, BlockOrAttachment value) {
      this.unfurls.put(
          Objects.requireNonNull(key, "unfurls key"),
          Objects.requireNonNull(value, "unfurls value"));
      return this;
    }

    /**
     * Put one entry to the {@link ChatUnfurlParamsIF#getUnfurls() unfurls} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUnfurls(Map.Entry<String, ? extends BlockOrAttachment> entry) {
      String k = entry.getKey();
      BlockOrAttachment v = entry.getValue();
      this.unfurls.put(
          Objects.requireNonNull(k, "unfurls key"),
          Objects.requireNonNull(v, "unfurls value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ChatUnfurlParamsIF#getUnfurls() unfurls} map. Nulls are not permitted
     * @param unfurls The entries that will be added to the unfurls map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUnfurls(Map<String, ? extends BlockOrAttachment> unfurls) {
      this.unfurls.clear();
      return putAllUnfurls(unfurls);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ChatUnfurlParamsIF#getUnfurls() unfurls} map. Nulls are not permitted
     * @param unfurls The entries that will be added to the unfurls map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUnfurls(Map<String, ? extends BlockOrAttachment> unfurls) {
      for (Map.Entry<String, ? extends BlockOrAttachment> entry : unfurls.entrySet()) {
        String k = entry.getKey();
        BlockOrAttachment v = entry.getValue();
        this.unfurls.put(
            Objects.requireNonNull(k, "unfurls key"),
            Objects.requireNonNull(v, "unfurls value"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUnfurlParamsIF#isUserAuthRequired() userAuthRequired} to userAuthRequired.
     * @param userAuthRequired The value for userAuthRequired, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUserAuthRequired(@Nullable Boolean userAuthRequired) {
      this.userAuthRequired = userAuthRequired;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUnfurlParamsIF#isUserAuthRequired() userAuthRequired} to userAuthRequired.
     * @param userAuthRequired The value for userAuthRequired
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserAuthRequired(Optional<Boolean> userAuthRequired) {
      this.userAuthRequired = userAuthRequired.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUnfurlParamsIF#getUserAuthMessage() userAuthMessage} to userAuthMessage.
     * @param userAuthMessage The value for userAuthMessage, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUserAuthMessage(@Nullable String userAuthMessage) {
      this.userAuthMessage = userAuthMessage;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUnfurlParamsIF#getUserAuthMessage() userAuthMessage} to userAuthMessage.
     * @param userAuthMessage The value for userAuthMessage
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserAuthMessage(Optional<String> userAuthMessage) {
      this.userAuthMessage = userAuthMessage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUnfurlParamsIF#getUserAuthUrl() userAuthUrl} to userAuthUrl.
     * @param userAuthUrl The value for userAuthUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUserAuthUrl(@Nullable URI userAuthUrl) {
      this.userAuthUrl = userAuthUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUnfurlParamsIF#getUserAuthUrl() userAuthUrl} to userAuthUrl.
     * @param userAuthUrl The value for userAuthUrl
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserAuthUrl(Optional<URI> userAuthUrl) {
      this.userAuthUrl = userAuthUrl.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChatUnfurlParams ChatUnfurlParams}.
     * @return An immutable instance of ChatUnfurlParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatUnfurlParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatUnfurlParams(
          channelId,
          ts,
          createUnmodifiableMap(false, false, unfurls),
          userAuthRequired,
          userAuthMessage,
          userAuthUrl);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build ChatUnfurlParams, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
