package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatPostEphemeralMessageParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatPostEphemeralMessageParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatPostEphemeralMessageParamsIF"})
@Immutable
public final class ChatPostEphemeralMessageParams
    implements ChatPostEphemeralMessageParamsIF {
  private final String channelId;
  private final String userToSendTo;
  private final @Nullable Boolean sendAsUser;
  private final @Nullable String threadTs;
  private final boolean shouldLinkNames;
  private final String parseMode;
  private final @Nullable String text;
  private final List<Attachment> attachments;
  private final List<Block> blocks;

  private ChatPostEphemeralMessageParams(ChatPostEphemeralMessageParams.Builder builder) {
    this.channelId = builder.channelId;
    this.userToSendTo = builder.userToSendTo;
    this.sendAsUser = builder.sendAsUser;
    this.threadTs = builder.threadTs;
    this.text = builder.text;
    this.attachments = createUnmodifiableList(true, builder.attachments);
    if (builder.shouldLinkNamesIsSet()) {
      initShim.setShouldLinkNames(builder.shouldLinkNames);
    }
    if (builder.parseMode != null) {
      initShim.setParseMode(builder.parseMode);
    }
    if (builder.blocksIsSet()) {
      initShim.setBlocks(createUnmodifiableList(true, builder.blocks));
    }
    this.shouldLinkNames = initShim.getShouldLinkNames();
    this.parseMode = initShim.getParseMode();
    this.blocks = initShim.getBlocks();
    this.initShim = null;
  }

  private ChatPostEphemeralMessageParams(
      String channelId,
      String userToSendTo,
      @Nullable Boolean sendAsUser,
      @Nullable String threadTs,
      boolean shouldLinkNames,
      String parseMode,
      @Nullable String text,
      List<Attachment> attachments,
      List<Block> blocks) {
    this.channelId = channelId;
    this.userToSendTo = userToSendTo;
    this.sendAsUser = sendAsUser;
    this.threadTs = threadTs;
    this.shouldLinkNames = shouldLinkNames;
    this.parseMode = parseMode;
    this.text = text;
    this.attachments = attachments;
    this.blocks = blocks;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private boolean shouldLinkNames;
    private int shouldLinkNamesStage;

    boolean getShouldLinkNames() {
      if (shouldLinkNamesStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (shouldLinkNamesStage == STAGE_UNINITIALIZED) {
        shouldLinkNamesStage = STAGE_INITIALIZING;
        this.shouldLinkNames = getShouldLinkNamesInitialize();
        shouldLinkNamesStage = STAGE_INITIALIZED;
      }
      return this.shouldLinkNames;
    }

    void setShouldLinkNames(boolean shouldLinkNames) {
      this.shouldLinkNames = shouldLinkNames;
      shouldLinkNamesStage = STAGE_INITIALIZED;
    }
    private String parseMode;
    private int parseModeStage;

    String getParseMode() {
      if (parseModeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (parseModeStage == STAGE_UNINITIALIZED) {
        parseModeStage = STAGE_INITIALIZING;
        this.parseMode = Objects.requireNonNull(getParseModeInitialize(), "parseMode");
        parseModeStage = STAGE_INITIALIZED;
      }
      return this.parseMode;
    }

    void setParseMode(String parseMode) {
      this.parseMode = parseMode;
      parseModeStage = STAGE_INITIALIZED;
    }
    private List<Block> blocks;
    private int blocksStage;

    List<Block> getBlocks() {
      if (blocksStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (blocksStage == STAGE_UNINITIALIZED) {
        blocksStage = STAGE_INITIALIZING;
        this.blocks = createUnmodifiableList(false, createSafeList(getBlocksInitialize(), true, false));
        blocksStage = STAGE_INITIALIZED;
      }
      return this.blocks;
    }

    void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      blocksStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (shouldLinkNamesStage == STAGE_INITIALIZING) attributes.add("shouldLinkNames");
      if (parseModeStage == STAGE_INITIALIZING) attributes.add("parseMode");
      if (blocksStage == STAGE_INITIALIZING) attributes.add("blocks");
      return "Cannot build ChatPostEphemeralMessageParams, attribute initializers form cycle" + attributes;
    }
  }

  private boolean getShouldLinkNamesInitialize() {
    return ChatPostEphemeralMessageParamsIF.super.getShouldLinkNames();
  }

  private String getParseModeInitialize() {
    return ChatPostEphemeralMessageParamsIF.super.getParseMode();
  }

  private List<Block> getBlocksInitialize() {
    return ChatPostEphemeralMessageParamsIF.super.getBlocks();
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code userToSendTo} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserToSendTo() {
    return userToSendTo;
  }

  /**
   * @return The value of the {@code sendAsUser} attribute
   */
  @JsonProperty("as_user")
  @Override
  public Optional<Boolean> getSendAsUser() {
    return Optional.ofNullable(sendAsUser);
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty("thread_ts")
  @Override
  public Optional<String> getThreadTs() {
    return Optional.ofNullable(threadTs);
  }

  /**
   * @return The value of the {@code shouldLinkNames} attribute
   */
  @JsonProperty("link_names")
  @Override
  public boolean getShouldLinkNames() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getShouldLinkNames()
        : this.shouldLinkNames;
  }

  /**
   * @return The value of the {@code parseMode} attribute
   */
  @JsonProperty("parse")
  @Override
  public String getParseMode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getParseMode()
        : this.parseMode;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code attachments} attribute
   */
  @JsonProperty
  @Override
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBlocks()
        : this.blocks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostEphemeralMessageParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostEphemeralMessageParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return validate(new ChatPostEphemeralMessageParams(
        newValue,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostEphemeralMessageParamsIF#getUserToSendTo() userToSendTo} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userToSendTo A new value for userToSendTo
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostEphemeralMessageParams withUserToSendTo(String userToSendTo) {
    if (this.userToSendTo.equals(userToSendTo)) return this;
    String newValue = Objects.requireNonNull(userToSendTo, "userToSendTo");
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        newValue,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatPostEphemeralMessageParamsIF#getSendAsUser() sendAsUser} attribute.
   * @param value The value for sendAsUser, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withSendAsUser(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.sendAsUser, newValue)) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        newValue,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatPostEphemeralMessageParamsIF#getSendAsUser() sendAsUser} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sendAsUser
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withSendAsUser(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.sendAsUser, value)) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        value,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatPostEphemeralMessageParamsIF#getThreadTs() threadTs} attribute.
   * @param value The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withThreadTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.threadTs, newValue)) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        newValue,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatPostEphemeralMessageParamsIF#getThreadTs() threadTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for threadTs
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withThreadTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.threadTs, value)) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        value,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostEphemeralMessageParamsIF#getShouldLinkNames() shouldLinkNames} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param shouldLinkNames A new value for shouldLinkNames
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostEphemeralMessageParams withShouldLinkNames(boolean shouldLinkNames) {
    if (this.shouldLinkNames == shouldLinkNames) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostEphemeralMessageParamsIF#getParseMode() parseMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param parseMode A new value for parseMode
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostEphemeralMessageParams withParseMode(String parseMode) {
    if (this.parseMode.equals(parseMode)) return this;
    String newValue = Objects.requireNonNull(parseMode, "parseMode");
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        newValue,
        this.text,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatPostEphemeralMessageParamsIF#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        newValue,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatPostEphemeralMessageParamsIF#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        value,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatPostEphemeralMessageParamsIF#getAttachments() attachments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withAttachments(Attachment... elements) {
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        newValue,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatPostEphemeralMessageParamsIF#getAttachments() attachments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attachments elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withAttachments(Iterable<? extends Attachment> elements) {
    if (this.attachments == elements) return this;
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        newValue,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatPostEphemeralMessageParamsIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatPostEphemeralMessageParamsIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatPostEphemeralMessageParams withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ChatPostEphemeralMessageParams(
        this.channelId,
        this.userToSendTo,
        this.sendAsUser,
        this.threadTs,
        this.shouldLinkNames,
        this.parseMode,
        this.text,
        this.attachments,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ChatPostEphemeralMessageParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatPostEphemeralMessageParams
        && equalTo((ChatPostEphemeralMessageParams) another);
  }

  private boolean equalTo(ChatPostEphemeralMessageParams another) {
    return channelId.equals(another.channelId)
        && userToSendTo.equals(another.userToSendTo)
        && Objects.equals(sendAsUser, another.sendAsUser)
        && Objects.equals(threadTs, another.threadTs)
        && shouldLinkNames == another.shouldLinkNames
        && parseMode.equals(another.parseMode)
        && Objects.equals(text, another.text)
        && attachments.equals(another.attachments)
        && blocks.equals(another.blocks);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code userToSendTo}, {@code sendAsUser}, {@code threadTs}, {@code shouldLinkNames}, {@code parseMode}, {@code text}, {@code attachments}, {@code blocks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + userToSendTo.hashCode();
    h = h * 17 + Objects.hashCode(sendAsUser);
    h = h * 17 + Objects.hashCode(threadTs);
    h = h * 17 + Boolean.hashCode(shouldLinkNames);
    h = h * 17 + parseMode.hashCode();
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + attachments.hashCode();
    h = h * 17 + blocks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChatPostEphemeralMessageParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatPostEphemeralMessageParams{");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("userToSendTo=").append(userToSendTo);
    if (sendAsUser != null) {
      builder.append(", ");
      builder.append("sendAsUser=").append(sendAsUser);
    }
    if (threadTs != null) {
      builder.append(", ");
      builder.append("threadTs=").append(threadTs);
    }
    builder.append(", ");
    builder.append("shouldLinkNames=").append(shouldLinkNames);
    builder.append(", ");
    builder.append("parseMode=").append(parseMode);
    if (text != null) {
      builder.append(", ");
      builder.append("text=").append(text);
    }
    builder.append(", ");
    builder.append("attachments=").append(attachments);
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ChatPostEphemeralMessageParamsIF {
    @Nullable String channelId;
    @Nullable String userToSendTo;
    Optional<Boolean> sendAsUser = Optional.empty();
    Optional<String> threadTs = Optional.empty();
    boolean shouldLinkNames;
    boolean shouldLinkNamesIsSet;
    @Nullable String parseMode;
    Optional<String> text = Optional.empty();
    List<Attachment> attachments = Collections.emptyList();
    List<Block> blocks = Collections.emptyList();
    boolean blocksIsSet;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("user")
    public void setUserToSendTo(String userToSendTo) {
      this.userToSendTo = userToSendTo;
    }
    @JsonProperty("as_user")
    public void setSendAsUser(Optional<Boolean> sendAsUser) {
      this.sendAsUser = sendAsUser;
    }
    @JsonProperty("thread_ts")
    public void setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs;
    }
    @JsonProperty("link_names")
    public void setShouldLinkNames(boolean shouldLinkNames) {
      this.shouldLinkNames = shouldLinkNames;
      this.shouldLinkNamesIsSet = true;
    }
    @JsonProperty("parse")
    public void setParseMode(String parseMode) {
      this.parseMode = parseMode;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setAttachments(List<Attachment> attachments) {
      this.attachments = attachments;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      this.blocksIsSet = true;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserToSendTo() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getSendAsUser() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThreadTs() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getShouldLinkNames() { throw new UnsupportedOperationException(); }
    @Override
    public String getParseMode() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attachment> getAttachments() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatPostEphemeralMessageParams fromJson(Json json) {
    ChatPostEphemeralMessageParams.Builder builder = ChatPostEphemeralMessageParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.userToSendTo != null) {
      builder.setUserToSendTo(json.userToSendTo);
    }
    if (json.sendAsUser != null) {
      builder.setSendAsUser(json.sendAsUser);
    }
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    if (json.shouldLinkNamesIsSet) {
      builder.setShouldLinkNames(json.shouldLinkNames);
    }
    if (json.parseMode != null) {
      builder.setParseMode(json.parseMode);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.attachments != null) {
      builder.addAllAttachments(json.attachments);
    }
    if (json.blocksIsSet) {
      builder.setBlocks(json.blocks);
    }
    return builder.build();
  }

  private static ChatPostEphemeralMessageParams validate(ChatPostEphemeralMessageParams instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ChatPostEphemeralMessageParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatPostEphemeralMessageParams instance
   */
  public static ChatPostEphemeralMessageParams copyOf(ChatPostEphemeralMessageParamsIF instance) {
    if (instance instanceof ChatPostEphemeralMessageParams) {
      return (ChatPostEphemeralMessageParams) instance;
    }
    return ChatPostEphemeralMessageParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatPostEphemeralMessageParams ChatPostEphemeralMessageParams}.
   * @return A new ChatPostEphemeralMessageParams builder
   */
  public static ChatPostEphemeralMessageParams.Builder builder() {
    return new ChatPostEphemeralMessageParams.Builder();
  }

  /**
   * Builds instances of type {@link ChatPostEphemeralMessageParams ChatPostEphemeralMessageParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_USER_TO_SEND_TO = 0x2L;
    private static final long OPT_BIT_SHOULD_LINK_NAMES = 0x1L;
    private static final long OPT_BIT_BLOCKS = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String channelId;
    private @Nullable String userToSendTo;
    private @Nullable Boolean sendAsUser;
    private @Nullable String threadTs;
    private boolean shouldLinkNames;
    private @Nullable String parseMode;
    private @Nullable String text;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Block> blocks = new ArrayList<Block>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.MessageParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.ChatPostEphemeralMessageParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatPostEphemeralMessageParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MessageParams) {
        MessageParams instance = (MessageParams) object;
        addAllBlocks(instance.getBlocks());
        addAllAttachments(instance.getAttachments());
        Optional<String> textOptional = instance.getText();
        if (textOptional.isPresent()) {
          setText(textOptional);
        }
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ChatPostEphemeralMessageParamsIF) {
        ChatPostEphemeralMessageParamsIF instance = (ChatPostEphemeralMessageParamsIF) object;
        Optional<Boolean> sendAsUserOptional = instance.getSendAsUser();
        if (sendAsUserOptional.isPresent()) {
          setSendAsUser(sendAsUserOptional);
        }
        setUserToSendTo(instance.getUserToSendTo());
        setShouldLinkNames(instance.getShouldLinkNames());
        Optional<String> threadTsOptional = instance.getThreadTs();
        if (threadTsOptional.isPresent()) {
          setThreadTs(threadTsOptional);
        }
        setParseMode(instance.getParseMode());
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ChatPostEphemeralMessageParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatPostEphemeralMessageParamsIF#getUserToSendTo() userToSendTo} attribute.
     * @param userToSendTo The value for userToSendTo 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserToSendTo(String userToSendTo) {
      this.userToSendTo = Objects.requireNonNull(userToSendTo, "userToSendTo");
      initBits &= ~INIT_BIT_USER_TO_SEND_TO;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostEphemeralMessageParamsIF#getSendAsUser() sendAsUser} to sendAsUser.
     * @param sendAsUser The value for sendAsUser, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSendAsUser(@Nullable Boolean sendAsUser) {
      this.sendAsUser = sendAsUser;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostEphemeralMessageParamsIF#getSendAsUser() sendAsUser} to sendAsUser.
     * @param sendAsUser The value for sendAsUser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSendAsUser(Optional<Boolean> sendAsUser) {
      this.sendAsUser = sendAsUser.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostEphemeralMessageParamsIF#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThreadTs(@Nullable String threadTs) {
      this.threadTs = threadTs;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostEphemeralMessageParamsIF#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ChatPostEphemeralMessageParamsIF#getShouldLinkNames() shouldLinkNames} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ChatPostEphemeralMessageParamsIF#getShouldLinkNames() shouldLinkNames}.</em>
     * @param shouldLinkNames The value for shouldLinkNames 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldLinkNames(boolean shouldLinkNames) {
      this.shouldLinkNames = shouldLinkNames;
      optBits |= OPT_BIT_SHOULD_LINK_NAMES;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatPostEphemeralMessageParamsIF#getParseMode() parseMode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ChatPostEphemeralMessageParamsIF#getParseMode() parseMode}.</em>
     * @param parseMode The value for parseMode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setParseMode(String parseMode) {
      this.parseMode = Objects.requireNonNull(parseMode, "parseMode");
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostEphemeralMessageParamsIF#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostEphemeralMessageParamsIF#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ChatPostEphemeralMessageParamsIF#getAttachments() attachments} list.
     * @param element A attachments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment element) {
      this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      return this;
    }

    /**
     * Adds elements to {@link ChatPostEphemeralMessageParamsIF#getAttachments() attachments} list.
     * @param elements An array of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment... elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ChatPostEphemeralMessageParamsIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachments(Iterable<? extends Attachment> elements) {
      this.attachments.clear();
      return addAllAttachments(elements);
    }

    /**
     * Adds elements to {@link ChatPostEphemeralMessageParamsIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ChatPostEphemeralMessageParamsIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Adds elements to {@link ChatPostEphemeralMessageParamsIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ChatPostEphemeralMessageParamsIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link ChatPostEphemeralMessageParamsIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Builds a new {@link ChatPostEphemeralMessageParams ChatPostEphemeralMessageParams}.
     * @return An immutable instance of ChatPostEphemeralMessageParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatPostEphemeralMessageParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return ChatPostEphemeralMessageParams.validate(new ChatPostEphemeralMessageParams(this));
    }

    private boolean shouldLinkNamesIsSet() {
      return (optBits & OPT_BIT_SHOULD_LINK_NAMES) != 0;
    }

    private boolean blocksIsSet() {
      return (optBits & OPT_BIT_BLOCKS) != 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean userToSendToIsSet() {
      return (initBits & INIT_BIT_USER_TO_SEND_TO) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!userToSendToIsSet()) attributes.add("userToSendTo");
      return "Cannot build ChatPostEphemeralMessageParams, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
