package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChannelsFilterIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelsFilter.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChannelsFilterIF"})
@Immutable
public final class ChannelsFilter implements ChannelsFilterIF {
  private final @Nullable Boolean shouldExcludeArchived;
  private final boolean shouldExcludeMembers;

  private ChannelsFilter(ChannelsFilter.Builder builder) {
    this.shouldExcludeArchived = builder.shouldExcludeArchived;
    this.shouldExcludeMembers = builder.shouldExcludeMembersIsSet()
        ? builder.shouldExcludeMembers
        : ChannelsFilterIF.super.shouldExcludeMembers();
  }

  private ChannelsFilter(@Nullable Boolean shouldExcludeArchived, boolean shouldExcludeMembers) {
    this.shouldExcludeArchived = shouldExcludeArchived;
    this.shouldExcludeMembers = shouldExcludeMembers;
  }

  /**
   * @return The value of the {@code shouldExcludeArchived} attribute
   */
  @JsonProperty("exclude_archived")
  @Override
  public Optional<Boolean> shouldExcludeArchived() {
    return Optional.ofNullable(shouldExcludeArchived);
  }

  /**
   * @return The value of the {@code shouldExcludeMembers} attribute
   */
  @JsonProperty("exclude_members")
  @Override
  public boolean shouldExcludeMembers() {
    return shouldExcludeMembers;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChannelsFilterIF#shouldExcludeArchived() shouldExcludeArchived} attribute.
   * @param value The value for shouldExcludeArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsFilter withShouldExcludeArchived(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.shouldExcludeArchived, newValue)) return this;
    return new ChannelsFilter(newValue, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChannelsFilterIF#shouldExcludeArchived() shouldExcludeArchived} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for shouldExcludeArchived
   * @return A modified copy of {@code this} object
   */
  public final ChannelsFilter withShouldExcludeArchived(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.shouldExcludeArchived, value)) return this;
    return new ChannelsFilter(value, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChannelsFilterIF#shouldExcludeMembers() shouldExcludeMembers} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param shouldExcludeMembers A new value for shouldExcludeMembers
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsFilter withShouldExcludeMembers(boolean shouldExcludeMembers) {
    if (this.shouldExcludeMembers == shouldExcludeMembers) return this;
    return new ChannelsFilter(this.shouldExcludeArchived, shouldExcludeMembers);
  }

  /**
   * This instance is equal to all instances of {@code ChannelsFilter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelsFilter
        && equalTo((ChannelsFilter) another);
  }

  private boolean equalTo(ChannelsFilter another) {
    return Objects.equals(shouldExcludeArchived, another.shouldExcludeArchived)
        && shouldExcludeMembers == another.shouldExcludeMembers;
  }

  /**
   * Computes a hash code from attributes: {@code shouldExcludeArchived}, {@code shouldExcludeMembers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(shouldExcludeArchived);
    h = h * 17 + Boolean.hashCode(shouldExcludeMembers);
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelsFilter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChannelsFilter{");
    if (shouldExcludeArchived != null) {
      builder.append("shouldExcludeArchived=").append(shouldExcludeArchived);
    }
    if (builder.length() > 15) builder.append(", ");
    builder.append("shouldExcludeMembers=").append(shouldExcludeMembers);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChannelsFilterIF {
    Optional<Boolean> shouldExcludeArchived = Optional.empty();
    boolean shouldExcludeMembers;
    boolean shouldExcludeMembersIsSet;
    @JsonProperty("exclude_archived")
    public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived;
    }
    @JsonProperty("exclude_members")
    public void setShouldExcludeMembers(boolean shouldExcludeMembers) {
      this.shouldExcludeMembers = shouldExcludeMembers;
      this.shouldExcludeMembersIsSet = true;
    }
    @Override
    public Optional<Boolean> shouldExcludeArchived() { throw new UnsupportedOperationException(); }
    @Override
    public boolean shouldExcludeMembers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelsFilter fromJson(Json json) {
    ChannelsFilter.Builder builder = ChannelsFilter.builder();
    if (json.shouldExcludeArchived != null) {
      builder.setShouldExcludeArchived(json.shouldExcludeArchived);
    }
    if (json.shouldExcludeMembersIsSet) {
      builder.setShouldExcludeMembers(json.shouldExcludeMembers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChannelsFilterIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelsFilter instance
   */
  public static ChannelsFilter copyOf(ChannelsFilterIF instance) {
    if (instance instanceof ChannelsFilter) {
      return (ChannelsFilter) instance;
    }
    return ChannelsFilter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelsFilter ChannelsFilter}.
   * @return A new ChannelsFilter builder
   */
  public static ChannelsFilter.Builder builder() {
    return new ChannelsFilter.Builder();
  }

  /**
   * Builds instances of type {@link ChannelsFilter ChannelsFilter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SHOULD_EXCLUDE_MEMBERS = 0x1L;
    private long optBits;

    private @Nullable Boolean shouldExcludeArchived;
    private boolean shouldExcludeMembers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.BaseChannelsFilter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseChannelsFilter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.ChannelsFilterIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChannelsFilterIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BaseChannelsFilter) {
        BaseChannelsFilter instance = (BaseChannelsFilter) object;
        Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
        if (shouldExcludeArchivedOptional.isPresent()) {
          setShouldExcludeArchived(shouldExcludeArchivedOptional);
        }
        setShouldExcludeMembers(instance.shouldExcludeMembers());
      }
    }

    /**
     * Initializes the optional value {@link ChannelsFilterIF#shouldExcludeArchived() shouldExcludeArchived} to shouldExcludeArchived.
     * @param shouldExcludeArchived The value for shouldExcludeArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelsFilterIF#shouldExcludeArchived() shouldExcludeArchived} to shouldExcludeArchived.
     * @param shouldExcludeArchived The value for shouldExcludeArchived
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ChannelsFilterIF#shouldExcludeMembers() shouldExcludeMembers} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ChannelsFilterIF#shouldExcludeMembers() shouldExcludeMembers}.</em>
     * @param shouldExcludeMembers The value for shouldExcludeMembers 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldExcludeMembers(boolean shouldExcludeMembers) {
      this.shouldExcludeMembers = shouldExcludeMembers;
      optBits |= OPT_BIT_SHOULD_EXCLUDE_MEMBERS;
      return this;
    }

    /**
     * Builds a new {@link ChannelsFilter ChannelsFilter}.
     * @return An immutable instance of ChannelsFilter
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelsFilter build() throws InvalidImmutableStateException {
      return new ChannelsFilter(this);
    }

    private boolean shouldExcludeMembersIsSet() {
      return (optBits & OPT_BIT_SHOULD_EXCLUDE_MEMBERS) != 0;
    }
  }
}
