package com.hubspot.slack.client.methods.params.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AuthRevokeParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AuthRevokeParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AuthRevokeParamsIF"})
@Immutable
public final class AuthRevokeParams implements AuthRevokeParamsIF {

  private AuthRevokeParams(AuthRevokeParams.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code AuthRevokeParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof AuthRevokeParams
        && equalTo((AuthRevokeParams) another);
  }

  private boolean equalTo(AuthRevokeParams another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 2075311851;
  }

  /**
   * Prints the immutable value {@code AuthRevokeParams}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AuthRevokeParams{}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AuthRevokeParamsIF {
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static AuthRevokeParams fromJson(Json json) {
    AuthRevokeParams.Builder builder = AuthRevokeParams.builder();
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AuthRevokeParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuthRevokeParams instance
   */
  public static AuthRevokeParams copyOf(AuthRevokeParamsIF instance) {
    if (instance instanceof AuthRevokeParams) {
      return (AuthRevokeParams) instance;
    }
    return AuthRevokeParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link AuthRevokeParams AuthRevokeParams}.
   * @return A new AuthRevokeParams builder
   */
  public static AuthRevokeParams.Builder builder() {
    return new AuthRevokeParams.Builder();
  }

  /**
   * Builds instances of type {@link AuthRevokeParams AuthRevokeParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AuthRevokeParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthRevokeParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link AuthRevokeParams AuthRevokeParams}.
     * @return An immutable instance of AuthRevokeParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public AuthRevokeParams build() throws InvalidImmutableStateException {
      return new AuthRevokeParams(this);
    }
  }
}
