/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.firebase;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.net.Uri;
import androidx.core.app.NotificationCompat;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.hubspot.mobilesdk.HubspotManager;
import com.hubspot.mobilesdk.HubspotWebActivity;
import com.hubspot.mobilesdk.R;
import com.hubspot.mobilesdk.firebase.PushNotificationChatData;
import java.io.Serializable;
import java.util.Map;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/hubspot/mobilesdk/firebase/HubspotFirebaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "<init>", "()V", "onNewToken", "", "token", "", "onMessageReceived", "message", "Lcom/google/firebase/messaging/RemoteMessage;", "sendPushNotificationData", "pushNotificationChatData", "Lcom/hubspot/mobilesdk/firebase/PushNotificationChatData;", "Companion", "hubspot_release"})
public class HubspotFirebaseMessagingService
extends FirebaseMessagingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PUSH_ACTION = "hubspot.push.action";
    @NotNull
    private static final String CHANNEL_NAME = "hubspot_channel_name";
    @NotNull
    public static final String HS_PUSH_DATA = "hsPushData";

    public void onNewToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        HubspotManager manager = HubspotManager.Companion.getInstance(context);
        manager.configure();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(manager, token, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HubspotManager $manager;
            final /* synthetic */ String $token;
            {
                this.$manager = $manager;
                this.$token = $token;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runBlocking;
                        ResultKt.throwOnFailure((Object)$result);
                        return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$manager, this.$token, null){
                            int label;
                            final /* synthetic */ HubspotManager $manager;
                            final /* synthetic */ String $token;
                            {
                                this.$manager = $manager;
                                this.$token = $token;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$manager.setPushToken(this.$token, (Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public void onMessageReceived(@NotNull RemoteMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super.onMessageReceived(message);
        Map map = message.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
        this.sendPushNotificationData(new PushNotificationChatData(map));
    }

    private final void sendPushNotificationData(PushNotificationChatData pushNotificationChatData) {
        Intent intent = new Intent(this.getApplicationContext(), HubspotWebActivity.class);
        intent.setAction(PUSH_ACTION);
        Intrinsics.checkNotNull((Object)pushNotificationChatData, (String)"null cannot be cast to non-null type java.io.Serializable");
        intent.putExtra(HS_PUSH_DATA, (Serializable)pushNotificationChatData);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x44000000);
        Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getApplicationContext(), this.getApplicationContext().getString(R.string.default_notification_channel_id)).setSmallIcon(R.drawable.ic_hubspot);
        String string2 = pushNotificationChatData.getTitle();
        if (string2 == null) {
            string2 = "";
        }
        NotificationCompat.Builder builder2 = builder.setContentTitle((CharSequence)string2);
        String string3 = pushNotificationChatData.getBody();
        if (string3 == null) {
            string3 = "";
        }
        NotificationCompat.Builder builder3 = builder2.setContentText((CharSequence)string3).setAutoCancel(true).setSound(defaultSoundUri).setContentIntent(pendingIntent);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"setContentIntent(...)");
        NotificationCompat.Builder notificationBuilder = builder3;
        Object object = this.getApplicationContext().getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        NotificationChannel channel = new NotificationChannel(this.getApplicationContext().getString(R.string.default_notification_channel_id), (CharSequence)CHANNEL_NAME, 4);
        notificationManager.createNotificationChannel(channel);
        notificationManager.notify(RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)new IntRange(1, 999999999)), notificationBuilder.build());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/hubspot/mobilesdk/firebase/HubspotFirebaseMessagingService$Companion;", "", "<init>", "()V", "PUSH_ACTION", "", "CHANNEL_NAME", "HS_PUSH_DATA", "hubspot_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

