/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mobilesdk.errorhandling;

import com.hubspot.mobilesdk.errorhandling.ErrorTransformer;
import com.hubspot.mobilesdk.errorhandling.NetworkError;
import com.hubspot.mobilesdk.extension.HttpExceptionKt;
import com.squareup.moshi.JsonDataException;
import java.io.FileNotFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.HttpException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/hubspot/mobilesdk/errorhandling/ApiErrorTransformer;", "Lcom/hubspot/mobilesdk/errorhandling/ErrorTransformer;", "<init>", "()V", "transform", "", "error", "handleHTTPException", "Lcom/hubspot/mobilesdk/errorhandling/NetworkError$Http;", "Lretrofit2/HttpException;", "hubspot_release"})
public final class ApiErrorTransformer
implements ErrorTransformer {
    @NotNull
    public static final ApiErrorTransformer INSTANCE = new ApiErrorTransformer();

    private ApiErrorTransformer() {
    }

    @Override
    @NotNull
    public Throwable transform(@NotNull Throwable error) {
        RuntimeException runtimeException;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return error instanceof RuntimeException ? (Throwable)((runtimeException = (RuntimeException)error) instanceof JsonDataException ? (NetworkError)new NetworkError.Data.Parsing(error.getMessage()) : (runtimeException instanceof IllegalArgumentException ? (NetworkError)new NetworkError.Data.IllegalArgument(error.getMessage()) : (runtimeException instanceof NullPointerException || runtimeException instanceof IndexOutOfBoundsException || runtimeException instanceof FileNotFoundException ? (NetworkError)new NetworkError.Data.Null(error.getMessage()) : (runtimeException instanceof HttpException ? (NetworkError)this.handleHTTPException((HttpException)error) : (NetworkError)NetworkError.Data.Generic.INSTANCE)))) : error;
    }

    private final NetworkError.Http handleHTTPException(HttpException error) {
        int n = error.code();
        return n == 401 ? (NetworkError.Http)new NetworkError.Http.Unauthorized(HttpExceptionKt.toApiError(error)) : (n == 400 || n == 403 || n == 405 || n == 406 || n == 422 ? (NetworkError.Http)new NetworkError.Http.BadRequest(HttpExceptionKt.toApiError(error)) : (n == 404 ? (NetworkError.Http)new NetworkError.Http.NotFound(HttpExceptionKt.toApiError(error)) : (n == 408 ? (NetworkError.Http)NetworkError.Http.Timeout.INSTANCE : (n == 409 ? (NetworkError.Http)new NetworkError.Http.Conflict(HttpExceptionKt.toApiError(error)) : (n == 429 ? (NetworkError.Http)NetworkError.Http.LimitRateSuppressed.INSTANCE : ((500 <= n ? n < 600 : false) ? (NetworkError.Http)NetworkError.Http.Internal.INSTANCE : (NetworkError.Http)NetworkError.Http.Generic.INSTANCE))))));
    }
}

