"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpressionsPrettierVisitor = void 0;
var forEach_1 = __importDefault(require("lodash/forEach"));
var doc_1 = require("prettier/doc");
var base_cst_printer_1 = require("../base-cst-printer");
var utils_1 = require("../types/utils");
var expressions_utils_1 = require("../utils/expressions-utils");
var utils_2 = require("../utils");
var format_comments_1 = require("./comments/format-comments");
var handle_comments_1 = require("./comments/handle-comments");
var prettier_builder_1 = require("./prettier-builder");
var printer_utils_1 = require("./printer-utils");
var ifBreak = doc_1.builders.ifBreak, line = doc_1.builders.line, softline = doc_1.builders.softline, indentIfBreak = doc_1.builders.indentIfBreak;
var ExpressionsPrettierVisitor = /** @class */ (function (_super) {
    __extends(ExpressionsPrettierVisitor, _super);
    function ExpressionsPrettierVisitor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExpressionsPrettierVisitor.prototype.expression = function (ctx, params) {
        return this.visitSingle(ctx, params);
    };
    ExpressionsPrettierVisitor.prototype.lambdaExpression = function (ctx, params) {
        var lambdaParameters = prettier_builder_1.group(this.visit(ctx.lambdaParameters, params), params ? { id: params.lambdaParametersGroupId } : undefined);
        var lambdaBody = this.visit(ctx.lambdaBody);
        var isLambdaBodyABlock = ctx.lambdaBody[0].children.block !== undefined;
        if (isLambdaBodyABlock) {
            return printer_utils_1.rejectAndJoin(" ", [
                lambdaParameters,
                ctx.Arrow[0],
                (params === null || params === void 0 ? void 0 : params.lambdaParametersGroupId) !== undefined
                    ? indentIfBreak(lambdaBody, {
                        groupId: params.lambdaParametersGroupId
                    })
                    : lambdaBody
            ]);
        }
        return prettier_builder_1.group(prettier_builder_1.indent(printer_utils_1.rejectAndJoin(line, [
            printer_utils_1.rejectAndJoin(" ", [lambdaParameters, ctx.Arrow[0]]),
            lambdaBody
        ])));
    };
    ExpressionsPrettierVisitor.prototype.lambdaParameters = function (ctx, params) {
        if (ctx.lambdaParametersWithBraces) {
            return this.visitSingle(ctx, params);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ExpressionsPrettierVisitor.prototype.lambdaParametersWithBraces = function (ctx, params) {
        var lambdaParameterList = this.visit(ctx.lambdaParameterList);
        if (printer_utils_1.findDeepElementInPartsArray(lambdaParameterList, ",")) {
            var content = printer_utils_1.putIntoBraces(lambdaParameterList, softline, ctx.LBrace[0], ctx.RBrace[0]);
            if ((params === null || params === void 0 ? void 0 : params.isInsideMethodInvocationSuffix) === true) {
                return prettier_builder_1.indent(prettier_builder_1.concat([softline, content]));
            }
            return content;
        }
        // removing braces when only no comments attached
        if ((ctx.LBrace &&
            ctx.RBrace &&
            (!lambdaParameterList || printer_utils_1.isExplicitLambdaParameter(ctx))) ||
            ctx.LBrace[0].leadingComments ||
            ctx.LBrace[0].trailingComments ||
            ctx.RBrace[0].leadingComments ||
            ctx.RBrace[0].trailingComments) {
            return printer_utils_1.rejectAndConcat([
                ctx.LBrace[0],
                lambdaParameterList,
                ctx.RBrace[0]
            ]);
        }
        return lambdaParameterList;
    };
    ExpressionsPrettierVisitor.prototype.lambdaParameterList = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.inferredLambdaParameterList = function (ctx) {
        var commas = ctx.Comma
            ? ctx.Comma.map(function (elt) {
                return prettier_builder_1.concat([elt, line]);
            })
            : [];
        return printer_utils_1.rejectAndJoinSeps(commas, ctx.Identifier);
    };
    ExpressionsPrettierVisitor.prototype.explicitLambdaParameterList = function (ctx) {
        var lambdaParameter = this.mapVisit(ctx.lambdaParameter);
        var commas = ctx.Comma
            ? ctx.Comma.map(function (elt) {
                return prettier_builder_1.concat([elt, line]);
            })
            : [];
        return printer_utils_1.rejectAndJoinSeps(commas, lambdaParameter);
    };
    ExpressionsPrettierVisitor.prototype.lambdaParameter = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.regularLambdaParameter = function (ctx) {
        var variableModifier = this.mapVisit(ctx.variableModifier);
        var lambdaParameterType = this.visit(ctx.lambdaParameterType);
        var variableDeclaratorId = this.visit(ctx.variableDeclaratorId);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndJoin(" ", variableModifier),
            lambdaParameterType,
            variableDeclaratorId
        ]);
    };
    ExpressionsPrettierVisitor.prototype.lambdaParameterType = function (ctx) {
        if (ctx.unannType) {
            return this.visitSingle(ctx);
        }
        return format_comments_1.printTokenWithComments(this.getSingle(ctx));
    };
    ExpressionsPrettierVisitor.prototype.lambdaBody = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.ternaryExpression = function (ctx, params) {
        var binaryExpression = this.visit(ctx.binaryExpression, params);
        if (ctx.QuestionMark) {
            var expression1 = this.visit(ctx.expression[0]);
            var expression2 = this.visit(ctx.expression[1]);
            return prettier_builder_1.indent(prettier_builder_1.group(printer_utils_1.rejectAndConcat([
                printer_utils_1.rejectAndJoin(line, [
                    binaryExpression,
                    printer_utils_1.rejectAndJoin(" ", [ctx.QuestionMark[0], expression1]),
                    printer_utils_1.rejectAndJoin(" ", [ctx.Colon[0], expression2])
                ])
            ])));
        }
        return binaryExpression;
    };
    ExpressionsPrettierVisitor.prototype.binaryExpression = function (ctx, params) {
        handle_comments_1.handleCommentsBinaryExpression(ctx);
        var instanceofReferences = this.mapVisit(printer_utils_1.sortNodes([ctx.pattern, ctx.referenceType]));
        var expression = this.mapVisit(ctx.expression);
        var unaryExpression = this.mapVisit(ctx.unaryExpression);
        var _a = printer_utils_1.separateTokensIntoGroups(ctx), groupsOfOperator = _a.groupsOfOperator, sortedBinaryOperators = _a.sortedBinaryOperators;
        var segmentsSplitByBinaryOperator = [];
        var currentSegment = [];
        if (groupsOfOperator.length === 1 && groupsOfOperator[0].length === 0) {
            return unaryExpression.shift();
        }
        groupsOfOperator.forEach(function (subgroup) {
            currentSegment = [unaryExpression.shift()];
            for (var i = 0; i < subgroup.length; i++) {
                var token = subgroup[i];
                var shiftOperator = printer_utils_1.isShiftOperator(subgroup, i);
                if (token.tokenType.name === "Instanceof") {
                    currentSegment.push(printer_utils_1.rejectAndJoin(" ", [
                        ctx.Instanceof[0],
                        instanceofReferences.shift()
                    ]));
                }
                else if (printer_utils_1.matchCategory(token, "'AssignmentOperator'")) {
                    currentSegment.push(prettier_builder_1.indent(printer_utils_1.rejectAndJoin(line, [token, expression.shift()])));
                }
                else if (shiftOperator === "leftShift" ||
                    shiftOperator === "rightShift") {
                    currentSegment.push(printer_utils_1.rejectAndJoin(" ", [
                        printer_utils_1.rejectAndConcat([token, subgroup[i + 1]]),
                        unaryExpression.shift()
                    ]));
                    i++;
                }
                else if (shiftOperator === "doubleRightShift") {
                    currentSegment.push(printer_utils_1.rejectAndJoin(" ", [
                        printer_utils_1.rejectAndConcat([token, subgroup[i + 1], subgroup[i + 2]]),
                        unaryExpression.shift()
                    ]));
                    i += 2;
                }
                else if (printer_utils_1.matchCategory(token, "'BinaryOperator'")) {
                    currentSegment.push(printer_utils_1.rejectAndJoin(line, [token, unaryExpression.shift()]));
                }
            }
            segmentsSplitByBinaryOperator.push(prettier_builder_1.group(printer_utils_1.rejectAndJoin(" ", currentSegment)));
        });
        if (params !== undefined && params.addParenthesisToWrapStatement) {
            return prettier_builder_1.group(prettier_builder_1.concat([
                ifBreak("(", ""),
                prettier_builder_1.indent(prettier_builder_1.concat([
                    softline,
                    prettier_builder_1.group(printer_utils_1.rejectAndJoinSeps(sortedBinaryOperators.map(function (elt) { return prettier_builder_1.concat([" ", elt, line]); }), segmentsSplitByBinaryOperator))
                ])),
                softline,
                ifBreak(")")
            ]));
        }
        return prettier_builder_1.group(printer_utils_1.rejectAndJoinSeps(sortedBinaryOperators.map(function (elt) { return prettier_builder_1.concat([" ", elt, line]); }), segmentsSplitByBinaryOperator));
    };
    ExpressionsPrettierVisitor.prototype.unaryExpression = function (ctx) {
        var unaryPrefixOperator = ctx.UnaryPrefixOperator
            ? ctx.UnaryPrefixOperator
            : [];
        var primary = this.visit(ctx.primary);
        var unarySuffixOperator = ctx.UnarySuffixOperator
            ? ctx.UnarySuffixOperator
            : [];
        return printer_utils_1.rejectAndConcat([
            printer_utils_1.rejectAndConcat(unaryPrefixOperator),
            primary,
            printer_utils_1.rejectAndConcat(unarySuffixOperator)
        ]);
    };
    ExpressionsPrettierVisitor.prototype.unaryExpressionNotPlusMinus = function (ctx) {
        var unaryPrefixOperatorNotPlusMinus = ctx.UnaryPrefixOperatorNotPlusMinus // changed when moved to TS
            ? printer_utils_1.rejectAndJoin(" ", ctx.UnaryPrefixOperatorNotPlusMinus) // changed when moved to TS
            : "";
        var primary = this.visit(ctx.primary);
        var unarySuffixOperator = ctx.UnarySuffixOperator // changed when moved to TS
            ? printer_utils_1.rejectAndJoin(" ", ctx.UnarySuffixOperator) // changed when moved to TS
            : "";
        return printer_utils_1.rejectAndJoin(" ", [
            unaryPrefixOperatorNotPlusMinus,
            primary,
            unarySuffixOperator
        ]);
    };
    ExpressionsPrettierVisitor.prototype.primary = function (ctx) {
        var countMethodInvocation = printer_utils_1.isUniqueMethodInvocation(ctx.primarySuffix);
        var primaryPrefix = this.visit(ctx.primaryPrefix, {
            shouldBreakBeforeFirstMethodInvocation: countMethodInvocation > 1
        });
        var suffixes = [];
        if (ctx.primarySuffix !== undefined) {
            // edge case: https://github.com/jhipster/prettier-java/issues/381
            var hasFirstInvocationArg = true;
            if (ctx.primarySuffix.length > 1 &&
                ctx.primarySuffix[1].children.methodInvocationSuffix &&
                Object.keys(ctx.primarySuffix[1].children.methodInvocationSuffix[0].children).length === 2) {
                hasFirstInvocationArg = false;
            }
            if (ctx.primarySuffix[0].children.Dot !== undefined &&
                ctx.primaryPrefix[0].children.newExpression !== undefined) {
                suffixes.push(softline);
            }
            suffixes.push(this.visit(ctx.primarySuffix[0], {
                shouldDedent: 
                // dedent when simple method invocation
                countMethodInvocation !== 1 &&
                    // dedent when (chain) method invocation
                    ctx.primaryPrefix[0] &&
                    ctx.primaryPrefix[0].children.fqnOrRefType &&
                    !(ctx.primaryPrefix[0].children.fqnOrRefType[0].children.Dot !==
                        undefined) &&
                    // indent when lambdaExpression
                    ctx.primarySuffix[0].children.methodInvocationSuffix &&
                    ctx.primarySuffix[0].children.methodInvocationSuffix[0].children
                        .argumentList &&
                    ctx.primarySuffix[0].children.methodInvocationSuffix[0].children
                        .argumentList[0].children.expression &&
                    ctx.primarySuffix[0].children.methodInvocationSuffix[0].children
                        .argumentList[0].children.expression[0].children
                        .lambdaExpression === undefined
            }));
            for (var i = 1; i < ctx.primarySuffix.length; i++) {
                if (ctx.primarySuffix[i].children.Dot !== undefined &&
                    ctx.primarySuffix[i - 1].children.methodInvocationSuffix !== undefined) {
                    suffixes.push(softline);
                }
                suffixes.push(this.visit(ctx.primarySuffix[i]));
            }
            if (countMethodInvocation === 1 &&
                ctx.primaryPrefix[0].children.newExpression === undefined) {
                return prettier_builder_1.group(printer_utils_1.rejectAndConcat([
                    primaryPrefix,
                    hasFirstInvocationArg ? suffixes[0] : prettier_builder_1.indent(suffixes[0]),
                    prettier_builder_1.indent(printer_utils_1.rejectAndConcat(suffixes.slice(1)))
                ]));
            }
        }
        return prettier_builder_1.group(printer_utils_1.rejectAndConcat([primaryPrefix, prettier_builder_1.indent(printer_utils_1.rejectAndConcat(suffixes))]));
    };
    ExpressionsPrettierVisitor.prototype.primaryPrefix = function (ctx, params) {
        if (ctx.This || ctx.Void) {
            return format_comments_1.printTokenWithComments(this.getSingle(ctx));
        }
        return this.visitSingle(ctx, params);
    };
    ExpressionsPrettierVisitor.prototype.primarySuffix = function (ctx, params) {
        if (ctx.Dot) {
            if (ctx.This) {
                return printer_utils_1.rejectAndConcat([ctx.Dot[0], ctx.This[0]]);
            }
            else if (ctx.Identifier) {
                var typeArguments = this.visit(ctx.typeArguments);
                return printer_utils_1.rejectAndConcat([ctx.Dot[0], typeArguments, ctx.Identifier[0]]);
            }
            var unqualifiedClassInstanceCreationExpression = this.visit(ctx.unqualifiedClassInstanceCreationExpression);
            return printer_utils_1.rejectAndConcat([
                ctx.Dot[0],
                unqualifiedClassInstanceCreationExpression
            ]);
        }
        return this.visitSingle(ctx, params);
    };
    ExpressionsPrettierVisitor.prototype.fqnOrRefType = function (ctx, params) {
        var fqnOrRefTypePartFirst = this.visit(ctx.fqnOrRefTypePartFirst);
        var fqnOrRefTypePartRest = this.mapVisit(ctx.fqnOrRefTypePartRest);
        var dims = this.visit(ctx.dims);
        var dots = ctx.Dot ? ctx.Dot : [];
        var isMethodInvocation = ctx.Dot && ctx.Dot.length === 1;
        if (params !== undefined &&
            params.shouldBreakBeforeFirstMethodInvocation === true) {
            // when fqnOrRefType is a method call from an object
            if (isMethodInvocation) {
                return printer_utils_1.rejectAndConcat([
                    prettier_builder_1.indent(printer_utils_1.rejectAndJoin(prettier_builder_1.concat([softline, dots[0]]), [
                        fqnOrRefTypePartFirst,
                        printer_utils_1.rejectAndJoinSeps(dots.slice(1), fqnOrRefTypePartRest),
                        dims
                    ]))
                ]);
                // otherwise it is a fully qualified name but we need to exclude when it is just a method call
            }
            else if (ctx.Dot) {
                return prettier_builder_1.indent(printer_utils_1.rejectAndConcat([
                    printer_utils_1.rejectAndJoinSeps(dots.slice(0, dots.length - 1), __spreadArray([
                        fqnOrRefTypePartFirst
                    ], fqnOrRefTypePartRest.slice(0, fqnOrRefTypePartRest.length - 1))),
                    softline,
                    printer_utils_1.rejectAndConcat([
                        dots[dots.length - 1],
                        fqnOrRefTypePartRest[fqnOrRefTypePartRest.length - 1]
                    ]),
                    dims
                ]));
            }
        }
        return printer_utils_1.rejectAndConcat([
            printer_utils_1.rejectAndJoinSeps(dots, __spreadArray([fqnOrRefTypePartFirst], fqnOrRefTypePartRest)),
            dims
        ]);
    };
    ExpressionsPrettierVisitor.prototype.fqnOrRefTypePartFirst = function (ctx) {
        var annotation = this.mapVisit(ctx.annotation);
        var fqnOrRefTypeCommon = this.visit(ctx.fqnOrRefTypePartCommon);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndJoin(" ", annotation),
            fqnOrRefTypeCommon
        ]);
    };
    ExpressionsPrettierVisitor.prototype.fqnOrRefTypePartRest = function (ctx) {
        var annotation = this.mapVisit(ctx.annotation);
        var fqnOrRefTypeCommon = this.visit(ctx.fqnOrRefTypePartCommon);
        var typeArguments = this.visit(ctx.typeArguments);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndJoin(" ", annotation),
            printer_utils_1.rejectAndConcat([typeArguments, fqnOrRefTypeCommon])
        ]);
    };
    ExpressionsPrettierVisitor.prototype.fqnOrRefTypePartCommon = function (ctx) {
        var keyWord = null;
        if (ctx.Identifier) {
            keyWord = ctx.Identifier[0];
        }
        else {
            keyWord = ctx.Super[0];
        }
        var typeArguments = this.visit(ctx.typeArguments);
        return printer_utils_1.rejectAndConcat([keyWord, typeArguments]);
    };
    ExpressionsPrettierVisitor.prototype.parenthesisExpression = function (ctx) {
        var expression = this.visit(ctx.expression);
        return printer_utils_1.putIntoBraces(expression, softline, ctx.LBrace[0], ctx.RBrace[0]);
    };
    ExpressionsPrettierVisitor.prototype.castExpression = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.primitiveCastExpression = function (ctx) {
        var primitiveType = this.visit(ctx.primitiveType);
        var unaryExpression = this.visit(ctx.unaryExpression);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndConcat([ctx.LBrace[0], primitiveType, ctx.RBrace[0]]),
            unaryExpression
        ]);
    };
    ExpressionsPrettierVisitor.prototype.referenceTypeCastExpression = function (ctx) {
        var referenceType = this.visit(ctx.referenceType);
        var additionalBound = this.mapVisit(ctx.additionalBound);
        var expression = ctx.lambdaExpression
            ? this.visit(ctx.lambdaExpression)
            : this.visit(ctx.unaryExpressionNotPlusMinus);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndConcat([ctx.LBrace[0], referenceType, ctx.RBrace[0]]),
            additionalBound,
            expression
        ]);
    };
    ExpressionsPrettierVisitor.prototype.newExpression = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.unqualifiedClassInstanceCreationExpression = function (ctx) {
        var typeArguments = this.visit(ctx.typeArguments);
        var classOrInterfaceTypeToInstantiate = this.visit(ctx.classOrInterfaceTypeToInstantiate);
        var content = utils_2.printArgumentListWithBraces.call(this, ctx.argumentList, ctx.RBrace[0], ctx.LBrace[0]);
        var classBody = this.visit(ctx.classBody);
        return printer_utils_1.rejectAndJoin(" ", [
            ctx.New[0],
            printer_utils_1.rejectAndConcat([
                typeArguments,
                classOrInterfaceTypeToInstantiate,
                content
            ]),
            classBody
        ]);
    };
    ExpressionsPrettierVisitor.prototype.classOrInterfaceTypeToInstantiate = function (ctx) {
        var _this = this;
        var tokens = printer_utils_1.sortAnnotationIdentifier(ctx.annotation, ctx.Identifier);
        var segments = [];
        var currentSegment = [];
        forEach_1.default(tokens, function (token) {
            if (utils_1.isAnnotationCstNode(token)) {
                currentSegment.push(_this.visit([token]));
            }
            else {
                currentSegment.push(token);
                segments.push(printer_utils_1.rejectAndJoin(" ", currentSegment));
                currentSegment = [];
            }
        });
        var typeArgumentsOrDiamond = this.visit(ctx.typeArgumentsOrDiamond);
        var dots = ctx.Dot ? ctx.Dot : [];
        return printer_utils_1.rejectAndConcat([
            printer_utils_1.rejectAndJoinSeps(dots, segments),
            typeArgumentsOrDiamond
        ]);
    };
    ExpressionsPrettierVisitor.prototype.typeArgumentsOrDiamond = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.diamond = function (ctx) {
        return prettier_builder_1.concat([ctx.Less[0], ctx.Greater[0]]);
    };
    ExpressionsPrettierVisitor.prototype.methodInvocationSuffix = function (ctx, params) {
        var isSingleLambda = expressions_utils_1.isArgumentListSingleLambda(ctx.argumentList);
        if (isSingleLambda) {
            return utils_2.printSingleLambdaInvocation.call(this, ctx.argumentList, ctx.RBrace[0], ctx.LBrace[0]);
        }
        var argumentList = this.visit(ctx.argumentList);
        if (params && params.shouldDedent) {
            return prettier_builder_1.dedent(printer_utils_1.putIntoBraces(argumentList, softline, ctx.LBrace[0], ctx.RBrace[0]));
        }
        return printer_utils_1.putIntoBraces(argumentList, softline, ctx.LBrace[0], ctx.RBrace[0]);
    };
    ExpressionsPrettierVisitor.prototype.argumentList = function (ctx, params) {
        var expressions = this.mapVisit(ctx.expression, params);
        var commas = ctx.Comma ? ctx.Comma.map(function (elt) { return prettier_builder_1.concat([elt, line]); }) : [];
        return printer_utils_1.rejectAndJoinSeps(commas, expressions);
    };
    ExpressionsPrettierVisitor.prototype.arrayCreationExpression = function (ctx) {
        var type = ctx.primitiveType
            ? this.visit(ctx.primitiveType)
            : this.visit(ctx.classOrInterfaceType);
        var suffix = ctx.arrayCreationDefaultInitSuffix
            ? this.visit(ctx.arrayCreationDefaultInitSuffix)
            : this.visit(ctx.arrayCreationExplicitInitSuffix);
        return printer_utils_1.rejectAndConcat([prettier_builder_1.concat([ctx.New[0], " "]), type, suffix]);
    };
    ExpressionsPrettierVisitor.prototype.arrayCreationDefaultInitSuffix = function (ctx) {
        var dimExprs = this.visit(ctx.dimExprs);
        var dims = this.visit(ctx.dims);
        return printer_utils_1.rejectAndConcat([dimExprs, dims]);
    };
    ExpressionsPrettierVisitor.prototype.arrayCreationExplicitInitSuffix = function (ctx) {
        var dims = this.visit(ctx.dims);
        var arrayInitializer = this.visit(ctx.arrayInitializer);
        return printer_utils_1.rejectAndJoin(" ", [dims, arrayInitializer]);
    };
    ExpressionsPrettierVisitor.prototype.dimExprs = function (ctx) {
        var dimExpr = this.mapVisit(ctx.dimExpr);
        return printer_utils_1.rejectAndConcat(dimExpr);
    };
    ExpressionsPrettierVisitor.prototype.dimExpr = function (ctx) {
        var annotations = this.mapVisit(ctx.annotation);
        var expression = this.visit(ctx.expression);
        return printer_utils_1.rejectAndJoin(" ", [
            printer_utils_1.rejectAndJoin(" ", annotations),
            printer_utils_1.rejectAndConcat([ctx.LSquare[0], expression, ctx.RSquare[0]])
        ]);
    };
    ExpressionsPrettierVisitor.prototype.classLiteralSuffix = function (ctx) {
        var squares = [];
        if (ctx.LSquare) {
            for (var i = 0; i < ctx.LSquare.length; i++) {
                squares.push(prettier_builder_1.concat([ctx.LSquare[i], ctx.RSquare[i]]));
            }
        }
        return printer_utils_1.rejectAndConcat(__spreadArray(__spreadArray([], squares), [ctx.Dot[0], ctx.Class[0]]));
    };
    ExpressionsPrettierVisitor.prototype.arrayAccessSuffix = function (ctx) {
        var expression = this.visit(ctx.expression);
        return printer_utils_1.rejectAndConcat([ctx.LSquare[0], expression, ctx.RSquare[0]]);
    };
    ExpressionsPrettierVisitor.prototype.methodReferenceSuffix = function (ctx) {
        var typeArguments = this.visit(ctx.typeArguments);
        var identifierOrNew = ctx.New ? ctx.New[0] : ctx.Identifier[0];
        return printer_utils_1.rejectAndConcat([ctx.ColonColon[0], typeArguments, identifierOrNew]);
    };
    ExpressionsPrettierVisitor.prototype.pattern = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.typePattern = function (ctx) {
        return this.visitSingle(ctx);
    };
    ExpressionsPrettierVisitor.prototype.identifyNewExpressionType = function () {
        return "identifyNewExpressionType";
    };
    ExpressionsPrettierVisitor.prototype.isLambdaExpression = function () {
        return "isLambdaExpression";
    };
    ExpressionsPrettierVisitor.prototype.isCastExpression = function () {
        return "isCastExpression";
    };
    ExpressionsPrettierVisitor.prototype.isPrimitiveCastExpression = function () {
        return "isPrimitiveCastExpression";
    };
    ExpressionsPrettierVisitor.prototype.isReferenceTypeCastExpression = function () {
        return "isReferenceTypeCastExpression";
    };
    ExpressionsPrettierVisitor.prototype.isRefTypeInMethodRef = function () {
        return "isRefTypeInMethodRef";
    };
    return ExpressionsPrettierVisitor;
}(base_cst_printer_1.BaseCstPrettierPrinter));
exports.ExpressionsPrettierVisitor = ExpressionsPrettierVisitor;
