/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier;

import com.hubspot.maven.plugins.prettier.AbstractPrettierMojo;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="write", threadSafe=true)
public class WriteMojo
extends AbstractPrettierMojo {
    private static final Predicate<String> COLORIZED_LINE = Pattern.compile("(\\x9B|\\x1B\\[)[0-?]*[ -/]*[@-~]").asPredicate();

    @Override
    protected String getPrettierCommand() {
        return "write";
    }

    @Override
    protected void handlePrettierLogLine(String line) {
        if (line.endsWith("ms") && !COLORIZED_LINE.test(line)) {
            this.getLog().info((CharSequence)("Reformatted file: " + line));
        }
    }

    @Override
    protected void handlePrettierNonZeroExit(int status) throws MojoExecutionException {
        throw new MojoExecutionException("Error trying to format code with prettier-java: " + status);
    }
}

