/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.dependency.scope;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.maven.plugins.dependency.scope.DependencyViolation;
import com.hubspot.maven.plugins.dependency.scope.TraversalContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class DependencyScopeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(property="useParallelDependencyResolution", defaultValue="true")
    private boolean useParallelDependencyResolution;
    @Parameter(defaultValue="false")
    private boolean linkToDocumentation;
    @Parameter(defaultValue="false")
    private boolean fail;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    private ListeningExecutorService executorService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.executorService = this.newExecutorService();
        DependencyNode node = this.buildDependencyNode();
        TraversalContext context = TraversalContext.newContextFor(node);
        ArrayList<ListenableFuture<Set<DependencyViolation>>> futures = new ArrayList<ListenableFuture<Set<DependencyViolation>>>();
        for (DependencyNode dependency : node.getChildren()) {
            if ("test".equals(dependency.getArtifact().getScope())) continue;
            TraversalContext subcontext = context.stepInto(this.project, dependency);
            futures.add(this.findViolations(dependency, subcontext));
        }
        Set<DependencyViolation> violations = DependencyScopeMojo.resolve((ListenableFuture<List<Set<DependencyViolation>>>)Futures.allAsList(futures));
        this.executorService.shutdown();
        if (!violations.isEmpty()) {
            this.printViolations(violations);
            if (this.fail) {
                throw new MojoFailureException("Test dependency scope issues found");
            }
        } else {
            this.getLog().info((CharSequence)"No test dependency scope issues found");
        }
    }

    private ListenableFuture<Set<DependencyViolation>> findViolations(final DependencyNode node, final TraversalContext context) {
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback(this.resolveArtifactDescriptor(node.getArtifact()), (FutureCallback)new FutureCallback<ArtifactDescriptorResult>(){

            public void onSuccess(ArtifactDescriptorResult artifactDescriptor) {
                try {
                    final Set violations = Sets.newConcurrentHashSet();
                    for (Dependency dependency : artifactDescriptor.getDependencies()) {
                        if (!DependencyScopeMojo.dependencyRequiredAtRuntime(dependency) || !context.isOverriddenToTestScope(dependency)) continue;
                        violations.add(new DependencyViolation(context, dependency));
                    }
                    if (node.getChildren().isEmpty()) {
                        future.set((Object)violations);
                        return;
                    }
                    final CountDownLatch latch = new CountDownLatch(node.getChildren().size());
                    for (DependencyNode child : node.getChildren()) {
                        TraversalContext subcontext = context.stepInto(artifactDescriptor, child);
                        Futures.addCallback((ListenableFuture)DependencyScopeMojo.this.findViolations(child, subcontext), (FutureCallback)new FutureCallback<Set<DependencyViolation>>(){

                            public void onSuccess(Set<DependencyViolation> result) {
                                try {
                                    violations.addAll(result);
                                }
                                finally {
                                    latch.countDown();
                                    if (latch.getCount() == 0L) {
                                        future.set((Object)violations);
                                    }
                                }
                            }

                            public void onFailure(Throwable t) {
                                future.setException(t);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    future.setException(t);
                }
            }

            public void onFailure(Throwable t) {
                future.setException(t);
            }
        });
        return future;
    }

    private DependencyNode buildDependencyNode() throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            return this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, artifact -> !"provided".equals(artifact.getScope()) && !"system".equals(artifact.getScope()));
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Error building dependency graph", (Exception)((Object)e));
        }
    }

    private ListenableFuture<ArtifactDescriptorResult> resolveArtifactDescriptor(Artifact artifact) {
        return this.executorService.submit(() -> {
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(DependencyScopeMojo.toAether(artifact), this.project.getRemoteProjectRepositories(), null);
            try {
                return this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, request);
            }
            catch (ArtifactDescriptorException e) {
                String message = "Error resolving descriptor for artifact " + DependencyScopeMojo.readableGATCV(artifact);
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
        });
    }

    private void printViolations(Set<DependencyViolation> violations) {
        HashMap<String, TreeSet<DependencyViolation>> violationsByDependency = new HashMap<String, TreeSet<DependencyViolation>>();
        for (DependencyViolation dependencyViolation : violations) {
            String key = DependencyScopeMojo.readableGATC(dependencyViolation.getDependency());
            if (!violationsByDependency.containsKey(key)) {
                violationsByDependency.put(key, new TreeSet<DependencyViolation>(DependencyScopeMojo.artifactNameComparator()));
            }
            ((Set)violationsByDependency.get(key)).add(dependencyViolation);
        }
        for (Map.Entry entry : violationsByDependency.entrySet()) {
            StringBuilder message = new StringBuilder();
            message.append("Found a problem with test-scoped dependency ").append((String)entry.getKey());
            for (DependencyViolation violation : (Set)entry.getValue()) {
                message.append("\n").append("  ").append("Scope ").append(violation.getDependency().getScope()).append(" was expected by artifact: ").append(DependencyScopeMojo.readableGATCV(violation.getSource().currentArtifact()));
                if (!this.verbose) continue;
                message.append("\n  Via chain:");
                StringBuilder prefix = new StringBuilder("  ");
                for (Artifact artifact : violation.getSource().path()) {
                    message.append("\n").append((CharSequence)prefix).append("- ").append(artifact.toString());
                    prefix.append("  ");
                }
            }
            if (this.fail) {
                this.getLog().error((CharSequence)message);
                continue;
            }
            this.getLog().warn((CharSequence)message);
        }
        if (this.linkToDocumentation) {
            StringBuilder message = new StringBuilder("For information on how to fix these issues, see here:").append("\n  ").append("https://github.com/HubSpot/dependency-scope-maven-plugin#how-to-fix-issues");
            this.getLog().info((CharSequence)message);
        }
    }

    private ListeningExecutorService newExecutorService() {
        if (this.useParallelDependencyResolution) {
            this.getLog().debug((CharSequence)"Using parallel dependency resolution");
            return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors() * 5, 20), new ThreadFactoryBuilder().setNameFormat("dependency-project-builder-%s").setDaemon(true).build()));
        }
        this.getLog().debug((CharSequence)"Using single-threaded dependency resolution");
        return MoreExecutors.newDirectExecutorService();
    }

    private static boolean dependencyRequiredAtRuntime(Dependency dependency) {
        if (dependency.isOptional()) {
            return false;
        }
        String scope = dependency.getScope();
        return "compile".equals(scope) || "runtime".equals(scope);
    }

    private static Set<DependencyViolation> resolve(ListenableFuture<List<Set<DependencyViolation>>> future) throws MojoExecutionException {
        try {
            return Sets.newHashSet((Iterable)Iterables.concat((Iterable)((Iterable)future.get())));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Interrupted while checking dependency scopes", (Exception)e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), MojoExecutionException.class);
            throw new MojoExecutionException("Error while checking dependency scopes", e.getCause());
        }
    }

    private static Comparator<DependencyViolation> artifactNameComparator() {
        return Comparator.comparing(violation -> DependencyScopeMojo.readableGATCV(violation.getSource().currentArtifact()));
    }

    private static String readableGATC(Dependency dependency) {
        org.eclipse.aether.artifact.Artifact artifact = dependency.getArtifact();
        String name = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (!"jar".equals(artifact.getExtension())) {
            name = name + ":" + artifact.getExtension();
        }
        if (!artifact.getClassifier().isEmpty()) {
            name = name + ":" + artifact.getClassifier();
        }
        return name;
    }

    private static String readableGATCV(Artifact artifact) {
        String name = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (artifact.getType() != null && !"jar".equals(artifact.getType())) {
            name = name + ":" + artifact.getType();
        }
        if (artifact.getClassifier() != null) {
            name = name + ":" + artifact.getClassifier();
        }
        artifact.isSnapshot();
        name = name + ":" + artifact.getBaseVersion();
        return name;
    }

    private static org.eclipse.aether.artifact.Artifact toAether(Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), null, artifact.getFile());
    }
}

