/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.hubspot.algebra.HttpResultWrapper;
import com.hubspot.algebra.Result;
import com.hubspot.immutables.styles.HubSpotStyle;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@HubSpotStyle
public abstract class AbstractHttpResultWrapper<T, E> {
    public static <T, E> HttpResultWrapper<T, E> ok(T ok) {
        return HttpResultWrapper.builder().setOkResultMaybe(ok).build();
    }

    public static <T, E> HttpResultWrapper<T, E> err(E err, int statusCode) {
        return HttpResultWrapper.builder().setErrResultMaybe(err).setHttpStatusCode(statusCode).build();
    }

    @JsonIgnore
    public Result<T, E> unwrap() {
        if (this.getOkResultMaybe().isPresent()) {
            return Result.ok(this.getOkResultMaybe().get());
        }
        if (this.getErrResultMaybe().isPresent()) {
            return Result.err(this.getErrResultMaybe().get());
        }
        throw new IllegalStateException("Shouldn't be possible to get here.");
    }

    public abstract Optional<T> getOkResultMaybe();

    public abstract Optional<E> getErrResultMaybe();

    @Value.Default
    public int getHttpStatusCode() {
        return 200;
    }

    @Value.Check
    void checkIsOkOrErr() {
        Preconditions.checkState((boolean)Boolean.logicalXor(this.getOkResultMaybe().isPresent(), this.getErrResultMaybe().isPresent()), (Object)"Exactly one of ok/err must be present");
    }
}

