/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hubspot.algebra.NullValue;
import com.hubspot.algebra.Result;
import com.hubspot.algebra.ResultModule;
import com.hubspot.algebra.Results;
import java.io.Closeable;
import java.io.IOException;

public class ResultDeserializer
extends StdDeserializer<Result<?, ?>> {
    private final JavaType okType;
    private final JavaType errType;

    public ResultDeserializer(JavaType valueType) {
        super(valueType);
        this.okType = valueType.getBindings().getBoundType(0);
        this.errType = valueType.getBindings().getBoundType(1);
    }

    public Result<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        ObjectNode node = (ObjectNode)codec.readTree(p);
        JsonNode caseNode = node.get("@result");
        if (caseNode == null) {
            throw new JsonMappingException((Closeable)p, String.format("Could not deserialize input as a Result. The required %s field is missing.", "@result"));
        }
        String resultCase = caseNode.textValue();
        node.remove("@result");
        if (resultCase.equalsIgnoreCase(ResultModule.Case.ERR.toString())) {
            Object err = ResultDeserializer.deserializeValue(codec, node, "@error", this.errType);
            return Results.err((Object)err);
        }
        Object ok = ResultDeserializer.deserializeValue(codec, node, "@ok", this.okType);
        return Results.ok((Object)ok);
    }

    private static Object deserializeValue(ObjectCodec codec, ObjectNode node, String fieldName, JavaType type) throws IOException {
        ObjectNode valueNode;
        Object object = valueNode = node.has(fieldName) ? node.get(fieldName) : node;
        if (type.getRawClass() == NullValue.class && valueNode.isNull()) {
            return NullValue.get();
        }
        return codec.readValue(valueNode.traverse(codec), (ResolvedType)type);
    }
}

