/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.hubspot.algebra.Result;
import com.hubspot.algebra.ResultModule;
import java.io.IOException;
import java.util.Map;

public class ResultSerializer
extends StdSerializer<Result<?, ?>> {
    ResultSerializer(JavaType type) {
        super(type);
    }

    public void serialize(Result<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        if (value.isErr()) {
            Object err = value.unwrapErrOrElseThrow();
            ResultSerializer.serializeValue("@error", err, gen, provider);
            gen.writeStringField("@result", ResultModule.Case.ERR.name());
        } else {
            Object ok = value.unwrapOrElseThrow();
            ResultSerializer.serializeValue("@ok", ok, gen, provider);
            gen.writeStringField("@result", ResultModule.Case.OK.name());
        }
        gen.writeEndObject();
    }

    private static void serializeValue(String fieldName, Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Object flattenedValue = ResultSerializer.flattenValue(value);
        JsonSerializer serializer = provider.findTypedValueSerializer(flattenedValue.getClass(), true, null).unwrappingSerializer(null);
        if (!serializer.isUnwrappingSerializer()) {
            gen.writeFieldName(fieldName);
        }
        serializer.serialize(flattenedValue, gen, provider);
    }

    private static Object flattenValue(Object value) {
        if (value instanceof Map) {
            return new MapFlattener((Map)value);
        }
        if (value instanceof Multimap) {
            return new MapFlattener(((Multimap)value).asMap());
        }
        if (value instanceof Table) {
            return new MapFlattener(((Table)value).rowMap());
        }
        return value;
    }

    private static class MapFlattener {
        private final Map<?, ?> map;

        private MapFlattener(Map<?, ?> map) {
            this.map = map;
        }

        @JsonAnyGetter
        public Map<?, ?> getMap() {
            return this.map;
        }
    }
}

