/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.algebra;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hubspot.algebra.Result;
import com.hubspot.algebra.ResultModule;
import com.hubspot.algebra.Results;
import java.io.IOException;

public class ResultDeserializer
extends StdDeserializer<Result<?, ?>> {
    private final Class<?> okClass;
    private final Class<?> errClass;

    public ResultDeserializer(JavaType valueType) {
        super(valueType);
        this.okClass = valueType.getBindings().getBoundType(0).getRawClass();
        this.errClass = valueType.getBindings().getBoundType(1).getRawClass();
    }

    public Result<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper objectMapper = (ObjectMapper)p.getCodec();
        ObjectNode node = (ObjectNode)objectMapper.readTree(p);
        String resultCase = node.findValue("@result").textValue();
        node.remove("@result");
        if (resultCase.equalsIgnoreCase(ResultModule.Case.ERR.toString())) {
            if (node.has("@error")) {
                Object err = objectMapper.treeToValue((TreeNode)node.findValue("@error"), this.errClass);
                return Results.err((Object)err);
            }
            Object err = objectMapper.treeToValue((TreeNode)node, this.errClass);
            return Results.err((Object)err);
        }
        Object ok = objectMapper.treeToValue((TreeNode)node, this.okClass);
        return Results.ok((Object)ok);
    }
}

