/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.StorageClassEnum;
import java.util.Date;
import java.util.Map;

public class ObjectMetadata
extends HeaderResponse {
    private Date lastModified;
    private Long contentLength;
    private String contentType;
    private String contentEncoding;
    private String etag;
    private String contentMd5;
    private StorageClassEnum storageClass;
    private String webSiteRedirectLocation;
    private long nextPosition = -1L;
    private boolean appendable;

    public boolean isAppendable() {
        return this.appendable;
    }

    public void setAppendable(boolean appendable) {
        this.appendable = appendable;
    }

    public long getNextPosition() {
        return this.nextPosition;
    }

    public void setNextPosition(long nextPosition) {
        this.nextPosition = nextPosition;
    }

    public Map<String, Object> getMetadata() {
        return this.getResponseHeaders();
    }

    public void addUserMetadata(String key, String value) {
        this.getMetadata().put(key, value);
    }

    public Object getUserMetadata(String key) {
        return this.getMetadata().get(key);
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String objEtag) {
        this.etag = objEtag;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.responseHeaders = metadata;
    }

    public Date getLastModified() {
        return ServiceUtils.cloneDateIgnoreNull(this.lastModified);
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = ServiceUtils.cloneDateIgnoreNull(lastModified);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Deprecated
    public String getStorageClass() {
        return this.storageClass != null ? this.storageClass.getCode() : null;
    }

    @Deprecated
    public void setStorageClass(String storageClass) {
        this.storageClass = StorageClassEnum.getValueFromCode(storageClass);
    }

    public StorageClassEnum getObjectStorageClass() {
        return this.storageClass;
    }

    public void setObjectStorageClass(StorageClassEnum storageClass) {
        this.storageClass = storageClass;
    }

    public Object getValue(String name) {
        for (Map.Entry<String, Object> entry : this.getMetadata().entrySet()) {
            if (!this.isEqualsIgnoreCase(entry.getKey(), name)) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean isEqualsIgnoreCase(String key1, String key2) {
        if (key1 == null && key2 == null) {
            return true;
        }
        if (key1 == null || key2 == null) {
            return false;
        }
        return key1.equalsIgnoreCase(key2);
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public String getWebSiteRedirectLocation() {
        return this.webSiteRedirectLocation;
    }

    public void setWebSiteRedirectLocation(String webSiteRedirectLocation) {
        this.webSiteRedirectLocation = webSiteRedirectLocation;
    }

    @Override
    public String toString() {
        return "ObjectMetadata [metadata=" + this.getMetadata() + ", lastModified=" + this.lastModified + ", contentLength=" + this.contentLength + ", contentType=" + this.contentType + ", contentEncoding=" + this.contentEncoding + ", etag=" + this.etag + ", contentMd5=" + this.contentMd5 + ", storageClass=" + (Object)((Object)this.storageClass) + ", webSiteRedirectLocation=" + this.webSiteRedirectLocation + ", nextPosition=" + this.nextPosition + ", appendable=" + this.appendable + "]";
    }
}

