/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.task.UploadTaskProgressStatus;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.UploadObjectsProgressListener;

public class PutObjectTask
implements Runnable {
    protected ObsClient obsClient;
    protected String bucketName;
    private UploadObjectsProgressListener progressListener;
    private int taskProgressInterval;
    private PutObjectRequest taskRequest;
    private TaskCallback<PutObjectResult, PutObjectBasicRequest> callback;
    private UploadTaskProgressStatus taskStatus;

    public PutObjectTask(ObsClient obsClient, String bucketName, PutObjectRequest taskRequest, TaskCallback<PutObjectResult, PutObjectBasicRequest> callback, UploadObjectsProgressListener progressListener, UploadTaskProgressStatus progressStatus, int taskProgressInterval) {
        this.obsClient = obsClient;
        this.bucketName = bucketName;
        this.taskRequest = taskRequest;
        this.callback = callback;
        this.progressListener = progressListener;
        this.taskStatus = progressStatus;
        this.taskProgressInterval = taskProgressInterval;
    }

    public ObsClient getObsClient() {
        return this.obsClient;
    }

    public void setObsClient(ObsClient obsClient) {
        this.obsClient = obsClient;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public UploadObjectsProgressListener getUploadObjectsProgressListener() {
        return this.progressListener;
    }

    public void setUploadObjectsProgressListener(UploadObjectsProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public int getTaskProgressInterval() {
        return this.taskProgressInterval;
    }

    public void setTaskProgressInterval(int taskProgressInterval) {
        this.taskProgressInterval = taskProgressInterval;
    }

    public PutObjectRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void setTaskRequest(PutObjectRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    public TaskCallback<PutObjectResult, PutObjectBasicRequest> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<PutObjectResult, PutObjectBasicRequest> callback) {
        this.callback = callback;
    }

    public UploadTaskProgressStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(UploadTaskProgressStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    private void putObjects() {
        try {
            PutObjectResult result = this.obsClient.putObject(this.taskRequest);
            this.taskStatus.succeedTaskIncrement();
            PutObjectResult ret = new PutObjectResult(result.getBucketName(), result.getObjectKey(), result.getEtag(), result.getVersionId(), result.getObjectUrl(), result.getResponseHeaders(), result.getStatusCode());
            this.callback.onSuccess(ret);
        }
        catch (ObsException e) {
            this.taskStatus.failTaskIncrement();
            this.callback.onException(e, this.taskRequest);
        }
        finally {
            String key;
            ProgressStatus status;
            this.taskStatus.execTaskIncrement();
            if (this.progressListener != null) {
                if (this.taskStatus.getExecTaskNum() % this.taskProgressInterval == 0) {
                    this.progressListener.progressChanged(this.taskStatus);
                }
                if (this.taskStatus.getExecTaskNum() == this.taskStatus.getTotalTaskNum()) {
                    this.progressListener.progressChanged(this.taskStatus);
                }
            }
            if ((status = this.taskStatus.getTaskStatus(key = this.taskRequest.getObjectKey())) != null) {
                this.taskStatus.addEndingTaskSize(status.getTransferredBytes());
            }
            this.taskStatus.removeTaskTable(key);
        }
    }

    @Override
    public void run() {
        this.putObjects();
    }
}

